/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.kew.plugin.PluginConfig;
import org.kuali.rice.kew.plugin.PluginException;

public class PluginConfigParser {
    private static final String PARAMETER_TAG = "parameter";
    private static final String LISTENER_TAG = "listener";
    private static final String LISTENER_CLASS_TAG = "listener-class";
    private static final String RESOURCE_LOADER_TAG = "resourceLoader";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String CLASS_ATTRIBUTE = "class";

    public PluginConfig parse(File configFile, Config parentConfig) throws IOException, XmlException {
        return this.parse(configFile.toURI().toURL(), parentConfig);
    }

    public PluginConfig parse(URL url, Config parentConfig) throws IOException, XmlException {
        SAXBuilder builder = new SAXBuilder(false);
        try {
            Document doc = builder.build(url);
            Element root = doc.getRootElement();
            PluginConfig pluginConfig = new PluginConfig(url, parentConfig);
            this.parseResourceLoader(root, pluginConfig);
            this.parseListeners(root, pluginConfig);
            return pluginConfig;
        }
        catch (JDOMException e) {
            throw new PluginException("Error when parsing the plugin config file.", e);
        }
    }

    public void parseResourceLoader(Element element, PluginConfig pluginConfig) throws XmlException {
        List loaderElements = element.getChildren(RESOURCE_LOADER_TAG);
        if (loaderElements.size() > 1) {
            throw new XmlException("Only one <resourceLoader> tag may be defined.");
        }
        if (!loaderElements.isEmpty()) {
            Element loaderElement = (Element)loaderElements.get(0);
            String attributeClass = loaderElement.getAttributeValue(CLASS_ATTRIBUTE);
            if (StringUtils.isEmpty((String)attributeClass)) {
                throw new XmlException("<resourceLoader> element must define a 'class' attribute.");
            }
            pluginConfig.setResourceLoaderClassname(attributeClass);
        }
    }

    public void parseListeners(Element element, PluginConfig pluginConfig) throws XmlException {
        List listeners = element.getChildren(LISTENER_TAG);
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            pluginConfig.addListener(this.parseListenerProperties((Element)iterator.next()));
        }
    }

    private String parseListenerProperties(Element element) throws XmlException {
        String listenerClass = element.getChildText(LISTENER_CLASS_TAG);
        if (StringUtils.isEmpty((String)listenerClass)) {
            throw new XmlException("Listener Class tag must have a class property defined");
        }
        return listenerClass;
    }

    public Map parseParameters(Element element) throws XmlException {
        HashMap<String, String> parsedParms = new HashMap<String, String>();
        List parameters = element.getChildren(PARAMETER_TAG);
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            String[] parm = this.parseParameter((Element)iterator.next());
            parsedParms.put(parm[0], parm[1]);
        }
        return parsedParms;
    }

    private String[] parseParameter(Element element) throws XmlException {
        String name = element.getAttributeValue(NAME_ATTRIBUTE);
        String value = element.getAttributeValue(VALUE_ATTRIBUTE);
        if (StringUtils.isEmpty((String)name)) {
            throw new XmlException("Parameter tag must have a name attribute defined");
        }
        if (StringUtils.isEmpty((String)value)) {
            throw new XmlException("Parameter tag must have a value attribute defined");
        }
        return new String[]{name, value};
    }
}

