/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.plugin.Reloadable;

public class Reloader
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Reloader.class);
    private final Set<Reloadable> reloadables = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOG.debug((Object)"Checking if any reloading is necessary...");
            Set<Reloadable> set = this.reloadables;
            synchronized (set) {
                for (Reloadable reloadable : this.reloadables) {
                    LOG.debug((Object)("Checking reloadable: " + reloadable));
                    if (!reloadable.isReloadable() || !reloadable.isReloadNeeded()) continue;
                    LOG.info((Object)("Reloading: " + reloadable));
                    reloadable.reload();
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to reload plugin.", t);
        }
    }

    public void addReloadable(Reloadable reloadable) {
        this.reloadables.add(reloadable);
    }

    public void removeReloadable(Reloadable reloadable) {
        this.reloadables.remove(reloadable);
    }

    public Set<Reloadable> getReloadables() {
        return this.reloadables;
    }
}

