/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.kew.plugin.BasePluginRegistry;
import org.kuali.rice.kew.plugin.HotDeployer;
import org.kuali.rice.kew.plugin.PluginEnvironment;
import org.kuali.rice.kew.plugin.PluginNameComparator;
import org.kuali.rice.kew.plugin.PluginUtils;
import org.kuali.rice.kew.plugin.Reloader;
import org.kuali.rice.kew.plugin.ZipFilePluginLoader;

public class ServerPluginRegistry
extends BasePluginRegistry {
    private static final Logger LOG = Logger.getLogger(ServerPluginRegistry.class);
    private List<String> pluginDirectories = new ArrayList<String>();
    private File sharedPluginDirectory;
    private Reloader reloader;
    private HotDeployer hotDeployer;
    private ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> reloaderFuture;
    private ScheduledFuture<?> hotDeployerFuture;

    public ServerPluginRegistry() {
        super(new QName(CoreConfigHelper.getApplicationId(), "pluginRegistryResourceLoader"));
    }

    public void start() throws Exception {
        if (!this.isStarted()) {
            LOG.info((Object)"Starting server Plugin Registry...");
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, new KEWThreadFactory());
            this.sharedPluginDirectory = this.loadSharedPlugin();
            this.reloader = new Reloader();
            this.hotDeployer = new HotDeployer(this, this.sharedPluginDirectory, this.pluginDirectories);
            this.loadPlugins(this.sharedPluginDirectory);
            this.reloaderFuture = this.scheduledExecutor.scheduleWithFixedDelay(this.reloader, 5L, 5L, TimeUnit.SECONDS);
            this.hotDeployerFuture = this.scheduledExecutor.scheduleWithFixedDelay(this.hotDeployer, 5L, 5L, TimeUnit.SECONDS);
            super.start();
            LOG.info((Object)"...server Plugin Registry successfully started.");
        }
    }

    public void stop() throws Exception {
        if (this.isStarted()) {
            LOG.info((Object)"Stopping server Plugin Registry...");
            this.stopReloader();
            this.stopHotDeployer();
            this.reloader = null;
            this.hotDeployer = null;
            if (this.scheduledExecutor != null) {
                this.scheduledExecutor.shutdownNow();
                this.scheduledExecutor = null;
            }
            super.stop();
            LOG.info((Object)"...server Plugin Registry successfully stopped.");
        }
    }

    protected void stopReloader() {
        if (this.reloaderFuture != null) {
            if (!this.reloaderFuture.cancel(true)) {
                LOG.warn((Object)"Failed to cancel the plugin reloader.");
            }
            this.reloaderFuture = null;
        }
    }

    protected void stopHotDeployer() {
        if (this.hotDeployerFuture != null) {
            if (!this.hotDeployerFuture.cancel(true)) {
                LOG.warn((Object)"Failed to cancel the hot deployer.");
            }
            this.hotDeployerFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPlugins(File sharedPluginDirectory) {
        TreeMap<String, File> pluginLocations = new TreeMap<String, File>(new PluginNameComparator());
        PluginUtils.PluginZipFileFilter pluginFilter = new PluginUtils.PluginZipFileFilter();
        HashSet<File> visitedFiles = new HashSet<File>();
        for (String pluginDir : this.pluginDirectories) {
            LOG.info((Object)("Reading plugins from " + pluginDir));
            File file = new File(pluginDir);
            if (visitedFiles.contains(file)) {
                LOG.info((Object)("Skipping visited directory: " + pluginDir));
                continue;
            }
            visitedFiles.add(file);
            if (!file.exists() || !file.isDirectory()) {
                LOG.warn((Object)(file.getAbsoluteFile() + " is not a valid plugin directory."));
                continue;
            }
            File[] pluginZips = file.listFiles(pluginFilter);
            for (int i = 0; i < pluginZips.length; ++i) {
                File pluginZip = pluginZips[i];
                int indexOf = pluginZip.getName().lastIndexOf(".zip");
                String pluginName = pluginZip.getName().substring(0, indexOf);
                if (pluginLocations.containsKey(pluginName)) {
                    LOG.warn((Object)("There already exists an installed plugin with the name '" + pluginName + "', ignoring plugin " + pluginZip.getAbsolutePath()));
                    continue;
                }
                pluginLocations.put(pluginName, pluginZip);
            }
        }
        for (String pluginName : pluginLocations.keySet()) {
            File pluginZipFile = (File)pluginLocations.get(pluginName);
            try {
                LOG.info((Object)("Loading plugin '" + pluginName + "'"));
                ClassLoader parentClassLoader = ClassLoaderUtils.getDefaultClassLoader();
                Config parentConfig = ConfigContext.getCurrentContextConfig();
                ZipFilePluginLoader loader = new ZipFilePluginLoader(pluginZipFile, sharedPluginDirectory, parentClassLoader, parentConfig);
                PluginEnvironment environment = new PluginEnvironment(loader, this);
                try {
                    environment.load();
                }
                finally {
                    this.addPluginEnvironment(environment);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to read workflow plugin '" + pluginName + "'"), (Throwable)e);
            }
        }
    }

    @Override
    public void addPluginEnvironment(PluginEnvironment pluginEnvironment) {
        super.addPluginEnvironment(pluginEnvironment);
        this.reloader.addReloadable(pluginEnvironment);
    }

    @Override
    public PluginEnvironment removePluginEnvironment(String pluginName) {
        PluginEnvironment environment = super.removePluginEnvironment(pluginName);
        this.reloader.removeReloadable(environment);
        return environment;
    }

    public File loadSharedPlugin() {
        return PluginUtils.findSharedDirectory(this.pluginDirectories);
    }

    public void setPluginDirectories(List<String> pluginDirectories) {
        this.pluginDirectories = pluginDirectories;
    }

    public void setSharedPluginDirectory(File sharedPluginDirectory) {
        this.sharedPluginDirectory = sharedPluginDirectory;
    }

    protected HotDeployer getHotDeployer() {
        return this.hotDeployer;
    }

    protected Reloader getReloader() {
        return this.reloader;
    }

    private static class KEWThreadFactory
    implements ThreadFactory {
        private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        private KEWThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.defaultThreadFactory.newThread(runnable);
            thread.setName("ServerPluginRegistry-" + thread.getName());
            return thread;
        }
    }
}

