/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routemodule;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleResponsibilityContract;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routemodule.FlexRMAdapter;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.xmlrouting.GenericXMLRuleAttribute;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.xml.RuleXmlParser;

public class InlineRequestsRouteModule
extends FlexRMAdapter {
    private static final Logger LOG = Logger.getLogger(InlineRequestsRouteModule.class);

    @Override
    public List<ActionRequestValue> findActionRequests(RouteContext context) throws Exception {
        Element e;
        ArrayList<ActionRequestValue> actionRequests = new ArrayList<ActionRequestValue>();
        RouteNodeInstance currentNode = context.getNodeInstance();
        String contentFragment = currentNode.getRouteNode().getContentFragment();
        Document doc = XmlHelper.trimSAXXml((InputStream)new ByteArrayInputStream(contentFragment.getBytes()));
        Element root = doc.getRootElement();
        ArrayList<String> ruleAttributeNames = new ArrayList<String>();
        ArrayList<String> ruleAttributeClassNames = new ArrayList<String>();
        ArrayList<String> xpathExpressions = new ArrayList<String>();
        Element ruleAttributes = root.getChild("ruleAttributes");
        if (ruleAttributes != null) {
            for (Object o : ruleAttributes.getChildren("name")) {
                e = (Element)o;
                ruleAttributeNames.add(e.getText());
            }
            for (Object o : ruleAttributes.getChildren("className")) {
                e = (Element)o;
                ruleAttributeClassNames.add(e.getText());
            }
        }
        for (Object o : root.getChildren("match")) {
            e = (Element)o;
            xpathExpressions.add(e.getText());
        }
        if (ruleAttributeNames.isEmpty() && ruleAttributeClassNames.isEmpty() && xpathExpressions.isEmpty()) {
            throw new RuntimeException("Match xpath expression not specified (should be parse-time exception...)");
        }
        ArrayList<WorkflowRuleAttribute> attributes = new ArrayList<WorkflowRuleAttribute>();
        for (String attributeName : ruleAttributeNames) {
            attributes.add(this.getRuleAttributeByName(attributeName));
        }
        for (String attributeClassName : ruleAttributeClassNames) {
            attributes.addAll(this.getRuleAttributeByClassName(attributeClassName));
        }
        if (attributes.isEmpty() && xpathExpressions.isEmpty()) {
            return actionRequests;
        }
        Boolean match = Boolean.TRUE;
        if (!xpathExpressions.isEmpty()) {
            XPath xpath = XPathHelper.newXPath();
            for (String xpathExpression : xpathExpressions) {
                match = match & (Boolean)xpath.evaluate(xpathExpression, context.getDocumentContent().getDocument(), XPathConstants.BOOLEAN);
            }
        }
        for (WorkflowRuleAttribute workflowAttribute : attributes) {
            match = match & workflowAttribute.isMatch(context.getDocumentContent(), Collections.emptyList());
        }
        if (!match.booleanValue()) {
            return actionRequests;
        }
        ArrayList<RuleResponsibility> responsibilities = new ArrayList<RuleResponsibility>();
        RuleXmlParser parser = new RuleXmlParser();
        ActionRequestFactory arf = new ActionRequestFactory(context.getDocument(), currentNode);
        RuleBaseValues fakeRule = new RuleBaseValues();
        fakeRule.setName("fakeRule");
        fakeRule.setActive(Boolean.TRUE);
        fakeRule.setCurrentInd(Boolean.TRUE);
        fakeRule.setDescription("a fake rule");
        fakeRule.setForceAction(Boolean.TRUE);
        fakeRule.setId(null);
        for (Object o : root.getChildren("responsibility", XmlConstants.RULE_NAMESPACE)) {
            Element e2 = (Element)o;
            RuleResponsibilityBo responsibility = parser.parseResponsibility(e2, fakeRule);
            responsibility.setResponsibilityId("0");
            responsibilities.add(RuleResponsibility.Builder.create((RuleResponsibilityContract)responsibility).build());
        }
        if (responsibilities.isEmpty()) {
            throw new RuntimeException("No responsibilities found on node " + currentNode.getName());
        }
        this.makeActionRequests(arf, responsibilities, context, RuleBaseValues.to(fakeRule), context.getDocument(), null, null);
        actionRequests.addAll(arf.getRequestGraphs());
        return actionRequests;
    }

    @Override
    public String toString() {
        return "InlineRequestsRouteModule";
    }

    private WorkflowRuleAttribute getRuleAttributeByName(String ruleAttributeName) {
        return this.materializeRuleAttribute(KewApiServiceLocator.getExtensionRepositoryService().getExtensionByName(ruleAttributeName));
    }

    private List<WorkflowRuleAttribute> getRuleAttributeByClassName(String ruleAttributeClassName) {
        List extensionDefinitions = KewApiServiceLocator.getExtensionRepositoryService().getExtensionsByResourceDescriptor(ruleAttributeClassName);
        ArrayList<WorkflowRuleAttribute> workflowRuleAttributes = new ArrayList<WorkflowRuleAttribute>();
        for (ExtensionDefinition extension : extensionDefinitions) {
            workflowRuleAttributes.add(this.materializeRuleAttribute(extension));
        }
        return workflowRuleAttributes;
    }

    private WorkflowRuleAttribute materializeRuleAttribute(ExtensionDefinition extensionDefinition) {
        if (extensionDefinition != null) {
            if ("RuleAttribute".equals(extensionDefinition.getType())) {
                ObjectDefinition objDef = new ObjectDefinition(extensionDefinition.getResourceDescriptor(), extensionDefinition.getApplicationId());
                return (WorkflowRuleAttribute)GlobalResourceLoader.getObject((ObjectDefinition)objDef);
            }
            if ("RuleXmlAttribute".equals(extensionDefinition.getType())) {
                ObjectDefinition objDef = new ObjectDefinition(extensionDefinition.getResourceDescriptor(), extensionDefinition.getApplicationId());
                WorkflowRuleAttribute workflowAttribute = (WorkflowRuleAttribute)GlobalResourceLoader.getObject((ObjectDefinition)objDef);
                ((GenericXMLRuleAttribute)workflowAttribute).setExtensionDefinition(extensionDefinition);
                return workflowAttribute;
            }
        }
        return null;
    }
}

