/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.kew.api.identity.Id;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.GenericWorkflowAttribute;
import org.kuali.rice.kew.rule.QualifiedRoleName;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;
import org.kuali.rice.kew.rule.RoleAttribute;

public abstract class GenericRoleAttribute
extends GenericWorkflowAttribute
implements RoleAttribute {
    public GenericRoleAttribute() {
        super(null);
    }

    public GenericRoleAttribute(String uniqueName) {
        super(uniqueName);
    }

    @Override
    public boolean isMatch(DocumentContent docContent, List<RuleExtension> ruleExtensions) {
        return true;
    }

    @Override
    public List<String> getQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        List<QualifiedRoleName> qualifiedRoleNames = this.generateQualifiedRoleNames(roleName, documentContent);
        if (qualifiedRoleNames == null) {
            return null;
        }
        ArrayList<String> q = new ArrayList<String>(qualifiedRoleNames.size());
        for (QualifiedRoleName qrn : qualifiedRoleNames) {
            q.add(qrn.encode());
        }
        return q;
    }

    protected List<QualifiedRoleName> generateQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        List<String> qualifiers = this.getRoleNameQualifiers(roleName, documentContent);
        if (qualifiers == null) {
            qualifiers = new ArrayList<String>(0);
        }
        ArrayList<QualifiedRoleName> qualifiedRoleNames = new ArrayList<QualifiedRoleName>(qualifiers.size());
        for (String qualifier : qualifiers) {
            qualifiedRoleNames.add(new QualifiedRoleName(roleName, qualifier));
        }
        return qualifiedRoleNames;
    }

    protected List<String> getRoleNameQualifiers(String roleName, DocumentContent documentContent) {
        return null;
    }

    @Override
    public ResolvedQualifiedRole resolveQualifiedRole(RouteContext routeContext, String roleName, String qualifiedRoleName) {
        QualifiedRoleName qrn = QualifiedRoleName.parse(qualifiedRoleName);
        return this.resolveQualifiedRole(routeContext, qrn);
    }

    protected ResolvedQualifiedRole resolveQualifiedRole(RouteContext routeContext, QualifiedRoleName qualifiedRoleName) {
        List<Id> recipients = this.resolveRecipients(routeContext, qualifiedRoleName);
        ResolvedQualifiedRole rqr = new ResolvedQualifiedRole(this.getLabelForQualifiedRoleName(qualifiedRoleName), recipients);
        return rqr;
    }

    protected String getLabelForQualifiedRoleName(QualifiedRoleName qualifiedRoleName) {
        return qualifiedRoleName.getBaseRoleName();
    }

    protected List<Id> resolveRecipients(RouteContext routeContext, QualifiedRoleName qualifiedRoleName) {
        return null;
    }
}

