/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.text.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.rule.Rule;
import org.kuali.rice.kew.rule.RuleExpressionResult;
import org.kuali.rice.kew.rule.RuleImpl;

public class KRAMetaRuleEngine {
    private static final Logger LOG = Logger.getLogger(KRAMetaRuleEngine.class);
    private final String expression;
    private final String[] statements;
    private int curStatement = 0;
    private boolean stop = false;

    public KRAMetaRuleEngine(String expression) throws ParseException {
        this.expression = expression;
        this.statements = expression.split("\\s*[;\r\n]\\s*");
        if (this.statements.length == 0) {
            throw new ParseException("No statements parsed in expression: " + expression, 0);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public String[] getStatements() {
        return this.statements;
    }

    public int getCurStatement() {
        return this.curStatement;
    }

    public void setCurStatement(int statementNo) {
        this.curStatement = statementNo;
    }

    public boolean isDone() {
        return this.curStatement >= this.statements.length || this.stop;
    }

    public RuleExpressionResult processSingleStatement(RouteContext context) throws ParseException {
        RuleExpressionResult result;
        if (this.isDone()) {
            return null;
        }
        int stmtNum = this.curStatement + 1;
        String statement = this.statements[this.curStatement];
        LOG.debug((Object)("Processing statement: " + statement));
        String[] words = statement.split("\\s*:\\s*");
        if (words.length < 2) {
            throw new ParseException("Invalid statement (#" + stmtNum + "): " + statement, 0);
        }
        String ruleName = words[0];
        if (StringUtils.isEmpty((String)ruleName)) {
            throw new ParseException("Invalid rule in statement (#" + stmtNum + "): " + statement, 0);
        }
        String flag = words[1];
        LOG.debug((Object)flag.toUpperCase());
        KRA_RULE_FLAG flagCode = KRA_RULE_FLAG.valueOf(flag.toUpperCase());
        if (flagCode == null) {
            throw new ParseException("Invalid flag in statement (#" + stmtNum + "): " + statement, 0);
        }
        org.kuali.rice.kew.api.rule.Rule nestedRule = KewApiServiceLocator.getRuleService().getRuleByName(ruleName);
        if (nestedRule == null) {
            throw new ParseException("Rule '" + ruleName + "' in statement (#" + stmtNum + ") not found: " + statement, 0);
        }
        RuleImpl rule = new RuleImpl(nestedRule);
        switch (flagCode) {
            case NEXT: {
                result = rule.evaluate(rule, context);
                break;
            }
            case TRUE: {
                result = rule.evaluate(rule, context);
                if (result.isSuccess()) break;
                this.stop = true;
                break;
            }
            case FALSE: {
                result = rule.evaluate(rule, context);
                if (!result.isSuccess()) break;
                this.stop = true;
                result = new RuleExpressionResult((Rule)rule, false, result.getResponsibilities());
                break;
            }
            default: {
                throw new RiceIllegalStateException("Unhandled statement flag: " + (Object)((Object)flagCode));
            }
        }
        ++this.curStatement;
        LOG.debug((Object)("Result of statement '" + statement + "': " + result));
        return result;
    }

    private static enum KRA_RULE_FLAG {
        NEXT,
        TRUE,
        FALSE;

    }
}

