/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.service.impl;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.dao.RuleAttributeDAO;
import org.kuali.rice.kew.rule.service.RuleAttributeService;
import org.kuali.rice.kew.xml.RuleAttributeXmlParser;
import org.kuali.rice.kew.xml.export.RuleAttributeXmlExporter;

public class RuleAttributeServiceImpl
implements RuleAttributeService {
    private static final Logger LOG = Logger.getLogger(RuleAttributeServiceImpl.class);
    private static final String RULE_ATTRIBUTE_NAME_REQUIRED = "rule.attribute.name.required";
    private static final String RULE_ATTRIBUTE_CLASS_REQUIRED = "rule.attribute.className.required";
    private static final String XML_FILE_NOT_FOUND = "general.error.filenotfound";
    private static final String XML_PARSE_ERROR = "general.error.parsexml";
    private RuleAttributeDAO ruleAttributeDAO;

    @Override
    public void save(RuleAttribute ruleAttribute) {
        this.validate(ruleAttribute);
        this.getRuleAttributeDAO().save(ruleAttribute);
    }

    @Override
    public void delete(String ruleAttributeId) {
        this.getRuleAttributeDAO().delete(ruleAttributeId);
    }

    @Override
    public List<RuleAttribute> findByRuleAttribute(RuleAttribute ruleAttribute) {
        return this.getRuleAttributeDAO().findByRuleAttribute(ruleAttribute);
    }

    @Override
    public RuleAttribute findByRuleAttributeId(String ruleAttributeId) {
        return this.getRuleAttributeDAO().findByRuleAttributeId(ruleAttributeId);
    }

    @Override
    public List<RuleAttribute> findAll() {
        return this.getRuleAttributeDAO().getAllRuleAttributes();
    }

    @Override
    public RuleAttribute findByName(String name) {
        return this.getRuleAttributeDAO().findByName(name);
    }

    public RuleAttributeDAO getRuleAttributeDAO() {
        return this.ruleAttributeDAO;
    }

    public void setRuleAttributeDAO(RuleAttributeDAO ruleAttributeDAO) {
        this.ruleAttributeDAO = ruleAttributeDAO;
    }

    private void validate(RuleAttribute ruleAttribute) {
        LOG.debug((Object)"validating ruleAttribute");
        ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
        if (ruleAttribute.getName() == null || ruleAttribute.getName().trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("Please enter a rule attribute name.", RULE_ATTRIBUTE_NAME_REQUIRED));
            LOG.error((Object)"Rule attribute name is missing");
        } else {
            RuleAttribute nameInUse;
            ruleAttribute.setName(ruleAttribute.getName().trim());
            if (ruleAttribute.getId() == null && (nameInUse = this.findByName(ruleAttribute.getName())) != null) {
                errors.add(new WorkflowServiceErrorImpl("Rule attribute name already in use", "routetemplate.ruleattribute.name.duplicate"));
                LOG.error((Object)"Rule attribute name already in use");
            }
        }
        if (ruleAttribute.getResourceDescriptor() == null || ruleAttribute.getResourceDescriptor().trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("Please enter a rule attribute class name.", RULE_ATTRIBUTE_CLASS_REQUIRED));
            LOG.error((Object)"Rule attribute class name is missing");
        } else {
            ruleAttribute.setResourceDescriptor(ruleAttribute.getResourceDescriptor().trim());
        }
        LOG.debug((Object)"end validating ruleAttribute");
        if (!errors.isEmpty()) {
            throw new WorkflowServiceErrorException("RuleAttribute Validation Error", errors);
        }
    }

    @Override
    public Object loadRuleAttributeService(RuleAttribute attribute) {
        return this.loadRuleAttributeService(attribute, null);
    }

    @Override
    public Object loadRuleAttributeService(RuleAttribute attribute, String defaultApplicationId) {
        Object attributeService = null;
        String attributeName = attribute.getResourceDescriptor();
        ObjectDefinition attributeObjectDefinition = this.getAttributeObjectDefinition(attribute, defaultApplicationId);
        attributeService = GlobalResourceLoader.getObject((ObjectDefinition)attributeObjectDefinition);
        if (attributeService == null) {
            attributeService = GlobalResourceLoader.getService((QName)QName.valueOf(attributeName));
        }
        return attributeService;
    }

    protected ObjectDefinition getAttributeObjectDefinition(RuleAttribute ruleAttribute, String defaultApplicationId) {
        if (ruleAttribute.getApplicationId() == null && defaultApplicationId != null) {
            return new ObjectDefinition(ruleAttribute.getResourceDescriptor(), defaultApplicationId);
        }
        return new ObjectDefinition(ruleAttribute.getResourceDescriptor(), ruleAttribute.getApplicationId());
    }

    public void loadXml(InputStream inputStream, String principalId) {
        RuleAttributeXmlParser parser = new RuleAttributeXmlParser();
        try {
            parser.parseRuleAttributes(inputStream);
        }
        catch (FileNotFoundException e) {
            throw new WorkflowServiceErrorException("XML file not found", new WorkflowServiceErrorImpl("Rule Attribute XML file not found", XML_FILE_NOT_FOUND));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading xml file", (Throwable)e);
            throw new WorkflowServiceErrorException("Error loading xml file", new WorkflowServiceErrorImpl("Error loading xml file", XML_PARSE_ERROR));
        }
    }

    public Element export(ExportDataSet dataSet) {
        RuleAttributeXmlExporter exporter = new RuleAttributeXmlExporter();
        return exporter.export(dataSet);
    }

    public boolean supportPrettyPrint() {
        return true;
    }

    @Override
    public List<RuleAttribute> findByClassName(String className) {
        return this.ruleAttributeDAO.findByClassName(className);
    }
}

