/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.rule.web.DocumentConfigurationViewForm;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.impl.KimAttributes;
import org.kuali.rice.kim.impl.permission.GenericPermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.kim.impl.responsibility.ReviewResponsibilityBo;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class DocumentConfigurationViewAction
extends KewKualiAction {
    private static final Logger LOG = Logger.getLogger(DocumentConfigurationViewAction.class);
    private PermissionService permissionService;
    private RoleService roleService;
    private ResponsibilityService responsibilityService;
    private DocumentTypeService documentTypeService;
    private DataDictionaryService dataDictionaryService;
    private RouteNodeService routeNodeService;
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    private DocumentHelperService documentHelperService;

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.populateForm((DocumentConfigurationViewForm)form);
        return mapping.findForward("basic");
    }

    protected void populateForm(DocumentConfigurationViewForm form) {
        if (StringUtils.isNotEmpty((String)form.getDocumentTypeName())) {
            form.setDocumentType(this.getDocumentTypeService().findByName(form.getDocumentTypeName()));
            if (form.getDocumentType() != null) {
                form.getDocumentType().getChildrenDocTypes();
                form.setAttributeLabels(new HashMap<String, String>());
                this.populateRelatedDocuments(form);
                this.populatePermissions(form);
                this.populateRoutingResponsibilities(form);
                this.populateRoutingExceptionResponsibility(form);
                this.checkPermissions(form);
            }
        }
    }

    protected void checkPermissions(DocumentConfigurationViewForm form) {
        String docTypeDocumentType = this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(DocumentType.class);
        try {
            if (docTypeDocumentType != null && this.getDocumentHelperService().getDocumentAuthorizer(docTypeDocumentType).canInitiate(docTypeDocumentType, GlobalVariables.getUserSession().getPerson())) {
                form.setCanInitiateDocumentTypeDocument(true);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to check DocumentType initiation permission for " + docTypeDocumentType), (Throwable)ex);
        }
        String permissionDocumentType = this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(GenericPermissionBo.class);
        try {
            if (permissionDocumentType != null && this.getDocumentHelperService().getDocumentAuthorizer(permissionDocumentType).canInitiate(permissionDocumentType, GlobalVariables.getUserSession().getPerson())) {
                form.setCanInitiatePermissionDocument(true);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to check Permission initiation permission for " + permissionDocumentType), (Throwable)ex);
        }
        String responsibilityDocumentType = this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(ReviewResponsibilityBo.class);
        try {
            if (responsibilityDocumentType != null && this.getDocumentHelperService().getDocumentAuthorizer(responsibilityDocumentType).canInitiate(responsibilityDocumentType, GlobalVariables.getUserSession().getPerson())) {
                form.setCanInitiateResponsibilityDocument(true);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to check Responsibility initiation permission for " + responsibilityDocumentType), (Throwable)ex);
        }
    }

    public void populateRelatedDocuments(DocumentConfigurationViewForm form) {
        form.setParentDocumentType(form.getDocumentType().getParentDocType());
        form.setChildDocumentTypes(new ArrayList<DocumentType>(form.getDocumentType().getChildrenDocTypes()));
    }

    public void populatePermissions(DocumentConfigurationViewForm form) {
        HashMap<String, List<Role>> permRoles = new HashMap<String, List<Role>>();
        HashSet<String> seenDocumentPermissions = new HashSet<String>();
        for (DocumentType docType = form.getDocumentType(); docType != null; docType = docType.getParentDocType()) {
            String documentTypeName = docType.getName();
            Predicate p = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"active", (Object)Boolean.TRUE), PredicateFactory.equal((String)"attributes[documentTypeName]", (Object)docType.getName())});
            List perms = this.getPermissionService().findPermissions(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{p})).getResults();
            for (Permission perm : perms) {
                PermissionBo permBo = PermissionBo.from((Permission)perm);
                List roleIds = this.getPermissionService().getRoleIdsForPermission(perm.getNamespaceCode(), perm.getName());
                if (!roleIds.isEmpty()) {
                    permRoles.put(perm.getId(), this.getRoleService().getRoles(roleIds));
                }
                for (String attributeName : permBo.getDetails().keySet()) {
                    this.addAttributeLabel(form, attributeName);
                }
            }
            if (perms.size() <= 0 && !documentTypeName.equals(form.getDocumentTypeName())) continue;
            ArrayList<PermissionForDisplay> dispPerms = new ArrayList<PermissionForDisplay>(perms.size());
            for (Permission perm : perms) {
                PermissionBo permBo = PermissionBo.from((Permission)perm);
                if (permBo.getDetails().size() == 1) {
                    if (seenDocumentPermissions.contains(perm.getTemplate().getNamespaceCode() + "|" + perm.getTemplate().getName())) {
                        dispPerms.add(new PermissionForDisplay(permBo, true));
                        continue;
                    }
                    dispPerms.add(new PermissionForDisplay(permBo, false));
                    seenDocumentPermissions.add(perm.getTemplate().getNamespaceCode() + "|" + perm.getTemplate().getName());
                    continue;
                }
                dispPerms.add(new PermissionForDisplay(permBo, false));
            }
            form.setPermissionsForDocumentType(documentTypeName, dispPerms);
            form.addDocumentType(documentTypeName);
        }
        form.setPermissionRoles(permRoles);
    }

    protected void populateRoutingExceptionResponsibility(DocumentConfigurationViewForm form) {
        ArrayList<ResponsibilityForDisplay> responsibilities = new ArrayList<ResponsibilityForDisplay>();
        for (DocumentType docType = form.getDocumentType(); docType != null; docType = docType.getParentDocType()) {
            List resps = this.getResponsibilityService().findWorkflowExceptionResponsibilities(docType.getName());
            for (Responsibility r : resps) {
                if (responsibilities.isEmpty()) {
                    responsibilities.add(new ResponsibilityForDisplay(r, false));
                    continue;
                }
                responsibilities.add(new ResponsibilityForDisplay(r, true));
            }
        }
        form.setExceptionResponsibilities(responsibilities);
        for (ResponsibilityForDisplay responsibility : responsibilities) {
            List roleIds = this.getResponsibilityService().getRoleIdsForResponsibility(responsibility.getResp().getId());
            if (roleIds.isEmpty()) continue;
            form.getResponsibilityRoles().put(responsibility.getResponsibilityId(), this.getRoleService().getRoles(roleIds));
        }
    }

    protected void addAttributeLabel(DocumentConfigurationViewForm form, String attributeName) {
        if (!form.getAttributeLabels().containsKey(attributeName)) {
            form.getAttributeLabels().put(attributeName, this.getDataDictionaryService().getAttributeLabel(KimAttributes.class, attributeName));
        }
    }

    protected RouteNode flattenSplitNode(RouteNode splitNode, Map<String, RouteNode> nodes) {
        nodes.put(splitNode.getRouteNodeName(), splitNode);
        RouteNode joinNode = null;
        for (RouteNode nextNode : splitNode.getNextNodes()) {
            joinNode = this.flattenRouteNodes(nextNode, nodes);
        }
        if (joinNode != null) {
            nodes.put(joinNode.getRouteNodeName(), joinNode);
        }
        return joinNode;
    }

    protected RouteNode flattenRouteNodes(RouteNode node, Map<String, RouteNode> nodes) {
        RouteNode lastProcessedNode;
        block5: {
            block6: {
                lastProcessedNode = null;
                if (node == null) break block5;
                if (nodes.containsKey(node.getRouteNodeName())) {
                    return node;
                }
                if (!node.getNodeType().contains("SplitNode")) break block6;
                lastProcessedNode = this.flattenSplitNode(node, nodes);
                if (lastProcessedNode == null) break block5;
                for (RouteNode nextNode : lastProcessedNode.getNextNodes()) {
                    lastProcessedNode = this.flattenRouteNodes(nextNode, nodes);
                }
                break block5;
            }
            if (node.getNodeType().contains("JoinNode")) {
                lastProcessedNode = node;
            } else {
                nodes.put(node.getRouteNodeName(), node);
                for (RouteNode nextNode : node.getNextNodes()) {
                    lastProcessedNode = this.flattenRouteNodes(nextNode, nodes);
                }
            }
        }
        return lastProcessedNode;
    }

    public void populateRoutingResponsibilities(DocumentConfigurationViewForm form) {
        HashMap<String, List<Role>> respToRoleMap = new HashMap<String, List<Role>>();
        List processes = form.getDocumentType().getProcesses();
        if (!processes.isEmpty()) {
            RouteNode rootNode = ((ProcessDefinitionBo)processes.get(0)).getInitialRouteNode();
            LinkedHashMap<String, RouteNode> routeNodeMap = new LinkedHashMap<String, RouteNode>();
            this.flattenRouteNodes(rootNode, routeNodeMap);
            form.setRouteNodes(new ArrayList<RouteNode>(routeNodeMap.values()));
            HashSet<Responsibility> responsibilities = new HashSet<Responsibility>();
            LinkedHashMap<String, List<ResponsibilityForDisplay>> nodeToRespMap = new LinkedHashMap<String, List<ResponsibilityForDisplay>>();
            for (DocumentType docType = form.getDocumentType(); docType != null; docType = docType.getParentDocType()) {
                List resps = this.getResponsibilityService().findWorkflowResponsibilities(docType.getName());
                for (Responsibility r : resps) {
                    String routeNodeName = (String)r.getAttributes().get("routeNodeName");
                    if (!StringUtils.isNotBlank((String)routeNodeName)) continue;
                    if (!nodeToRespMap.containsKey(routeNodeName)) {
                        nodeToRespMap.put(routeNodeName, new ArrayList());
                        ((List)nodeToRespMap.get(routeNodeName)).add(new ResponsibilityForDisplay(r, false));
                    } else if (((ResponsibilityForDisplay)((List)nodeToRespMap.get(routeNodeName)).get(0)).getDetails().get("documentTypeName").equals(docType.getName())) {
                        ((List)nodeToRespMap.get(routeNodeName)).add(new ResponsibilityForDisplay(r, false));
                    } else {
                        ((List)nodeToRespMap.get(routeNodeName)).add(new ResponsibilityForDisplay(r, true));
                    }
                    responsibilities.add(r);
                }
            }
            form.setResponsibilityMap(nodeToRespMap);
            for (Responsibility responsibility : responsibilities) {
                List roleIds = this.getResponsibilityService().getRoleIdsForResponsibility(responsibility.getId());
                if (roleIds.isEmpty()) continue;
                respToRoleMap.put(responsibility.getId(), this.getRoleService().getRoles(roleIds));
            }
        }
        form.setResponsibilityRoles(respToRoleMap);
    }

    public ActionForward toggleTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.toggleTab(mapping, form, request, response);
        this.populateForm((DocumentConfigurationViewForm)form);
        return actionForward;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    public RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KimApiServiceLocator.getRoleService();
        }
        return this.roleService;
    }

    public ResponsibilityService getResponsibilityService() {
        if (this.responsibilityService == null) {
            this.responsibilityService = KimApiServiceLocator.getResponsibilityService();
        }
        return this.responsibilityService;
    }

    public DocumentTypeService getDocumentTypeService() {
        if (this.documentTypeService == null) {
            this.documentTypeService = KEWServiceLocator.getDocumentTypeService();
        }
        return this.documentTypeService;
    }

    public DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public RouteNodeService getRouteNodeService() {
        if (this.routeNodeService == null) {
            this.routeNodeService = KEWServiceLocator.getRouteNodeService();
        }
        return this.routeNodeService;
    }

    public DocumentHelperService getDocumentHelperService() {
        if (this.documentHelperService == null) {
            this.documentHelperService = KNSServiceLocator.getDocumentHelperService();
        }
        return this.documentHelperService;
    }

    public MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (this.maintenanceDocumentDictionaryService == null) {
            this.maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return this.maintenanceDocumentDictionaryService;
    }

    public static class PermissionForDisplay {
        private PermissionBo perm;
        private boolean overridden = false;

        public PermissionForDisplay(PermissionBo perm, boolean overridden) {
            this.perm = perm;
            this.overridden = overridden;
        }

        public boolean isOverridden() {
            return this.overridden;
        }

        public void setOverridden(boolean overridden) {
            this.overridden = overridden;
        }

        public Map<String, String> getDetails() {
            return this.perm.getDetails();
        }

        public String getName() {
            return this.perm.getName();
        }

        public String getNamespaceCode() {
            return this.perm.getNamespaceCode();
        }

        public String getId() {
            return this.perm.getId();
        }

        public PermissionTemplateBo getTemplate() {
            return this.perm.getTemplate();
        }
    }

    public static class ResponsibilityForDisplay {
        private Responsibility resp;
        private boolean overridden = false;

        public ResponsibilityForDisplay(Responsibility resp, boolean overridden) {
            this.resp = resp;
            this.overridden = overridden;
        }

        Responsibility getResp() {
            return this.resp;
        }

        public boolean isOverridden() {
            return this.overridden;
        }

        public void setOverridden(boolean overridden) {
            this.overridden = overridden;
        }

        public Map<String, String> getDetails() {
            return new HashMap<String, String>(this.resp.getAttributes());
        }

        public String getName() {
            return this.resp.getName();
        }

        public String getNamespaceCode() {
            return this.resp.getNamespaceCode();
        }

        public String getResponsibilityId() {
            return this.resp.getId();
        }
    }
}

