/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.docsearch.DocumentSearchCriteriaEbo;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.impl.ModuleServiceBase;

public class KEWModuleService
extends ModuleServiceBase {
    protected DocumentTypeService docTypeService = null;

    public List<String> listPrimaryKeyFieldNames(Class businessObjectInterfaceClass) {
        if (DocumentTypeEBO.class.isAssignableFrom(businessObjectInterfaceClass)) {
            ArrayList<String> pkFields = new ArrayList<String>(1);
            pkFields.add("documentTypeId");
            return pkFields;
        }
        if (DocumentSearchCriteriaEbo.class.isAssignableFrom(businessObjectInterfaceClass)) {
            ArrayList<String> pkFields = new ArrayList<String>(1);
            pkFields.add("documentId");
            return pkFields;
        }
        return super.listPrimaryKeyFieldNames(businessObjectInterfaceClass);
    }

    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        if (DocumentTypeEBO.class.isAssignableFrom(businessObjectClass)) {
            DocumentType fetchedDocumentType = null;
            if (fieldValues.containsKey("name")) {
                fetchedDocumentType = this.getDocumentTypeService().getDocumentTypeByName((String)fieldValues.get("name"));
            } else if (fieldValues.containsKey("documentTypeId")) {
                fetchedDocumentType = this.getDocumentTypeService().getDocumentTypeById(fieldValues.get("documentTypeId").toString());
            } else if (fieldValues.containsKey("id")) {
                fetchedDocumentType = this.getDocumentTypeService().getDocumentTypeById(fieldValues.get("id").toString());
            }
            if (fetchedDocumentType != null) {
                return (T)org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)fetchedDocumentType);
            }
            return null;
        }
        if (DocumentSearchCriteriaEbo.class.isAssignableFrom(businessObjectClass) && fieldValues.containsKey("documentId")) {
            return (T)this.createDocumentSearchEbo(KewApiServiceLocator.getWorkflowDocumentService().getDocument(fieldValues.get("documentId").toString()));
        }
        return (T)super.getExternalizableBusinessObject(businessObjectClass, fieldValues);
    }

    protected synchronized DocumentTypeService getDocumentTypeService() {
        if (this.docTypeService == null) {
            this.docTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return this.docTypeService;
    }

    public synchronized void setDocumentTypeService(DocumentTypeService docTypeService) {
        this.docTypeService = docTypeService;
    }

    private DocumentSearchCriteriaEbo createDocumentSearchEbo(final Document doc) {
        return new DocumentSearchCriteriaEbo(){

            @Override
            public String getApplicationDocumentId() {
                return doc.getApplicationDocumentId();
            }

            @Override
            public DocumentStatus getStatus() {
                return doc.getStatus();
            }

            @Override
            public String getApplicationDocumentStatus() {
                return doc.getApplicationDocumentStatus();
            }

            @Override
            public String getTitle() {
                return doc.getTitle();
            }

            @Override
            public String getDocumentTypeName() {
                return doc.getDocumentTypeName();
            }

            @Override
            public String getInitiatorPrincipalId() {
                return doc.getInitiatorPrincipalId();
            }

            @Override
            public String getDocumentId() {
                return doc.getDocumentId();
            }

            @Override
            public DateTime getDateCreated() {
                return doc.getDateCreated();
            }

            public void refresh() {
            }
        };
    }

    public String getExternalizableBusinessObjectInquiryUrl(Class inquiryBusinessObjectClass, Map<String, String[]> parameters) {
        if (DocumentTypeEBO.class.isAssignableFrom(inquiryBusinessObjectClass)) {
            int nonBlank = 0;
            boolean nameFound = false;
            for (String key : parameters.keySet()) {
                if ("name".equals(key) && parameters.get(key) != null) {
                    nameFound = true;
                    continue;
                }
                if ("name".equals(key) || parameters.get(key) == null) continue;
                ++nonBlank;
            }
            if (nonBlank == 0 && nameFound) {
                parameters.clear();
                org.kuali.rice.kew.doctype.bo.DocumentType dte = org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)this.getDocumentTypeService().getDocumentTypeByName(parameters.get("name")[0]));
                String[] strArr = new String[]{dte.getDocumentTypeId().toString()};
                parameters.put("documentTypeId", strArr);
            }
        }
        return super.getExternalizableBusinessObjectInquiryUrl(inquiryBusinessObjectClass, parameters);
    }

    public List<List<String>> listAlternatePrimaryKeyFieldNames(Class businessObjectInterfaceClass) {
        if (DocumentTypeEBO.class.isAssignableFrom(businessObjectInterfaceClass)) {
            ArrayList<List<String>> retList = new ArrayList<List<String>>();
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.add("name");
            retList.add(keyList);
            return retList;
        }
        return null;
    }

    public boolean goToCentralRiceForInquiry() {
        RunMode runMode = this.getRunMode("kew");
        return RunMode.EMBEDDED.equals((Object)runMode);
    }
}

