/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.rules.ui;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.ui.GroupDocumentMember;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.rule.event.ui.AddGroupMemberEvent;
import org.kuali.rice.kim.rule.ui.AddGroupMemberRule;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class GroupDocumentMemberRule
extends DocumentRuleBase
implements AddGroupMemberRule {
    private static final String ERROR_PATH = "document.member.memberId";

    @Override
    public boolean processAddGroupMember(AddGroupMemberEvent addGroupMemberEvent) {
        GroupDocumentMember newMember = addGroupMemberEvent.getMember();
        IdentityManagementGroupDocument document = (IdentityManagementGroupDocument)addGroupMemberEvent.getDocument();
        boolean rulePassed = true;
        if (newMember == null || StringUtils.isBlank((String)newMember.getMemberId())) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Member"});
            return false;
        }
        if (!this.validAssignGroup(newMember, document)) {
            return false;
        }
        int i = 0;
        for (GroupDocumentMember member : document.getMembers()) {
            if (member.getMemberId().equals(newMember.getMemberId()) && member.getMemberTypeCode().equals(newMember.getMemberTypeCode())) {
                rulePassed = false;
                GlobalVariables.getMessageMap().putError("document.members[" + i + "].memberId", "error.duplicate.entry", new String[]{"Member"});
            }
            ++i;
        }
        GroupService groupService = KimApiServiceLocator.getGroupService();
        if (groupService.isGroupMemberOfGroup(document.getGroupId(), newMember.getMemberId())) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.assign.group.member.circular", new String[]{newMember.getMemberId()});
            return false;
        }
        return rulePassed;
    }

    protected boolean validAssignGroup(GroupDocumentMember groupMember, IdentityManagementGroupDocument document) {
        boolean rulePassed = true;
        if (StringUtils.isNotEmpty((String)document.getGroupNamespace())) {
            HashMap<String, String> roleDetails = new HashMap<String, String>();
            roleDetails.put("namespaceCode", document.getGroupNamespace());
            roleDetails.put("groupName", document.getGroupName());
            if (!GroupDocumentMemberRule.getDocumentDictionaryService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Populate Group", GlobalVariables.getUserSession().getPerson().getPrincipalId(), roleDetails, null)) {
                GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.assign.group", new String[]{document.getGroupNamespace(), document.getGroupName()});
                rulePassed = false;
            }
        }
        return rulePassed;
    }
}

