/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.util;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.util.Utilities;

public class UtilitiesTest {
    @Test
    public void RouteLogActionRequestSorterTest_AR1_Active() {
        ActionRequestValue ar1 = new ActionRequestValue();
        ActionRequestValue ar2 = new ActionRequestValue();
        ar1.setActionRequestId("Test1");
        ar1.setRouteLevel(Integer.valueOf(1));
        ar1.setStatus("A");
        ar2.setActionRequestId("Test2");
        ar2.setRouteLevel(Integer.valueOf(1));
        ar2.setStatus("I");
        ArrayList<ActionRequestValue> actionRequestValues = new ArrayList<ActionRequestValue>();
        actionRequestValues.add(ar1);
        actionRequestValues.add(ar2);
        Collections.sort(actionRequestValues, new Utilities.RouteLogActionRequestSorter());
        Assert.assertEquals((Object)"Test1", (Object)((ActionRequestValue)actionRequestValues.get(0)).getActionRequestId());
    }

    @Test
    public void RouteLogActionRequestSorterTest_AR2_Active() {
        ActionRequestValue ar1 = new ActionRequestValue();
        ActionRequestValue ar2 = new ActionRequestValue();
        ar1.setActionRequestId("Test1");
        ar1.setRouteLevel(Integer.valueOf(1));
        ar1.setStatus("I");
        ar2.setActionRequestId("Test2");
        ar2.setRouteLevel(Integer.valueOf(1));
        ar2.setStatus("A");
        ArrayList<ActionRequestValue> actionRequestValues = new ArrayList<ActionRequestValue>();
        actionRequestValues.add(ar1);
        actionRequestValues.add(ar2);
        Collections.sort(actionRequestValues, new Utilities.RouteLogActionRequestSorter());
        Assert.assertEquals((Object)"Test2", (Object)((ActionRequestValue)actionRequestValues.get(0)).getActionRequestId());
    }

    @Test
    public void RouteLogActionRequestSorterTest_Both_Active() {
        ActionRequestValue ar1 = new ActionRequestValue();
        ActionRequestValue ar2 = new ActionRequestValue();
        ActionRequestValue ar3 = new ActionRequestValue();
        ar1.setActionRequestId("Test1");
        ar1.setRouteLevel(Integer.valueOf(1));
        ar1.setStatus("A");
        ar1.setPriority(Integer.valueOf(1));
        ar2.setActionRequestId("Test2");
        ar2.setRouteLevel(Integer.valueOf(1));
        ar2.setStatus("A");
        ar2.setPriority(Integer.valueOf(2));
        ar3.setActionRequestId("Test3");
        ar3.setRouteLevel(Integer.valueOf(1));
        ar3.setStatus("I");
        ArrayList<ActionRequestValue> actionRequestValues = new ArrayList<ActionRequestValue>();
        actionRequestValues.add(ar1);
        actionRequestValues.add(ar2);
        actionRequestValues.add(ar3);
        Collections.sort(actionRequestValues, new Utilities.RouteLogActionRequestSorter());
        Assert.assertEquals((Object)"Test1", (Object)((ActionRequestValue)actionRequestValues.get(0)).getActionRequestId());
        Assert.assertEquals((Object)"Test2", (Object)((ActionRequestValue)actionRequestValues.get(1)).getActionRequestId());
        Assert.assertEquals((Object)"Test3", (Object)((ActionRequestValue)actionRequestValues.get(2)).getActionRequestId());
    }
}

