/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kcb.api.exception.MessageDeliveryException;
import org.kuali.rice.kcb.api.exception.MessageDismissalException;
import org.kuali.rice.kcb.api.message.MessageDTO;
import org.kuali.rice.kcb.api.service.MessagingService;
import org.kuali.rice.kcb.bo.Message;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.bo.RecipientDelivererConfig;
import org.kuali.rice.kcb.quartz.MessageProcessingJob;
import org.kuali.rice.kcb.service.MessageDeliveryService;
import org.kuali.rice.kcb.service.MessageService;
import org.kuali.rice.kcb.service.RecipientPreferenceService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MessagingServiceImpl
implements MessagingService {
    private static final Logger LOG = Logger.getLogger(MessagingServiceImpl.class);
    private MessageService messageService;
    private MessageDeliveryService messageDeliveryService;
    private RecipientPreferenceService recipientPrefs;
    private String jobName;
    private String jobGroup;
    private boolean synchronous;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    @Required
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Required
    public void setMessageDeliveryService(MessageDeliveryService messageDeliveryService) {
        this.messageDeliveryService = messageDeliveryService;
    }

    public void setSynchronous(boolean sync) {
        LOG.debug((Object)("Setting synchronous messaging to: " + sync));
        this.synchronous = sync;
    }

    @Required
    public void setRecipientPreferenceService(RecipientPreferenceService prefs) {
        this.recipientPrefs = prefs;
    }

    public Long deliver(MessageDTO message) throws MessageDeliveryException {
        if (message == null) {
            throw new RiceIllegalArgumentException("message is null");
        }
        Collection<String> delivererTypes = this.getDelivererTypesForUserAndChannel(message.getRecipient(), message.getChannel());
        LOG.debug((Object)("Deliverer types for " + message.getRecipient() + "/" + message.getChannel() + ": " + delivererTypes.size()));
        if (delivererTypes.isEmpty()) {
            LOG.debug((Object)("No deliverers are configured for " + message.getRecipient() + "/" + message.getChannel()));
            return null;
        }
        Message m = new Message();
        m.setTitle(message.getTitle());
        m.setDeliveryType(message.getDeliveryType());
        m.setChannel(message.getChannel());
        m.setRecipient(message.getRecipient());
        m.setContentType(message.getContentType());
        m.setUrl(message.getUrl());
        m.setContent(message.getContent());
        m.setOriginId(message.getOriginId());
        LOG.debug((Object)("saving message: " + m));
        m = this.messageService.saveMessage(m);
        for (String type : delivererTypes) {
            MessageDelivery delivery = new MessageDelivery();
            delivery.setDelivererTypeName(type);
            delivery.setMessage(m);
            LOG.debug((Object)("saving messagedelivery: " + delivery));
            this.messageDeliveryService.saveMessageDelivery(delivery);
        }
        LOG.debug((Object)"queuing job");
        this.queueJob(MessageProcessingJob.Mode.DELIVER, m.getId(), null, null);
        LOG.debug((Object)"returning");
        return m.getId();
    }

    public void remove(long messageId, String user, String cause) throws MessageDismissalException {
        if (StringUtils.isBlank((String)user)) {
            throw new RiceIllegalArgumentException("user is null");
        }
        if (StringUtils.isBlank((String)cause)) {
            throw new RiceIllegalArgumentException("cause is null");
        }
        Message m = this.messageService.getMessage(messageId);
        if (m == null) {
            throw new MessageDismissalException("No such message: " + messageId);
        }
        this.remove(m, user, cause);
    }

    public Long removeByOriginId(String originId, String user, String cause) throws MessageDismissalException {
        if (StringUtils.isBlank((String)originId)) {
            throw new RiceIllegalArgumentException("originId is null");
        }
        Message m = this.messageService.getMessageByOriginId(originId);
        if (m == null) {
            return null;
        }
        this.remove(m, user, cause);
        return m.getId();
    }

    private void remove(Message message, String user, String cause) {
        this.queueJob(MessageProcessingJob.Mode.REMOVE, message.getId(), user, cause);
    }

    private Collection<String> getDelivererTypesForUserAndChannel(String userRecipientId, String channel) {
        HashSet<String> deliveryTypes = new HashSet<String>(1);
        Collection<RecipientDelivererConfig> deliverers = this.recipientPrefs.getDeliverersForRecipientAndChannel(userRecipientId, channel);
        for (RecipientDelivererConfig cfg : deliverers) {
            deliveryTypes.add(cfg.getDelivererName());
        }
        return deliveryTypes;
    }

    private void queueJob(MessageProcessingJob.Mode mode, long messageId, String user, String cause) {
        LOG.debug((Object)"registering synchronization");
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new RiceRuntimeException("transaction syncronization is not active (!TransactionSynchronizationManager.isSynchronizationActive())");
        }
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new RiceRuntimeException("actual transaction is not active (!TransactionSynchronizationManager.isActualTransactionActive())");
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new QueueProcessingJobSynchronization(this.jobName, this.jobGroup, mode, messageId, user, cause, this.synchronous));
    }

    public static class QueueProcessingJobSynchronization
    extends TransactionSynchronizationAdapter {
        private static final Logger LOG = Logger.getLogger(QueueProcessingJobSynchronization.class);
        private final String jobName;
        private final String jobGroup;
        private final MessageProcessingJob.Mode mode;
        private final long messageId;
        private final String user;
        private final String cause;
        private final boolean synchronous;

        private QueueProcessingJobSynchronization(String jobName, String jobGroup, MessageProcessingJob.Mode mode, long messageId, String user, String cause, boolean synchronous) {
            this.jobName = jobName;
            this.jobGroup = jobGroup;
            this.mode = mode;
            this.messageId = messageId;
            this.user = user;
            this.cause = cause;
            this.synchronous = synchronous;
        }

        public void afterCommit() {
            this.scheduleJob();
        }

        private void scheduleJob() {
            LOG.debug((Object)"Queueing processing job");
            try {
                Scheduler scheduler = KSBServiceLocator.getScheduler();
                if (this.synchronous) {
                    LOG.debug((Object)("Invoking job synchronously in Thread " + Thread.currentThread()));
                    MessageProcessingJob job = new MessageProcessingJob(this.messageId, this.mode, this.user, this.cause);
                    job.run();
                } else {
                    String uniqueTriggerName = this.jobName + "-Trigger-" + System.currentTimeMillis() + Math.random();
                    SimpleTriggerImpl trigger = new SimpleTriggerImpl(uniqueTriggerName, this.jobGroup + "-Trigger");
                    LOG.debug((Object)("Scheduling trigger: " + trigger));
                    JobDataMap data = new JobDataMap();
                    data.put("mode", this.mode.name());
                    data.put("user", this.user);
                    data.put("cause", this.cause);
                    data.put("messageId", this.messageId);
                    trigger.setJobName(this.jobName);
                    trigger.setJobGroup(this.jobGroup);
                    trigger.setJobDataMap(data);
                    scheduler.scheduleJob((Trigger)trigger);
                }
            }
            catch (SchedulerException se) {
                throw new RuntimeException(se);
            }
        }
    }
}

