/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.SplitNode;
import org.kuali.rice.kew.engine.node.SplitResult;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathSplitNode
implements SplitNode {
    private static final Logger LOG = Logger.getLogger(XPathSplitNode.class);
    private XPath xPath;
    private NodeList xpathDecisions;
    private NodeList defaultDecisions;

    @Override
    public SplitResult process(RouteContext context, RouteHelper helper) throws Exception {
        Node xpathDecision;
        int i;
        this.loadConfiguration(context);
        ArrayList<String> branchNames = new ArrayList<String>();
        if (this.xpathDecisions != null) {
            for (i = 0; i < this.xpathDecisions.getLength(); ++i) {
                xpathDecision = this.xpathDecisions.item(i);
                String xpathExpression = xpathDecision.getAttributes().getNamedItem("expression").getNodeValue();
                String branchName = xpathDecision.getAttributes().getNamedItem("branchName").getNodeValue();
                if (!((Boolean)this.getXPath().evaluate(xpathExpression, context.getDocumentContent().getDocument(), XPathConstants.BOOLEAN)).booleanValue()) continue;
                branchNames.add(branchName);
            }
        }
        if (CollectionUtils.isEmpty(branchNames) && this.defaultDecisions != null) {
            for (i = 0; i < this.defaultDecisions.getLength(); ++i) {
                xpathDecision = this.defaultDecisions.item(i);
                String branchName = xpathDecision.getAttributes().getNamedItem("branchName").getNodeValue();
                branchNames.add(branchName);
            }
        }
        return new SplitResult(branchNames);
    }

    private void loadConfiguration(RouteContext context) {
        try {
            String contentFragment = context.getNodeInstance().getRouteNode().getContentFragment();
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document nodeContent = db.parse(new InputSource(new StringReader(contentFragment)));
            this.xpathDecisions = (NodeList)this.getXPath().evaluate("//split/branchDecisions/xpath", nodeContent, XPathConstants.NODESET);
            this.defaultDecisions = (NodeList)this.getXPath().evaluate("//split/branchDecisions/default", nodeContent, XPathConstants.NODESET);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Caught parser exception processing XPathSplitNode configuration", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Object)"Caught SAX exception processing XPathSplitNode configuration", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Caught IO exception processing XPathSplitNode configuration", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)"Caught XPath exception processing XPathSplitNode configuration", (Throwable)e);
        }
    }

    public XPath getXPath() {
        if (this.xPath == null) {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            this.xPath = xPathFactory.newXPath();
        }
        return this.xPath;
    }
}

