/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document.search;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteriaContract;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.docsearch.DocumentSearchCriteriaProcessor;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.exception.WorkflowServiceError;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.framework.document.search.AttributeFields;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCriteriaConfiguration;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultSetConfiguration;
import org.kuali.rice.kew.framework.document.search.StandardResultField;
import org.kuali.rice.kew.impl.document.search.DocumentSearchCriteriaBo;
import org.kuali.rice.kew.impl.document.search.DocumentSearchCriteriaTranslator;
import org.kuali.rice.kew.impl.document.search.FormFields;
import org.kuali.rice.kew.lookup.valuefinder.SavedSearchValuesFinder;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.user.UserUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class DocumentSearchCriteriaBoLookupableHelperService
extends KualiLookupableHelperServiceImpl {
    static final String SAVED_SEARCH_NAME_PARAM = "savedSearchToLoadAndExecute";
    static final String DOCUMENT_TYPE_NAME_PARAM = "documentTypeName";
    private static final String EXCEED_THRESHOLD_MESSAGE_KEY = "docsearch.DocumentSearchService.exceededThreshold";
    private static final String SECURITY_FILTERED_MESSAGE_KEY = "docsearch.DocumentSearchService.securityFiltered";
    private static final String EXCEED_THRESHOLD_AND_SECURITY_FILTERED_MESSAGE_KEY = "docsearch.DocumentSearchService.exceededThresholdAndSecurityFiltered";
    private static final boolean DOCUMENT_HANDLER_POPUP_DEFAULT = true;
    private static final boolean ROUTE_LOG_POPUP_DEFAULT = true;
    private DocumentSearchService documentSearchService;
    private DocumentSearchCriteriaProcessor documentSearchCriteriaProcessor;
    private DocumentSearchCriteriaTranslator documentSearchCriteriaTranslator;
    private DocumentSearchResults searchResults = null;
    private DocumentSearchCriteria criteria = null;
    private static final Pattern CURRENT_USER_PATTERN = Pattern.compile("(?<=[\\s\\p{Punct}]|^)CURRENT_USER(\\.\\w+)?(?=[\\s\\p{Punct}]|$)");
    private static String TOGGLE_BUTTON = "<input type='image' name=''{0}'' id=''{0}'' class='tinybutton' src=''..{1}/images/tinybutton-{2}search.gif'' alt=''{3} search'' title=''{3} search''/>";

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        block5: {
            this.criteria = this.loadCriteria(fieldValues);
            this.searchResults = null;
            try {
                this.searchResults = KEWServiceLocator.getDocumentSearchService().lookupDocuments(GlobalVariables.getUserSession().getPrincipalId(), this.criteria, true);
                if (!this.searchResults.isCriteriaModified()) break block5;
                this.criteria = this.searchResults.getCriteria();
            }
            catch (WorkflowServiceErrorException wsee) {
                for (WorkflowServiceError workflowServiceError : (List)wsee.getServiceErrors()) {
                    if (workflowServiceError.getMessageMap() != null && workflowServiceError.getMessageMap().hasErrors()) {
                        GlobalVariables.getMessageMap().merge(workflowServiceError.getMessageMap());
                        continue;
                    }
                    GlobalVariables.getMessageMap().putError(workflowServiceError.getMessage(), "error.custom", new String[]{workflowServiceError.getMessage()});
                }
            }
        }
        if (!GlobalVariables.getMessageMap().hasNoErrors() || this.searchResults == null) {
            throw new ValidationException("error with doc search");
        }
        this.populateResultWarningMessages(this.searchResults);
        List individualSearchResults = this.searchResults.getSearchResults();
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.applyCriteriaChangesToFields((DocumentSearchCriteriaContract)this.criteria);
        return this.populateSearchResults(individualSearchResults);
    }

    protected void populateResultWarningMessages(DocumentSearchResults searchResults) {
        boolean overThreshold = searchResults.isOverThreshold();
        int numFiltered = searchResults.getNumberOfSecurityFilteredResults();
        int numResults = searchResults.getSearchResults().size();
        if (overThreshold && numFiltered > 0) {
            GlobalVariables.getMessageMap().putWarning("GlobalMessages", EXCEED_THRESHOLD_AND_SECURITY_FILTERED_MESSAGE_KEY, new String[]{String.valueOf(numResults), String.valueOf(numFiltered)});
        } else if (numFiltered > 0) {
            GlobalVariables.getMessageMap().putWarning("GlobalMessages", SECURITY_FILTERED_MESSAGE_KEY, new String[]{String.valueOf(numFiltered)});
        } else if (overThreshold) {
            GlobalVariables.getMessageMap().putWarning("GlobalMessages", EXCEED_THRESHOLD_MESSAGE_KEY, new String[]{String.valueOf(numResults)});
        }
    }

    protected void applyCriteriaChangesToFields(DocumentSearchCriteriaContract criteria) {
        Field field = this.getFormFields().getField("rangeLowerBoundKeyPrefix_dateCreated");
        if (field != null && StringUtils.isEmpty((String)field.getPropertyValue()) && criteria.getDateCreatedFrom() != null) {
            field.setPropertyValue(CoreApiServiceLocator.getDateTimeService().toDateString(criteria.getDateCreatedFrom().toDate()));
        }
    }

    protected static String replaceCurrentUserToken(String value, Person person) {
        Matcher matcher = CURRENT_USER_PATTERN.matcher(value);
        boolean matched = false;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String idValue;
            String group;
            matched = true;
            String idType = "principalName";
            if (matcher.groupCount() > 0 && (group = matcher.group(1)) != null) {
                idType = group.substring(1);
            }
            value = !StringUtils.isBlank((String)(idValue = UserUtils.getIdValue(idType, person))) ? idValue : matcher.group();
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return matched ? sb.toString() : null;
    }

    protected static Map<String, String> cleanupFieldValues(Map<String, String> fieldValues, Map<String, String[]> parameters) {
        HashMap<String, String> cleanedUpFieldValues = new HashMap<String, String>(fieldValues);
        if (ArrayUtils.isNotEmpty((Object[])parameters.get("statusCode"))) {
            cleanedUpFieldValues.put("statusCode", StringUtils.join((Object[])parameters.get("statusCode"), (String)","));
        }
        if (ArrayUtils.isNotEmpty((Object[])parameters.get("applicationDocumentStatus"))) {
            cleanedUpFieldValues.put("applicationDocumentStatus", StringUtils.join((Object[])parameters.get("applicationDocumentStatus"), (String)","));
        }
        HashMap<String, String> documentAttributeFieldValues = new HashMap<String, String>();
        Set<String> validAttributeNames = DocumentSearchCriteriaBoLookupableHelperService.getValidSearchableAttributeNames(fieldValues.get(DOCUMENT_TYPE_NAME_PARAM));
        for (String parameterName : parameters.keySet()) {
            Object[] value;
            String attributeName;
            if (!parameterName.contains("documentAttribute.") || !validAttributeNames.contains(attributeName = StringUtils.substringAfter((String)parameterName, (String)"documentAttribute.")) || !ArrayUtils.isNotEmpty((Object[])(value = parameters.get(parameterName)))) continue;
            if (parameters.containsKey(parameterName + "{CheckboxPresentOnFormAnnotation}")) {
                documentAttributeFieldValues.put(parameterName, "Y");
                continue;
            }
            documentAttributeFieldValues.put(parameterName, StringUtils.join((Object[])value, (String)(" " + SearchOperator.OR.op() + " ")));
        }
        documentAttributeFieldValues.putAll(LookupUtils.preProcessRangeFields(documentAttributeFieldValues));
        cleanedUpFieldValues.putAll(documentAttributeFieldValues);
        DocumentSearchCriteriaBoLookupableHelperService.replaceCurrentUserInFields(cleanedUpFieldValues);
        return cleanedUpFieldValues;
    }

    protected static Set<String> getValidSearchableAttributeNames(String documentTypeName) {
        List attributeFields;
        DocumentSearchCriteriaConfiguration searchConfiguration;
        DocumentType documentType;
        HashSet<String> validAttributeNames = new HashSet<String>();
        if (StringUtils.isNotBlank((String)documentTypeName) && (documentType = DocumentSearchCriteriaBoLookupableHelperService.getValidDocumentType(documentTypeName)) != null && (searchConfiguration = KEWServiceLocator.getDocumentSearchCustomizationMediator().getDocumentSearchCriteriaConfiguration(documentType)) != null && (attributeFields = searchConfiguration.getSearchAttributeFields()) != null) {
            for (AttributeFields fields : attributeFields) {
                if (fields.getRemotableAttributeFields() == null) continue;
                for (RemotableAttributeField field : fields.getRemotableAttributeFields()) {
                    validAttributeNames.add(field.getName());
                }
            }
        }
        return validAttributeNames;
    }

    protected static void replaceCurrentUserInFields(Map<String, String> fields) {
        Person person = GlobalVariables.getUserSession().getPerson();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String replaced;
            if (!StringUtils.isNotEmpty((String)entry.getValue()) || (replaced = DocumentSearchCriteriaBoLookupableHelperService.replaceCurrentUserToken(entry.getValue(), person)) == null) continue;
            entry.setValue(replaced);
        }
    }

    protected DocumentSearchCriteria loadCriteria(Map<String, String> fieldValues) {
        DocumentSearchCriteria criteria;
        boolean savedSearch;
        fieldValues = DocumentSearchCriteriaBoLookupableHelperService.cleanupFieldValues(fieldValues, this.getParameters());
        String[] savedSearchToLoad = (String[])this.getParameters().get(SAVED_SEARCH_NAME_PARAM);
        boolean bl = savedSearch = savedSearchToLoad != null && savedSearchToLoad.length > 0 && StringUtils.isNotBlank((String)savedSearchToLoad[0]);
        if (savedSearch && (criteria = this.getDocumentSearchService().getNamedSearchCriteria(GlobalVariables.getUserSession().getPrincipalId(), savedSearchToLoad[0])) != null) {
            this.getFormFields().setFieldValues(this.getDocumentSearchCriteriaTranslator().translateCriteriaToFields(criteria));
            return criteria;
        }
        return this.getDocumentSearchCriteriaTranslator().translateFieldsToCriteria(fieldValues);
    }

    protected List<DocumentSearchCriteriaBo> populateSearchResults(List<DocumentSearchResult> lookupResults) {
        ArrayList<DocumentSearchCriteriaBo> searchResults = new ArrayList<DocumentSearchCriteriaBo>();
        for (DocumentSearchResult searchResult : lookupResults) {
            DocumentSearchCriteriaBo result = new DocumentSearchCriteriaBo();
            result.populateFromDocumentSearchResult(searchResult);
            searchResults.add(result);
        }
        return searchResults;
    }

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        Collection lookupResult = super.performLookup(lookupForm, resultTable, bounded);
        this.postProcessResults(resultTable, this.searchResults);
        return lookupResult;
    }

    protected void overrideFieldValue(Field field, Map<String, String[]> newValues, Map<String, String[]> oldValues) {
        if (StringUtils.isNotBlank((String)field.getPropertyName())) {
            if (newValues.get(field.getPropertyName()) != null) {
                this.getFormFields().setFieldValue(field, newValues.get(field.getPropertyName()));
            } else if (oldValues.get(field.getPropertyName()) != null) {
                this.getFormFields().setFieldValue(field, oldValues.get(field.getPropertyName()));
            }
        }
    }

    protected void toggleFormView() {
        HashMap<String, String[]> fieldValues = new HashMap<String, String[]>();
        Map<String, String[]> savedValues = this.getFormFields().getFieldValues();
        for (Field field : this.getFormFields().getFields()) {
            this.overrideFieldValue(field, this.getParameters(), savedValues);
            this.applyFieldAuthorizationsFromNestedLookups(field);
            fieldValues.put(field.getPropertyName(), new String[]{field.getPropertyValue()});
        }
        if (this.checkForAdditionalFieldsMultiValued(fieldValues)) {
            for (Field field : this.getFormFields().getFields()) {
                this.overrideFieldValue(field, this.getParameters(), savedValues);
                fieldValues.put(field.getPropertyName(), new String[]{field.getPropertyValue()});
            }
        }
        this.getFormFields().setFieldValue("resetSavedSearch", "");
    }

    protected boolean loadSavedSearch(boolean ignoreErrors) {
        Map parameters;
        Object[] params;
        HashMap fieldValues = new HashMap();
        String savedSearchName = this.getSavedSearchName();
        if (StringUtils.isEmpty((String)savedSearchName) || "*ignore*".equals(savedSearchName)) {
            if (ignoreErrors) {
                return false;
            }
            GlobalVariables.getMessageMap().putError(SAVED_SEARCH_NAME_PARAM, "error.custom", new String[]{"You must select a saved search"});
            this.getFormFields().setFieldValue(SAVED_SEARCH_NAME_PARAM, "");
        }
        if (!GlobalVariables.getMessageMap().hasNoErrors()) {
            throw new ValidationException("errors in search criteria");
        }
        DocumentSearchCriteria criteria = KEWServiceLocator.getDocumentSearchService().getSavedSearchCriteria(GlobalVariables.getUserSession().getPrincipalId(), savedSearchName);
        String docTypeName = criteria.getDocumentTypeName();
        if (this.getParameters().containsKey("isAdvancedSearch") && ArrayUtils.isNotEmpty((Object[])(params = (String[])(parameters = this.getParameters()).get("isAdvancedSearch")))) {
            params[0] = criteria.getIsAdvancedSearch();
            this.setParameters(parameters);
        }
        this.setRows(docTypeName);
        for (Map.Entry entry : criteria.getDocumentAttributeValues().entrySet()) {
            fieldValues.put(entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
        }
        for (Field field : this.getFormFields().getFields()) {
            if (field.getPropertyName() == null || field.getPropertyName().equals("")) continue;
            String[] values = null;
            if (fieldValues.get(field.getPropertyName()) != null) {
                values = (String[])fieldValues.get(field.getPropertyName());
            } else {
                try {
                    if (field.isRanged() && field.isDatePicker()) {
                        if (field.getPropertyName().startsWith("rangeLowerBoundKeyPrefix_")) {
                            String lowerBoundName = field.getPropertyName().replace("rangeLowerBoundKeyPrefix_", "") + "From";
                            Object lowerBoundDate = PropertyUtils.getProperty((Object)criteria, (String)lowerBoundName);
                            if (lowerBoundDate != null) {
                                values = new String[]{CoreApiServiceLocator.getDateTimeService().toDateTimeString(((DateTime)lowerBoundDate).toDate())};
                            }
                        } else {
                            String upperBoundName = field.getPropertyName().replace("rangeUpperBoundKeyPrefix_", "") + "To";
                            Object upperBoundDate = PropertyUtils.getProperty((Object)criteria, (String)upperBoundName);
                            if (upperBoundDate != null) {
                                values = new String[]{CoreApiServiceLocator.getDateTimeService().toDateTimeString(((DateTime)upperBoundDate).toDate())};
                            }
                        }
                    } else {
                        values = new String[]{ObjectUtils.toString((Object)PropertyUtils.getProperty((Object)criteria, (String)field.getPropertyName()))};
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (values == null) continue;
            this.getFormFields().setFieldValue(field, values);
        }
        return true;
    }

    public boolean performCustomAction(boolean ignoreErrors) {
        if (this.isClearSavedSearch()) {
            KEWServiceLocator.getDocumentSearchService().clearNamedSearches(GlobalVariables.getUserSession().getPrincipalId());
            return false;
        }
        if (this.getSavedSearchName() != null) {
            return this.loadSavedSearch(ignoreErrors);
        }
        this.toggleFormView();
        return false;
    }

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        DocumentSearchCriteriaBo criteriaBo = (DocumentSearchCriteriaBo)bo;
        if ("documentId".equals(propertyName)) {
            return this.generateDocumentHandlerUrl(criteriaBo.getDocumentId(), criteriaBo.getDocumentType(), this.isSuperUserSearch());
        }
        if ("routeLog".equals(propertyName)) {
            return this.generateRouteLogUrl(criteriaBo.getDocumentId());
        }
        if ("initiatorDisplayName".equals(propertyName)) {
            return this.generateInitiatorUrl(criteriaBo.getInitiatorPrincipalId());
        }
        return super.getInquiryUrl(bo, propertyName);
    }

    protected HtmlData.AnchorHtmlData generateDocumentHandlerUrl(String documentId, DocumentType documentType, boolean superUserSearch) {
        DocumentTypePolicy policy;
        HtmlData.AnchorHtmlData link = new HtmlData.AnchorHtmlData();
        link.setDisplayText(documentId);
        if (this.isDocumentHandlerPopup()) {
            policy = documentType.getDocSearchTarget();
            if (policy.getPolicyStringValue() != null) {
                link.setTarget(policy.getPolicyStringValue().toLowerCase());
            } else {
                link.setTarget("_blank");
            }
        } else {
            policy = documentType.getDocSearchTarget();
            if (policy.getPolicyStringValue() != null) {
                link.setTarget(policy.getPolicyStringValue().toLowerCase());
            } else {
                link.setTarget("_self");
            }
        }
        String url = ConfigContext.getCurrentContextConfig().getProperty("kew.url") + "/";
        url = superUserSearch ? (documentType.getUseWorkflowSuperUserDocHandlerUrl().getPolicyValue().booleanValue() ? url + "SuperUser.do?methodToCall=displaySuperUserDocument&documentId=" + documentId : "DocHandler.do?command=displaySuperUserView&docId=" + documentId) : url + "DocHandler.do?command=displayDocSearchView&docId=" + documentId;
        link.setHref(url);
        return link;
    }

    protected HtmlData.AnchorHtmlData generateRouteLogUrl(String documentId) {
        HtmlData.AnchorHtmlData link = new HtmlData.AnchorHtmlData();
        if (this.isRouteLogPopup()) {
            link.setTarget("_blank");
        } else {
            link.setTarget("_self");
        }
        link.setDisplayText("Route Log for document " + documentId);
        String url = ConfigContext.getCurrentContextConfig().getProperty("kew.url") + "/" + "RouteLog.do?documentId=" + documentId;
        link.setHref(url);
        return link;
    }

    protected HtmlData.AnchorHtmlData generateInitiatorUrl(String principalId) {
        HtmlData.AnchorHtmlData link = new HtmlData.AnchorHtmlData();
        if (StringUtils.isBlank((String)principalId)) {
            return link;
        }
        if (this.isRouteLogPopup()) {
            link.setTarget("_blank");
        } else {
            link.setTarget("_self");
        }
        link.setDisplayText("Initiator Inquiry for User with ID:" + principalId);
        String url = ConfigContext.getCurrentContextConfig().getProperty("kim.url") + "/" + "identityManagementPersonInquiry.do?principalId=" + principalId;
        link.setHref(url);
        return link;
    }

    protected boolean isDocumentHandlerPopup() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "DocumentSearch", "DOCUMENT_SEARCH_POPUP_IND"), (boolean)true);
    }

    public boolean isRouteLogPopup() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "DocumentSearch", "DOCUMENT_SEARCH_ROUTE_LOG_POPUP_IND"), (boolean)true);
    }

    protected boolean isFlagSet(String flagName) {
        Object[] params;
        if (this.getParameters().containsKey(flagName) && ArrayUtils.isNotEmpty((Object[])(params = (String[])this.getParameters().get(flagName)))) {
            return "YES".equalsIgnoreCase((String)params[0]);
        }
        return false;
    }

    protected boolean isSuperUserSearch() {
        return this.isFlagSet("superUserSearch");
    }

    protected boolean isAdvancedSearch() {
        return this.isFlagSet("isAdvancedSearch");
    }

    protected boolean isClearSavedSearch() {
        return this.isFlagSet("resetSavedSearch");
    }

    protected String getSavedSearchName() {
        String[] savedSearchName = (String[])this.getParameters().get(SAVED_SEARCH_NAME_PARAM);
        if (savedSearchName != null && savedSearchName.length > 0) {
            return savedSearchName[0];
        }
        return null;
    }

    protected void setRows() {
        this.setRows(null);
    }

    protected FormFields getFormFields() {
        return new FormFields(this.getRows());
    }

    protected void setRows(String documentTypeName) {
        super.setRows();
        ArrayList<Row> lookupRows = new ArrayList<Row>();
        for (Row row : this.getRows()) {
            lookupRows.add(row);
        }
        this.getRows().clear();
        DocumentType docType = DocumentSearchCriteriaBoLookupableHelperService.getValidDocumentType(documentTypeName);
        boolean advancedSearch = this.isAdvancedSearch();
        boolean superUserSearch = this.isSuperUserSearch();
        List<Row> rows = this.getDocumentSearchCriteriaProcessor().getRows(docType, lookupRows, advancedSearch, superUserSearch);
        BusinessObjectEntry boe = (BusinessObjectEntry)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(this.getBusinessObjectClass().getName());
        int numCols = boe.getLookupDefinition().getNumOfColumns();
        if (numCols == 0) {
            numCols = 1;
        }
        super.getRows().addAll(FieldUtils.wrapFields(new FormFields(rows).getFieldList(), (int)numCols));
    }

    private static DocumentType getValidDocumentType(String documentTypeName) {
        DocumentType documentType;
        if (StringUtils.isNotEmpty((String)documentTypeName) && (documentType = KEWServiceLocator.getDocumentTypeService().findByNameCaseInsensitive(documentTypeName.trim())) != null && documentType.isActive()) {
            return documentType;
        }
        return null;
    }

    public String getSupplementalMenuBar() {
        boolean advancedSearch = this.isAdvancedSearch();
        boolean superUserSearch = this.isSuperUserSearch();
        StringBuilder suppMenuBar = new StringBuilder();
        String type = advancedSearch ? "basic" : "detailed";
        suppMenuBar.append(MessageFormat.format(TOGGLE_BUTTON, "toggleAdvancedSearch", "/kew", type, type));
        suppMenuBar.append("&nbsp;");
        suppMenuBar.append(MessageFormat.format(TOGGLE_BUTTON, "toggleSuperUserSearch", "/kew", superUserSearch ? "nonsupu" : "superuser", superUserSearch ? "non-superuser" : "superuser"));
        suppMenuBar.append("&nbsp;");
        suppMenuBar.append(MessageFormat.format(TOGGLE_BUTTON, "resetSavedSearch", "/kew", "clearsaved", "clear saved searches"));
        suppMenuBar.append("<script type=\"text/javascript\"> jQuery(document).ready(function () { jQuery(\"#documentTypeName\").blur(function () { validateDocTypeAndRefresh( this ); });});</script>");
        return suppMenuBar.toString();
    }

    public boolean shouldDisplayHeaderNonMaintActions() {
        return true;
    }

    public boolean shouldDisplayLookupCriteria() {
        return true;
    }

    public boolean checkForAdditionalFields(Map<String, String> fieldValues) {
        return this.checkForAdditionalFieldsForDocumentType(fieldValues.get(DOCUMENT_TYPE_NAME_PARAM));
    }

    private boolean checkForAdditionalFieldsMultiValued(Map<String, String[]> fieldValues) {
        String[] valArray = fieldValues.get(DOCUMENT_TYPE_NAME_PARAM);
        String val = null;
        if (valArray != null && valArray.length > 0) {
            val = valArray[0];
        }
        return this.checkForAdditionalFieldsForDocumentType(val);
    }

    private boolean checkForAdditionalFieldsForDocumentType(String documentTypeName) {
        if (StringUtils.isNotBlank((String)documentTypeName)) {
            this.setRows(documentTypeName);
        }
        return true;
    }

    public Field getExtraField() {
        SavedSearchValuesFinder savedSearchValuesFinder = new SavedSearchValuesFinder();
        List<KeyValue> savedSearchValues = savedSearchValuesFinder.getKeyValues();
        Field savedSearch = new Field();
        savedSearch.setPropertyName(SAVED_SEARCH_NAME_PARAM);
        savedSearch.setFieldType("dropdown_script");
        savedSearch.setScript("customLookupChanged()");
        savedSearch.setFieldValidValues(savedSearchValues);
        savedSearch.setFieldLabel("Saved Searches");
        return savedSearch;
    }

    public void performClear(LookupForm lookupForm) {
        Map formFields = LookupUtils.preProcessRangeFields((Map)lookupForm.getFields());
        DocumentSearchCriteria criteria = this.loadCriteria(formFields);
        super.performClear(lookupForm);
        this.repopulateSearchTypeFlags();
        DocumentType documentType = DocumentSearchCriteriaBoLookupableHelperService.getValidDocumentType(criteria.getDocumentTypeName());
        if (documentType != null) {
            DocumentSearchCriteria clearedCriteria = this.documentSearchService.clearCriteria(documentType, criteria);
            this.applyCriteriaChangesToFields((DocumentSearchCriteriaContract)DocumentSearchCriteria.Builder.create((DocumentSearchCriteriaContract)clearedCriteria));
        }
    }

    protected void repopulateSearchTypeFlags() {
        boolean advancedSearch = this.isAdvancedSearch();
        boolean superUserSearch = this.isSuperUserSearch();
        boolean fieldsRepopulated = false;
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        values.put("isAdvancedSearch", new String[]{advancedSearch ? "YES" : "NO"});
        values.put("superUserSearch", new String[]{superUserSearch ? "YES" : "NO"});
        this.getFormFields().setFieldValues(values);
    }

    protected void postProcessResults(Collection<ResultRow> resultRows, DocumentSearchResults searchResults) {
        if (resultRows.size() != searchResults.getSearchResults().size()) {
            throw new IllegalStateException("Encountered a mismatch between ResultRow items and document search results " + resultRows.size() + " != " + searchResults.getSearchResults().size());
        }
        DocumentType documentType = DocumentSearchCriteriaBoLookupableHelperService.getValidDocumentType(this.criteria.getDocumentTypeName());
        DocumentSearchResultSetConfiguration resultSetConfiguration = null;
        DocumentSearchCriteriaConfiguration criteriaConfiguration = null;
        if (documentType != null) {
            resultSetConfiguration = KEWServiceLocator.getDocumentSearchCustomizationMediator().customizeResultSetConfiguration(documentType, this.criteria);
            criteriaConfiguration = KEWServiceLocator.getDocumentSearchCustomizationMediator().getDocumentSearchCriteriaConfiguration(documentType);
        }
        int index = 0;
        for (ResultRow resultRow : resultRows) {
            DocumentSearchResult searchResult = (DocumentSearchResult)searchResults.getSearchResults().get(index);
            this.executeColumnCustomization(resultRow, searchResult, resultSetConfiguration, criteriaConfiguration);
            ++index;
        }
    }

    protected void executeColumnCustomization(ResultRow resultRow, DocumentSearchResult searchResult, DocumentSearchResultSetConfiguration resultSetConfiguration, DocumentSearchCriteriaConfiguration criteriaConfiguration) {
        List standardFieldsToRemove;
        if (resultSetConfiguration == null) {
            resultSetConfiguration = DocumentSearchResultSetConfiguration.Builder.create().build();
        }
        if (criteriaConfiguration == null) {
            criteriaConfiguration = DocumentSearchCriteriaConfiguration.Builder.create().build();
        }
        if ((standardFieldsToRemove = resultSetConfiguration.getStandardResultFieldsToRemove()) == null) {
            standardFieldsToRemove = Collections.emptyList();
        }
        ArrayList<Column> newColumns = new ArrayList<Column>();
        for (Column standardColumn : resultRow.getColumns()) {
            if (standardFieldsToRemove.contains(StandardResultField.fromFieldName((String)standardColumn.getPropertyName()))) continue;
            newColumns.add(standardColumn);
            if (!standardColumn.getPropertyName().equals("routeLog")) continue;
            standardColumn.setEscapeXMLValue(false);
        }
        List searchAttributeFields = criteriaConfiguration.getFlattenedSearchAttributeFields();
        ArrayList<String> additionalFieldNamesToInclude = new ArrayList<String>();
        if (!resultSetConfiguration.isOverrideSearchableAttributes()) {
            for (RemotableAttributeField searchAttributeField : searchAttributeFields) {
                if (searchAttributeField.getAttributeLookupSettings() != null && !searchAttributeField.getAttributeLookupSettings().isInResults()) continue;
                additionalFieldNamesToInclude.add(searchAttributeField.getName());
            }
        }
        if (resultSetConfiguration.getCustomFieldNamesToAdd() != null) {
            additionalFieldNamesToInclude.addAll(resultSetConfiguration.getCustomFieldNamesToAdd());
        }
        ArrayList<Column> customColumns = new ArrayList<Column>();
        List additionalAttributeColumns = FieldUtils.constructColumnsFromAttributeFields((List)resultSetConfiguration.getAdditionalAttributeFields());
        block2: for (String additionalFieldNameToInclude : additionalFieldNamesToInclude) {
            for (RemotableAttributeField searchAttributeField : searchAttributeFields) {
                if (!additionalFieldNameToInclude.equals(searchAttributeField.getName())) continue;
                Column searchAttributeColumn = FieldUtils.constructColumnFromAttributeField((RemotableAttributeField)searchAttributeField);
                this.wrapDocumentAttributeColumnName(searchAttributeColumn);
                customColumns.add(searchAttributeColumn);
                continue block2;
            }
            for (Column additionalAttributeColumn : additionalAttributeColumns) {
                if (!additionalFieldNameToInclude.equals(additionalAttributeColumn.getPropertyName())) continue;
                this.wrapDocumentAttributeColumnName(additionalAttributeColumn);
                customColumns.add(additionalAttributeColumn);
                continue block2;
            }
            LOG.warn((Object)("Failed to locate a proper column definition for requested additional field to include inresult set with name '" + additionalFieldNameToInclude + "'"));
        }
        this.populateCustomColumns(customColumns, searchResult);
        Column columnToRemove = null;
        for (Column column : customColumns) {
            if (!column.getColumnTitle().equals("Actions")) continue;
            newColumns.add(0, column);
            columnToRemove = column;
            break;
        }
        if (columnToRemove != null) {
            customColumns.remove(columnToRemove);
        }
        if (newColumns.isEmpty() || !StandardResultField.ROUTE_LOG.isFieldNameValid(((Column)newColumns.get(newColumns.size() - 1)).getPropertyName())) {
            newColumns.addAll(customColumns);
        } else {
            newColumns.addAll(newColumns.size() - 1, customColumns);
        }
        resultRow.setColumns(newColumns);
    }

    protected void populateCustomColumns(List<Column> customColumns, DocumentSearchResult searchResult) {
        for (Column customColumn : customColumns) {
            HtmlData.AnchorHtmlData anchorHtml;
            DocumentAttribute documentAttribute = searchResult.getSingleDocumentAttributeByName(customColumn.getPropertyName());
            if (documentAttribute == null || documentAttribute.getValue() == null) continue;
            this.wrapDocumentAttributeColumnName(customColumn);
            Formatter formatter = customColumn.getFormatter();
            Object attributeValue = documentAttribute.getValue();
            if (formatter.getPropertyType().equals(KualiDecimal.class) && documentAttribute.getValue() instanceof BigDecimal) {
                attributeValue = new KualiDecimal((BigDecimal)attributeValue);
            } else if (formatter.getPropertyType().equals(KualiPercent.class) && documentAttribute.getValue() instanceof BigDecimal) {
                attributeValue = new KualiPercent((BigDecimal)attributeValue);
            }
            customColumn.setPropertyValue(formatter.format(attributeValue).toString());
            HtmlData anchor = customColumn.getColumnAnchor();
            if (anchor == null || !(anchor instanceof HtmlData.AnchorHtmlData) || !StringUtils.isEmpty((String)(anchorHtml = (HtmlData.AnchorHtmlData)anchor).getHref()) || !StringUtils.isEmpty((String)anchorHtml.getTitle())) continue;
            customColumn.setColumnAnchor((HtmlData)new HtmlData.AnchorHtmlData(formatter.format(attributeValue).toString(), documentAttribute.getName()));
        }
    }

    private void wrapDocumentAttributeColumnName(Column column) {
    }

    public void setDocumentSearchService(DocumentSearchService documentSearchService) {
        this.documentSearchService = documentSearchService;
    }

    public DocumentSearchService getDocumentSearchService() {
        return this.documentSearchService;
    }

    public DocumentSearchCriteriaProcessor getDocumentSearchCriteriaProcessor() {
        return this.documentSearchCriteriaProcessor;
    }

    public void setDocumentSearchCriteriaProcessor(DocumentSearchCriteriaProcessor documentSearchCriteriaProcessor) {
        this.documentSearchCriteriaProcessor = documentSearchCriteriaProcessor;
    }

    public DocumentSearchCriteriaTranslator getDocumentSearchCriteriaTranslator() {
        return this.documentSearchCriteriaTranslator;
    }

    public void setDocumentSearchCriteriaTranslator(DocumentSearchCriteriaTranslator documentSearchCriteriaTranslator) {
        this.documentSearchCriteriaTranslator = documentSearchCriteriaTranslator;
    }
}

