/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes.service.impl;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import java.net.URLEncoder;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.service.AttachmentService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class AmazonS3AttachmentServiceImpl
implements AttachmentService,
InitializingBean {
    private ResourceLoader resourceLoader;
    private String bucketName;
    private String folderName;
    private AmazonS3 amazonS3;

    public void afterPropertiesSet() {
        if (StringUtils.isBlank((CharSequence)this.folderName)) {
            throw new IllegalStateException("S3 attachment service must be configured with a non-blank folder name");
        }
        if (StringUtils.isBlank((CharSequence)this.bucketName)) {
            throw new IllegalStateException("S3 attachment service must be configured with a non-blank bucket name");
        }
    }

    @Override
    public void persistAttachedFileAndSetAttachmentBusinessObjectValue(Attachment attachment) throws Exception {
        if (attachment.getFileLoc() == null) {
            String s3Url = this.generateS3Url(attachment);
            attachment.setFileLoc(s3Url);
        }
        TransferManager manager = new TransferManager(this.amazonS3);
        ObjectMetadata metadata = new ObjectMetadata();
        if (attachment.getMimeType() != null) {
            metadata.setContentType(attachment.getMimeType());
        }
        if (attachment.getFileName() != null) {
            metadata.setContentDisposition("attachment; filename=" + URLEncoder.encode(attachment.getFileName(), "UTF-8"));
        }
        Upload upload = manager.upload(this.bucketName, this.parseObjectKey(attachment.getFileLoc()), attachment.getAttachedObject(), metadata);
        upload.waitForCompletion();
    }

    @Override
    public File findAttachedFile(Attachment attachment) throws Exception {
        throw new UnsupportedOperationException("S3 Attachment Service implementation cannot provide a file, please you \"findAttachedResource\" instead.");
    }

    @Override
    public Resource findAttachedResource(Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("Given attachment was null");
        }
        if (StringUtils.isBlank((CharSequence)attachment.getFileLoc())) {
            throw new IllegalArgumentException("Given attachment has an empty file location");
        }
        return this.resourceLoader.getResource(attachment.getFileLoc());
    }

    @Override
    public void deleteAttachedFile(Attachment attachment) throws Exception {
        this.amazonS3.deleteObject(new DeleteObjectRequest(this.bucketName, this.parseObjectKey(attachment.getFileLoc())));
    }

    private String generateS3Url(Attachment attachment) {
        return this.generateS3Prefix() + this.folderName + "/" + UUID.randomUUID();
    }

    private String generateS3Prefix() {
        return "s3://" + this.bucketName + "/";
    }

    private String parseObjectKey(String s3Url) {
        String prefix = this.generateS3Prefix();
        String objectKey = s3Url.substring(prefix.length());
        return objectKey;
    }

    @Required
    @Autowired
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Required
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    @Required
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Required
    @Autowired
    public void setAmazonS3(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
    }
}

