/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.preferences.web;

import java.io.Serializable;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.api.preferences.PreferencesContract;
import org.kuali.rice.kew.api.preferences.PreferencesService;
import org.kuali.rice.kew.preferences.web.PreferencesForm;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class PreferencesAction
extends KewKualiAction {
    private static final String DOC_TYPE_NAME_PROPERTY = "documentTypePreferenceName";
    private static final String DOCUMENT_TYPE_ERROR = "docType.preference.name.required";
    private static final String DOCUMENT_TYPE_PREFERENCE_ADDED_MESSAGE = "docType.preference.added.message";
    private static final String DOCUMENT_TYPE_PREFERENCE_REMOVED_MESSAGE = "docType.preference.removed.message";
    private static final String DOC_TYPE_PARAM = "documentType";
    private static final String PREFERENCE_VALUE_PARAM = "preferenceValue";
    public static final String SAVE_REMINDER_ATTR = "saveReminder";
    private PreferencesService preferencesService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initForm(request, form);
        request.setAttribute("Constants", this.getServlet().getServletContext().getAttribute("KewApiConstants"));
        return super.execute(mapping, form, request, response);
    }

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PreferencesForm preferencesForm = (PreferencesForm)form;
        Preferences preferences = this.getPreferencesService().getPreferences(PreferencesAction.getUserSession().getPrincipalId());
        preferencesForm.setPreferences(Preferences.Builder.create((PreferencesContract)preferences));
        return mapping.findForward("basic");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PreferencesForm prefForm = (PreferencesForm)form;
        prefForm.validatePreferences();
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            this.getPreferencesService().savePreferences(PreferencesAction.getUserSession().getPrincipalId(), prefForm.getPreferences().build());
        }
        GlobalVariables.getUserSession().addObject("updateActionList", (Serializable)Boolean.TRUE);
        GlobalVariables.getUserSession().removeObject("Preferences");
        if (!StringUtils.isEmpty((String)prefForm.getReturnMapping())) {
            return mapping.findForward(prefForm.getReturnMapping());
        }
        return mapping.findForward("basic");
    }

    public ActionMessages initForm(HttpServletRequest request, ActionForm form) throws Exception {
        request.setAttribute("actionListContent", (Object)KewApiConstants.ACTION_LIST_CONTENT);
        this.getDelegatorFilterChoices(request);
        this.getPrimaryDelegateFilterChoices(request);
        PreferencesForm prefForm = (PreferencesForm)form;
        prefForm.setShowOutbox(ConfigContext.getCurrentContextConfig().getOutBoxOn());
        return null;
    }

    public void getDelegatorFilterChoices(HttpServletRequest request) {
        ArrayList<ConcreteKeyValue> delegatorFilterChoices = new ArrayList<ConcreteKeyValue>();
        delegatorFilterChoices.add(new ConcreteKeyValue("Secondary Delegators only on Filter Page", "Secondary Delegators only on Filter Page"));
        delegatorFilterChoices.add(new ConcreteKeyValue("Secondary Delegators on Action List Page", "Secondary Delegators on Action List Page"));
        request.setAttribute("delegatorFilter", delegatorFilterChoices);
    }

    public void getPrimaryDelegateFilterChoices(HttpServletRequest request) {
        ArrayList<ConcreteKeyValue> primaryDelegateFilterChoices = new ArrayList<ConcreteKeyValue>();
        primaryDelegateFilterChoices.add(new ConcreteKeyValue("Primary Delegates only on Filter Page", "Primary Delegates only on Filter Page"));
        primaryDelegateFilterChoices.add(new ConcreteKeyValue("Primary Delegates on Action List Page", "Primary Delegates on Action List Page"));
        request.setAttribute("primaryDelegateFilter", primaryDelegateFilterChoices);
    }

    private static UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }

    public ActionForward addNotificationPreference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PreferencesForm preferencesForm = (PreferencesForm)form;
        if (this.validateAddNotificationPreference(preferencesForm)) {
            preferencesForm.getPreferences().addDocumentTypeNotificationPreference(preferencesForm.getDocumentTypePreferenceName(), preferencesForm.getDocumentTypePreferenceValue());
            preferencesForm.setDocumentTypePreferenceName(null);
            preferencesForm.setDocumentTypePreferenceValue(null);
            GlobalVariables.getMessageMap().putInfo(DOC_TYPE_NAME_PROPERTY, DOCUMENT_TYPE_PREFERENCE_ADDED_MESSAGE, new String[0]);
            request.setAttribute(SAVE_REMINDER_ATTR, (Object)"true");
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteNotificationPreference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PreferencesForm preferencesForm = (PreferencesForm)form;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentType = StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)parameterName, (String)"."), (String)"deleteNotificationPreference.");
        preferencesForm.getPreferences().removeDocumentTypeNotificationPreference(documentType);
        GlobalVariables.getMessageMap().putInfo(DOC_TYPE_NAME_PROPERTY, DOCUMENT_TYPE_PREFERENCE_REMOVED_MESSAGE, new String[0]);
        request.setAttribute(SAVE_REMINDER_ATTR, (Object)"true");
        return mapping.findForward("basic");
    }

    private boolean validateAddNotificationPreference(PreferencesForm form) {
        if (StringUtils.isEmpty((String)form.getDocumentTypePreferenceName()) || StringUtils.isEmpty((String)form.getDocumentTypePreferenceValue())) {
            GlobalVariables.getMessageMap().putError(DOC_TYPE_NAME_PROPERTY, DOCUMENT_TYPE_ERROR, new String[0]);
        } else {
            DocumentType docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(form.getDocumentTypePreferenceName());
            if (docType == null) {
                GlobalVariables.getMessageMap().putError(DOC_TYPE_NAME_PROPERTY, DOCUMENT_TYPE_ERROR, new String[0]);
            }
        }
        return GlobalVariables.getMessageMap().getErrorMessages().size() == 0;
    }

    public ActionForward registerDocumentTypePreference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PreferencesForm preferencesForm = (PreferencesForm)form;
        this.start(mapping, (ActionForm)preferencesForm, request, response);
        preferencesForm.setDocumentTypePreferenceName(request.getParameter(DOC_TYPE_PARAM));
        preferencesForm.setDocumentTypePreferenceValue(request.getParameter(PREFERENCE_VALUE_PARAM));
        this.addNotificationPreference(mapping, (ActionForm)preferencesForm, request, response);
        return this.save(mapping, (ActionForm)preferencesForm, request, response);
    }

    public PreferencesService getPreferencesService() {
        if (this.preferencesService == null) {
            this.preferencesService = KewApiServiceLocator.getPreferencesService();
        }
        return this.preferencesService;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }
}

