/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.resourceloader;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.ServiceLocator;
import org.kuali.rice.core.impl.resourceloader.BaseWrappingResourceLoader;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.plugin.PluginRegistry;

public class CoreResourceLoader
extends BaseWrappingResourceLoader {
    public static final QName NAME = new QName(CoreConfigHelper.getApplicationId(), "KEW_SPRING+PLUGIN_REGISTRY_CONTAINER_RESOURCE_LOADER");
    private final PluginRegistry registry;

    public CoreResourceLoader(ServiceLocator serviceLocator, PluginRegistry registry) {
        super(NAME, serviceLocator);
        this.registry = registry;
    }

    public Object getService(QName serviceName) {
        if (this.isRemoteService(serviceName)) {
            return null;
        }
        Object service = super.getService(serviceName);
        if (service == null && this.getRegistry() != null) {
            service = this.getRegistry().getService(serviceName);
        }
        return service;
    }

    public Object getObject(ObjectDefinition objectDefinition) {
        Object object = super.getObject(objectDefinition);
        if (object == null && this.getRegistry() != null) {
            object = this.getRegistry().getObject(objectDefinition);
        }
        return object;
    }

    protected boolean shouldWrapService(QName serviceName, Object service) {
        if (serviceName.getLocalPart().equals("transactionTemplate")) {
            return false;
        }
        return super.shouldWrapService(serviceName, service);
    }

    public void stop() throws Exception {
        if (this.getRegistry() != null) {
            this.registry.stop();
        }
        super.stop();
    }

    protected boolean isRemoteService(QName serviceName) {
        return this.useRemoteEmailServices() && serviceName.getLocalPart().equals(KewApiServiceLocator.IMMEDIATE_EMAIL_REMINDER_QUEUE.getLocalPart());
    }

    protected boolean useRemoteEmailServices() {
        String useRemoteEmailServicesValue = ConfigContext.getCurrentContextConfig().getProperty("Email.useRemoteServices");
        if (!StringUtils.isBlank((String)useRemoteEmailServicesValue)) {
            return new Boolean(useRemoteEmailServicesValue.trim());
        }
        return false;
    }

    public PluginRegistry getRegistry() {
        return this.registry;
    }
}

