/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.CustomActionListAttribute;
import org.kuali.rice.kew.actionlist.DefaultCustomActionListAttribute;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContract;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentUpdate;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.docsearch.DocumentSearchCriteriaEbo;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.CompatUtils;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.mail.CustomEmailAttribute;
import org.kuali.rice.kew.mail.CustomEmailAttributeImpl;
import org.kuali.rice.kew.notes.CustomNoteAttribute;
import org.kuali.rice.kew.notes.CustomNoteAttributeImpl;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kew.routeheader.DocumentStatusTransition;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KREW_DOC_HDR_T")
@NamedQueries(value={@NamedQuery(name="DocumentRouteHeaderValue.QuickLinks.FindWatchedDocumentsByInitiatorWorkflowId", query="SELECT d FROM DocumentRouteHeaderValue d WHERE d.initiatorWorkflowId = :initiatorWorkflowId AND d.docRouteStatus IN ('R','E') ORDER BY d.createDate DESC"), @NamedQuery(name="DocumentRouteHeaderValue.GetAppDocId", query="SELECT d.appDocId from DocumentRouteHeaderValue as d where d.documentId = :documentId"), @NamedQuery(name="DocumentRouteHeaderValue.GetAppDocStatus", query="SELECT d.appDocStatus from DocumentRouteHeaderValue as d where d.documentId = :documentId"), @NamedQuery(name="DocumentRouteHeaderValue.GetDocumentHeaders", query="SELECT d from DocumentRouteHeaderValue as d where d.documentId IN :documentIds"), @NamedQuery(name="DocumentRouteHeaderValue.GetDocumentStatus", query="SELECT d.docRouteStatus from DocumentRouteHeaderValue as d where d.documentId = :documentId"), @NamedQuery(name="DocumentRouteHeaderValue.GetDocumentIdByDocTypeAndAppId", query="SELECT DISTINCT(DH.documentId) FROM DocumentRouteHeaderValue DH, DocumentType DT WHERE DH.appDocId = :appDocId AND DH.documentTypeId = DT.documentTypeId  AND DT.name = :name")})
@NamedEntityGraphs(value={@NamedEntityGraph(name="DocumentRouteHeaderValue.ActionListAttributesOnly", attributeNodes={@NamedAttributeNode(value="approvedDate"), @NamedAttributeNode(value="createDate"), @NamedAttributeNode(value="docRouteStatus"), @NamedAttributeNode(value="initiatorWorkflowId"), @NamedAttributeNode(value="appDocStatus"), @NamedAttributeNode(value="documentId"), @NamedAttributeNode(value="docRouteLevel"), @NamedAttributeNode(value="documentTypeId"), @NamedAttributeNode(value="docVersion")})})
@Cacheable(value=false)
public class DocumentRouteHeaderValue
extends DataObjectBase
implements DocumentContract,
DocumentSearchCriteriaEbo,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -4700736340527913220L;
    private static final Logger LOG = Logger.getLogger(DocumentRouteHeaderValue.class);
    private static final String TERMINAL = "";
    private static final boolean FINAL_STATE = true;
    protected static final HashMap<String, String> legalActions;
    protected static final HashMap<String, String> stateTransitionMap;
    public static final String CURRENT_ROUTE_NODE_NAME_DELIMITER = ", ";
    @Id
    @GeneratedValue(generator="KREW_DOC_HDR_S")
    @PortableSequenceGenerator(name="KREW_DOC_HDR_S")
    @Column(name="DOC_HDR_ID", nullable=false)
    private String documentId;
    @Column(name="DOC_TYP_ID")
    private String documentTypeId;
    @Column(name="DOC_HDR_STAT_CD", nullable=false)
    private String docRouteStatus;
    @Column(name="RTE_LVL", nullable=false)
    private Integer docRouteLevel;
    @Column(name="STAT_MDFN_DT", nullable=false)
    private Timestamp dateModified;
    @Column(name="CRTE_DT", nullable=false)
    private Timestamp createDate;
    @Column(name="APRV_DT")
    private Timestamp approvedDate;
    @Column(name="FNL_DT")
    private Timestamp finalizedDate;
    @Column(name="TTL")
    private String docTitle;
    @Column(name="APP_DOC_ID")
    private String appDocId;
    @Column(name="DOC_VER_NBR", nullable=false)
    private Integer docVersion = new Integer(1);
    @Column(name="INITR_PRNCPL_ID", nullable=false)
    private String initiatorWorkflowId;
    @Column(name="RTE_PRNCPL_ID")
    private String routedByUserWorkflowId;
    @Column(name="RTE_STAT_MDFN_DT")
    private Timestamp routeStatusDate;
    @Column(name="APP_DOC_STAT")
    private String appDocStatus;
    @Column(name="APP_DOC_STAT_MDFN_DT")
    private Timestamp appDocStatusDate;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="KREW_INIT_RTE_NODE_INSTN_T", joinColumns={@JoinColumn(name="DOC_HDR_ID")}, inverseJoinColumns={@JoinColumn(name="RTE_NODE_INSTN_ID")})
    private List<RouteNodeInstance> initialRouteNodeInstances = new ArrayList<RouteNodeInstance>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="documentRouteHeaderValue")
    @OrderBy(value="statusTransitionId ASC")
    private List<DocumentStatusTransition> appDocStatusHistory = new ArrayList<DocumentStatusTransition>();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="DOC_HDR_ID")
    @OrderBy(value="noteId ASC")
    private List<Note> notes = new ArrayList<Note>();
    @Transient
    private DocumentRouteHeaderValueContent documentContent;
    @Transient
    private boolean routingReport = false;
    @Transient
    private List<ActionRequestValue> simulatedActionRequests;

    public Principal getInitiatorPrincipal() {
        if (StringUtils.isBlank((String)this.getInitiatorWorkflowId())) {
            return null;
        }
        return KEWServiceLocator.getIdentityHelperService().getPrincipal(this.getInitiatorWorkflowId());
    }

    public Principal getRoutedByPrincipal() {
        if (this.getRoutedByUserWorkflowId() == null) {
            return null;
        }
        return KEWServiceLocator.getIdentityHelperService().getPrincipal(this.getRoutedByUserWorkflowId());
    }

    public String getInitiatorDisplayName() {
        try {
            Person person = KEWServiceLocator.getIdentityHelperService().getPerson(this.getInitiatorWorkflowId());
            return person.getName();
        }
        catch (RiceIllegalArgumentException e) {
            return this.getInitiatorWorkflowId();
        }
    }

    public String getRoutedByDisplayName() {
        return KEWServiceLocator.getIdentityHelperService().getPerson(this.getRoutedByUserWorkflowId()).getName();
    }

    public String getCurrentRouteLevelName() {
        String name = "Not Found";
        if (this.routingReport) {
            name = "Routing Report";
        } else if (CompatUtils.isRouteLevelDocument(this)) {
            int routeLevelInt = this.getDocRouteLevel();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Getting current route level name for a Route level document: " + routeLevelInt + CURRENT_ROUTE_NODE_NAME_DELIMITER + this._persistence_get_documentId()));
            }
            List<RouteNode> routeLevelNodes = CompatUtils.getRouteLevelCompatibleNodeList(this.getDocumentType());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Route level compatible node list has " + routeLevelNodes.size() + " nodes"));
            }
            if (routeLevelInt < routeLevelNodes.size()) {
                name = routeLevelNodes.get(routeLevelInt).getRouteNodeName();
            }
        } else {
            List<String> currentNodeNames = this.getCurrentNodeNames();
            name = StringUtils.join(currentNodeNames, (String)CURRENT_ROUTE_NODE_NAME_DELIMITER);
        }
        return name;
    }

    public List<String> getCurrentNodeNames() {
        return KEWServiceLocator.getRouteNodeService().getCurrentRouteNodeNames(this.getDocumentId());
    }

    public String getRouteStatusLabel() {
        return CodeTranslator.getRouteStatusLabel((String)this.getDocRouteStatus());
    }

    public String getDocRouteStatusLabel() {
        return CodeTranslator.getRouteStatusLabel((String)this.getDocRouteStatus());
    }

    public String getDocStatusPolicy() {
        return this.getDocumentType().getDocumentStatusPolicy().getPolicyStringValue();
    }

    public List<ActionItem> getActionItems() {
        return (List)KEWServiceLocator.getActionListService().findByDocumentId(this._persistence_get_documentId());
    }

    public List<ActionTakenValue> getActionsTaken() {
        return KEWServiceLocator.getActionTakenService().findByDocumentIdIgnoreCurrentInd(this._persistence_get_documentId());
    }

    public List<ActionRequestValue> getActionRequests() {
        if (this.simulatedActionRequests == null || this.simulatedActionRequests.isEmpty()) {
            return KEWServiceLocator.getActionRequestService().findByDocumentIdIgnoreCurrentInd(this._persistence_get_documentId());
        }
        return this.simulatedActionRequests;
    }

    public List<ActionRequestValue> getSimulatedActionRequests() {
        if (this.simulatedActionRequests == null) {
            this.simulatedActionRequests = new ArrayList<ActionRequestValue>();
        }
        return this.simulatedActionRequests;
    }

    public void setSimulatedActionRequests(List<ActionRequestValue> simulatedActionRequests) {
        this.simulatedActionRequests = simulatedActionRequests;
    }

    public DocumentType getDocumentType() {
        return KEWServiceLocator.getDocumentTypeService().findById(this.getDocumentTypeId());
    }

    public String getAppDocId() {
        return this._persistence_get_appDocId();
    }

    public void setAppDocId(String appDocId) {
        this._persistence_set_appDocId(appDocId);
    }

    public Timestamp getApprovedDate() {
        return this._persistence_get_approvedDate();
    }

    public void setApprovedDate(Timestamp approvedDate) {
        this._persistence_set_approvedDate(approvedDate);
    }

    public Timestamp getCreateDate() {
        return this._persistence_get_createDate();
    }

    public void setCreateDate(Timestamp createDate) {
        this._persistence_set_createDate(createDate);
    }

    public String getDocContent() {
        return this.getDocumentContent().getDocumentContent();
    }

    public void setDocContent(String docContent) {
        DocumentRouteHeaderValueContent content = this.getDocumentContent();
        content.setDocumentContent(docContent);
    }

    public Integer getDocRouteLevel() {
        return this._persistence_get_docRouteLevel();
    }

    public void setDocRouteLevel(Integer docRouteLevel) {
        this._persistence_set_docRouteLevel(docRouteLevel);
    }

    public String getDocRouteStatus() {
        return this._persistence_get_docRouteStatus();
    }

    public void setDocRouteStatus(String docRouteStatus) {
        this._persistence_set_docRouteStatus(docRouteStatus);
    }

    public String getDocTitle() {
        return this._persistence_get_docTitle();
    }

    public void setDocTitle(String docTitle) {
        this._persistence_set_docTitle(docTitle);
    }

    public String getDocumentTypeId() {
        return this._persistence_get_documentTypeId();
    }

    public void setDocumentTypeId(String documentTypeId) {
        this._persistence_set_documentTypeId(documentTypeId);
    }

    public Integer getDocVersion() {
        return this._persistence_get_docVersion();
    }

    public void setDocVersion(Integer docVersion) {
        this._persistence_set_docVersion(docVersion);
    }

    public Timestamp getFinalizedDate() {
        return this._persistence_get_finalizedDate();
    }

    public void setFinalizedDate(Timestamp finalizedDate) {
        this._persistence_set_finalizedDate(finalizedDate);
    }

    public String getInitiatorWorkflowId() {
        return this._persistence_get_initiatorWorkflowId();
    }

    public void setInitiatorWorkflowId(String initiatorWorkflowId) {
        this._persistence_set_initiatorWorkflowId(initiatorWorkflowId);
    }

    public String getRoutedByUserWorkflowId() {
        if (this.isEnroute() && StringUtils.isBlank((String)this._persistence_get_routedByUserWorkflowId())) {
            return this._persistence_get_initiatorWorkflowId();
        }
        return this._persistence_get_routedByUserWorkflowId();
    }

    public void setRoutedByUserWorkflowId(String routedByUserWorkflowId) {
        this._persistence_set_routedByUserWorkflowId(routedByUserWorkflowId);
    }

    @Override
    public String getDocumentId() {
        return this._persistence_get_documentId();
    }

    public void setDocumentId(String documentId) {
        this._persistence_set_documentId(documentId);
    }

    public Timestamp getRouteStatusDate() {
        return this._persistence_get_routeStatusDate();
    }

    public void setRouteStatusDate(Timestamp routeStatusDate) {
        this._persistence_set_routeStatusDate(routeStatusDate);
    }

    public Timestamp getDateModified() {
        return this._persistence_get_dateModified();
    }

    public void setDateModified(Timestamp dateModified) {
        this._persistence_set_dateModified(dateModified);
    }

    public String getAppDocStatus() {
        if (StringUtils.isBlank((String)this._persistence_get_appDocStatus())) {
            return KewApiConstants.UNKNOWN_STATUS;
        }
        return this._persistence_get_appDocStatus();
    }

    public void setAppDocStatus(String appDocStatus) {
        this._persistence_set_appDocStatus(appDocStatus);
    }

    public String getCombinedStatus() {
        String routeStatus = this.getRouteStatusLabel();
        String appStatus = this.getAppDocStatus();
        if (StringUtils.isNotEmpty((String)routeStatus)) {
            if (StringUtils.isNotEmpty((String)appStatus)) {
                routeStatus = routeStatus + CURRENT_ROUTE_NODE_NAME_DELIMITER + appStatus;
            }
        } else {
            return appStatus;
        }
        return routeStatus;
    }

    public void updateAppDocStatus(String appDocStatus) throws WorkflowRuntimeException {
        if (appDocStatus != null && appDocStatus.length() > 0 && !appDocStatus.equalsIgnoreCase(this._persistence_get_appDocStatus())) {
            DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findById(this.getDocumentTypeId());
            if (documentType.getValidApplicationStatuses() != null && documentType.getValidApplicationStatuses().size() > 0) {
                Iterator<ApplicationDocumentStatus> iter = documentType.getValidApplicationStatuses().iterator();
                boolean statusValidated = false;
                while (iter.hasNext()) {
                    ApplicationDocumentStatus myAppDocStat = iter.next();
                    if (appDocStatus.compareToIgnoreCase(myAppDocStat.getStatusName()) != 0) continue;
                    statusValidated = true;
                    break;
                }
                if (!statusValidated) {
                    WorkflowRuntimeException xpee = new WorkflowRuntimeException("AppDocStatus value " + appDocStatus + " not allowable.");
                    LOG.error((Object)("Error validating nextAppDocStatus name: " + appDocStatus + " against acceptable values."), (Throwable)xpee);
                    throw xpee;
                }
            }
            String oldStatus = this._persistence_get_appDocStatus();
            this._persistence_set_appDocStatus(appDocStatus);
            this.setAppDocStatusDate(new Timestamp(System.currentTimeMillis()));
            this._persistence_get_appDocStatusHistory().add(new DocumentStatusTransition(this._persistence_get_documentId(), oldStatus, appDocStatus));
        }
    }

    public Timestamp getAppDocStatusDate() {
        return this._persistence_get_appDocStatusDate();
    }

    public void setAppDocStatusDate(Timestamp appDocStatusDate) {
        this._persistence_set_appDocStatusDate(appDocStatusDate);
    }

    public Object copy(boolean preserveKeys) {
        throw new UnsupportedOperationException("The copy method is deprecated and unimplemented!");
    }

    public boolean isStateInitiated() {
        return "I".equals(this._persistence_get_docRouteStatus());
    }

    public boolean isStateSaved() {
        return "S".equals(this._persistence_get_docRouteStatus());
    }

    public boolean isRouted() {
        return !this.isStateInitiated() && !this.isStateSaved();
    }

    public boolean isInException() {
        return "E".equals(this._persistence_get_docRouteStatus());
    }

    public boolean isDisaproved() {
        return "D".equals(this._persistence_get_docRouteStatus());
    }

    public boolean isCanceled() {
        return "X".equals(this._persistence_get_docRouteStatus());
    }

    public boolean isFinal() {
        return "F".equals(this._persistence_get_docRouteStatus());
    }

    public boolean isEnroute() {
        return "R".equals(this._persistence_get_docRouteStatus());
    }

    public boolean isProcessed() {
        return "P".equals(this._persistence_get_docRouteStatus());
    }

    public boolean isRoutable() {
        return "R".equals(this._persistence_get_docRouteStatus()) || "S".equals(this._persistence_get_docRouteStatus()) || "P".equals(this._persistence_get_docRouteStatus());
    }

    public boolean isValidActionToTake(String actionCd) {
        String actions = legalActions.get(this._persistence_get_docRouteStatus());
        return actions.contains(actionCd);
    }

    public boolean isValidStatusChange(String newStatus) {
        return stateTransitionMap.get(this.getDocRouteStatus()).contains(newStatus);
    }

    public void setRouteStatus(String newStatus, boolean finalState) throws InvalidActionTakenException {
        if (newStatus != this.getDocRouteStatus()) {
            this.setRouteStatusDate(new Timestamp(System.currentTimeMillis()));
        }
        if (!stateTransitionMap.get(this.getDocRouteStatus()).contains(newStatus)) {
            LOG.debug((Object)"unable to change status");
            throw new InvalidActionTakenException("Document status " + CodeTranslator.getRouteStatusLabel((String)this.getDocRouteStatus()) + " cannot transition to status " + CodeTranslator.getRouteStatusLabel((String)newStatus));
        }
        LOG.debug((Object)"changing status");
        this.setDocRouteStatus(newStatus);
        this.setDateModified(new Timestamp(System.currentTimeMillis()));
        if (finalState) {
            LOG.debug((Object)"setting final timeStamp");
            this.setFinalizedDate(new Timestamp(System.currentTimeMillis()));
        }
    }

    public void markDocumentProcessed() throws InvalidActionTakenException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " marked processed"));
        }
        this.setRouteStatus("P", false);
    }

    public void markDocumentCanceled() throws InvalidActionTakenException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " marked canceled"));
        }
        this.setRouteStatus("X", true);
    }

    public void markDocumentRecalled() throws InvalidActionTakenException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " marked recalled"));
        }
        this.setRouteStatus(DocumentStatus.RECALLED.getCode(), true);
    }

    public void markDocumentDisapproved() throws InvalidActionTakenException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " marked disapproved"));
        }
        this.setRouteStatus("D", true);
    }

    public void markDocumentSaved() throws InvalidActionTakenException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " marked saved"));
        }
        this.setRouteStatus("S", false);
    }

    public void markDocumentInException() throws InvalidActionTakenException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " marked in exception"));
        }
        this.setRouteStatus("E", false);
    }

    public void markDocumentEnroute() throws InvalidActionTakenException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " marked enroute"));
        }
        this.setRouteStatus("R", false);
    }

    public void markDocumentFinalized() throws InvalidActionTakenException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " marked finalized"));
        }
        this.setRouteStatus("F", true);
    }

    public void setRouteHeaderData(Document routeHeaderVO) throws WorkflowException {
        if (!ObjectUtils.equals((Object)this.getDocTitle(), (Object)routeHeaderVO.getTitle())) {
            KEWServiceLocator.getActionListService().updateActionItemsForTitleChange(this.getDocumentId(), routeHeaderVO.getTitle());
        }
        this.setDocTitle(routeHeaderVO.getTitle());
        this.setAppDocId(routeHeaderVO.getApplicationDocumentId());
        this.setDateModified(new Timestamp(System.currentTimeMillis()));
        this.updateAppDocStatus(routeHeaderVO.getApplicationDocumentStatus());
        for (Map.Entry kvp : routeHeaderVO.getVariables().entrySet()) {
            this.setVariable((String)kvp.getKey(), (String)kvp.getValue());
        }
    }

    public void applyDocumentUpdate(DocumentUpdate documentUpdate) {
        if (documentUpdate != null) {
            String updateDocTitle;
            String thisDocTitle = this.getDocTitle() == null ? TERMINAL : this.getDocTitle();
            String string = updateDocTitle = documentUpdate.getTitle() == null ? TERMINAL : documentUpdate.getTitle();
            if (!StringUtils.equals((String)thisDocTitle, (String)updateDocTitle)) {
                KEWServiceLocator.getActionListService().updateActionItemsForTitleChange(this.getDocumentId(), documentUpdate.getTitle());
            }
            this.setDocTitle(updateDocTitle);
            this.setAppDocId(documentUpdate.getApplicationDocumentId());
            this.setDateModified(new Timestamp(System.currentTimeMillis()));
            this.updateAppDocStatus(documentUpdate.getApplicationDocumentStatus());
            List dirtyFields = documentUpdate.getDirtyFields();
            LOG.debug((Object)("Applying document update for document " + this.getDocumentId() + " dirtyFields = " + dirtyFields));
            if (dirtyFields == null || dirtyFields.contains("title")) {
                this.setDocTitle(updateDocTitle);
            }
            if (dirtyFields == null || dirtyFields.contains("applicationDocumentId")) {
                this.setAppDocId(documentUpdate.getApplicationDocumentId());
            }
            this.setDateModified(new Timestamp(System.currentTimeMillis()));
            if (dirtyFields == null || dirtyFields.contains("applicationDocumentStatus")) {
                this.updateAppDocStatus(documentUpdate.getApplicationDocumentStatus());
            }
            Map variables = documentUpdate.getVariables();
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, (String)variables.get(variableName));
            }
        }
    }

    public Branch getRootBranch() {
        if (!this._persistence_get_initialRouteNodeInstances().isEmpty()) {
            return this.getInitialRouteNodeInstance(0).getBranch();
        }
        return null;
    }

    private BranchState findVariable(String name) {
        Branch rootBranch = this.getRootBranch();
        if (rootBranch != null) {
            List<BranchState> branchState = rootBranch.getBranchState();
            for (BranchState state : branchState) {
                if (!ObjectUtils.equals((Object)state.getKey(), (Object)("var::" + name))) continue;
                return state;
            }
        }
        return null;
    }

    public String getVariable(String name) {
        BranchState state = this.findVariable(name);
        if (state == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Variable not found: '" + name + "'"));
            }
            return null;
        }
        return state.getValue();
    }

    public void removeVariableThatContains(String name) {
        ArrayList<BranchState> statesToRemove = new ArrayList<BranchState>();
        for (BranchState state : this.getRootBranchState()) {
            if (!state.getKey().contains(name)) continue;
            statesToRemove.add(state);
        }
        this.getRootBranchState().removeAll(statesToRemove);
    }

    public void setVariable(String name, String value) {
        BranchState state = this.findVariable(name);
        Branch rootBranch = this.getRootBranch();
        if (rootBranch != null) {
            List<BranchState> branchState = rootBranch.getBranchState();
            if (state == null) {
                if (value == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("set non existent variable '" + name + "' to null value"));
                    }
                    return;
                }
                LOG.debug((Object)("Adding branch state: '" + name + "'='" + value + "'"));
                state = new BranchState();
                state.setBranch(rootBranch);
                state.setKey("var::" + name);
                state.setValue(value);
                rootBranch.addBranchState(state);
            } else if (value == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removing value: " + state.getKey() + "=" + state.getValue()));
                }
                branchState.remove((Object)state);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting value of variable '" + name + "' to '" + value + "'"));
                }
                state.setValue(value);
            }
        }
    }

    public List<BranchState> getRootBranchState() {
        if (this.getRootBranch() != null) {
            return this.getRootBranch().getBranchState();
        }
        return null;
    }

    public CustomActionListAttribute getCustomActionListAttribute() throws WorkflowException {
        CustomActionListAttribute customActionListAttribute = null;
        if (this.getDocumentType() != null && (customActionListAttribute = this.getDocumentType().getCustomActionListAttribute()) != null) {
            return customActionListAttribute;
        }
        customActionListAttribute = new DefaultCustomActionListAttribute();
        return customActionListAttribute;
    }

    public CustomEmailAttribute getCustomEmailAttribute() throws WorkflowException {
        CustomEmailAttribute customEmailAttribute = null;
        try {
            if (this.getDocumentType() != null && (customEmailAttribute = this.getDocumentType().getCustomEmailAttribute()) != null) {
                customEmailAttribute.setRouteHeaderVO(DocumentRouteHeaderValue.to(this));
                return customEmailAttribute;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error in retrieving custom email attribute", (Throwable)e);
        }
        customEmailAttribute = new CustomEmailAttributeImpl();
        customEmailAttribute.setRouteHeaderVO(DocumentRouteHeaderValue.to(this));
        return customEmailAttribute;
    }

    public CustomNoteAttribute getCustomNoteAttribute() throws WorkflowException {
        CustomNoteAttribute customNoteAttribute = null;
        try {
            if (this.getDocumentType() != null && (customNoteAttribute = this.getDocumentType().getCustomNoteAttribute()) != null) {
                customNoteAttribute.setRouteHeaderVO(DocumentRouteHeaderValue.to(this));
                return customNoteAttribute;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error in retrieving custom note attribute", (Throwable)e);
        }
        customNoteAttribute = new CustomNoteAttributeImpl();
        customNoteAttribute.setRouteHeaderVO(DocumentRouteHeaderValue.to(this));
        return customNoteAttribute;
    }

    public ActionRequestValue getDocActionRequest(int index) {
        List<ActionRequestValue> actionRequests = this.getActionRequests();
        while (actionRequests.size() <= index) {
            ActionRequestValue actionRequest = new ActionRequestFactory(this).createBlankActionRequest();
            actionRequest.setNodeInstance(new RouteNodeInstance());
            actionRequests.add(actionRequest);
        }
        return actionRequests.get(index);
    }

    public ActionTakenValue getDocActionTaken(int index) {
        List<ActionTakenValue> actionsTaken = this.getActionsTaken();
        while (actionsTaken.size() <= index) {
            actionsTaken.add(new ActionTakenValue());
        }
        return actionsTaken.get(index);
    }

    public ActionItem getDocActionItem(int index) {
        List<ActionItem> actionItems = this.getActionItems();
        while (actionItems.size() <= index) {
            actionItems.add(new ActionItem());
        }
        return actionItems.get(index);
    }

    private RouteNodeInstance getInitialRouteNodeInstance(int index) {
        if (this._persistence_get_initialRouteNodeInstances().size() >= index) {
            return (RouteNodeInstance)this._persistence_get_initialRouteNodeInstances().get(index);
        }
        return null;
    }

    public boolean isRoutingReport() {
        return this.routingReport;
    }

    public void setRoutingReport(boolean routingReport) {
        this.routingReport = routingReport;
    }

    public List<RouteNodeInstance> getInitialRouteNodeInstances() {
        return this._persistence_get_initialRouteNodeInstances();
    }

    public void setInitialRouteNodeInstances(List<RouteNodeInstance> initialRouteNodeInstances) {
        this._persistence_set_initialRouteNodeInstances(initialRouteNodeInstances);
    }

    public List<Note> getNotes() {
        return this._persistence_get_notes();
    }

    public void setNotes(List<Note> notes) {
        this._persistence_set_notes(notes);
    }

    public DocumentRouteHeaderValueContent getDocumentContent() {
        if (this.documentContent == null) {
            this.documentContent = KEWServiceLocator.getRouteHeaderService().getContent(this.getDocumentId());
        }
        return this.documentContent;
    }

    public void setDocumentContent(DocumentRouteHeaderValueContent documentContent) {
        this.documentContent = documentContent;
    }

    public List<DocumentStatusTransition> getAppDocStatusHistory() {
        return this._persistence_get_appDocStatusHistory();
    }

    public void setAppDocStatusHistory(List<DocumentStatusTransition> appDocStatusHistory) {
        this._persistence_set_appDocStatusHistory(appDocStatusHistory);
    }

    @Override
    public DocumentStatus getStatus() {
        return DocumentStatus.fromCode((String)this.getDocRouteStatus());
    }

    @Override
    public DateTime getDateCreated() {
        if (this.getCreateDate() == null) {
            return null;
        }
        return new DateTime(this.getCreateDate().getTime());
    }

    public DateTime getDateLastModified() {
        if (this.getDateModified() == null) {
            return null;
        }
        return new DateTime(this.getDateModified().getTime());
    }

    public DateTime getDateApproved() {
        if (this.getApprovedDate() == null) {
            return null;
        }
        return new DateTime(this.getApprovedDate().getTime());
    }

    public DateTime getDateFinalized() {
        if (this.getFinalizedDate() == null) {
            return null;
        }
        return new DateTime(this.getFinalizedDate().getTime());
    }

    @Override
    public String getTitle() {
        return this._persistence_get_docTitle();
    }

    @Override
    public String getApplicationDocumentId() {
        return this._persistence_get_appDocId();
    }

    @Override
    public String getInitiatorPrincipalId() {
        return this._persistence_get_initiatorWorkflowId();
    }

    public String getRoutedByPrincipalId() {
        return this._persistence_get_routedByUserWorkflowId();
    }

    @Override
    public String getDocumentTypeName() {
        return this.getDocumentType().getName();
    }

    public String getDocumentHandlerUrl() {
        return this.getDocumentType().getResolvedDocumentHandlerUrl();
    }

    @Override
    public String getApplicationDocumentStatus() {
        return this._persistence_get_appDocStatus();
    }

    public DateTime getApplicationDocumentStatusDate() {
        if (this._persistence_get_appDocStatusDate() == null) {
            return null;
        }
        return new DateTime(this._persistence_get_appDocStatusDate().getTime());
    }

    public Map<String, String> getVariables() {
        HashMap<String, String> documentVariables = new HashMap<String, String>();
        Branch routeNodeInstanceBranch = this.getRootBranch();
        if (routeNodeInstanceBranch != null) {
            List<BranchState> listOfBranchStates = routeNodeInstanceBranch.getBranchState();
            for (BranchState bs : listOfBranchStates) {
                if (bs.getKey() == null || !bs.getKey().startsWith("var::")) continue;
                if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting branch state variable on vo: " + bs.getKey() + "=" + bs.getValue()));
                }
                documentVariables.put(bs.getKey().substring("var::".length()), bs.getValue());
            }
        }
        return documentVariables;
    }

    public static Document to(DocumentRouteHeaderValue documentBo) {
        if (documentBo == null) {
            return null;
        }
        Document.Builder builder = Document.Builder.create((DocumentContract)documentBo);
        return builder.build();
    }

    public static DocumentRouteHeaderValue from(Document document) {
        Map variables;
        DocumentRouteHeaderValue documentBo = new DocumentRouteHeaderValue();
        documentBo.setAppDocId(document.getApplicationDocumentId());
        if (document.getDateApproved() != null) {
            documentBo.setApprovedDate(new Timestamp(document.getDateApproved().getMillis()));
        }
        if (document.getDateCreated() != null) {
            documentBo.setCreateDate(new Timestamp(document.getDateCreated().getMillis()));
        }
        if (StringUtils.isEmpty((String)documentBo.getDocContent())) {
            documentBo.setDocContent("<documentContent/>");
        }
        documentBo.setDocRouteStatus(document.getStatus().getCode());
        documentBo.setDocTitle(document.getTitle());
        if (document.getDocumentTypeName() != null) {
            DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(document.getDocumentTypeName());
            if (documentType == null) {
                throw new RiceRuntimeException("Could not locate the given document type name: " + document.getDocumentTypeName());
            }
            documentBo.setDocumentTypeId(documentType.getDocumentTypeId());
        }
        if (document.getDateFinalized() != null) {
            documentBo.setFinalizedDate(new Timestamp(document.getDateFinalized().getMillis()));
        }
        documentBo.setInitiatorWorkflowId(document.getInitiatorPrincipalId());
        documentBo.setRoutedByUserWorkflowId(document.getRoutedByPrincipalId());
        documentBo.setDocumentId(document.getDocumentId());
        if (document.getDateLastModified() != null) {
            documentBo.setDateModified(new Timestamp(document.getDateLastModified().getMillis()));
        }
        documentBo.setAppDocStatus(document.getApplicationDocumentStatus());
        if (document.getApplicationDocumentStatusDate() != null) {
            documentBo.setAppDocStatusDate(new Timestamp(document.getApplicationDocumentStatusDate().getMillis()));
        }
        if ((variables = document.getVariables()) != null && !variables.isEmpty()) {
            for (Map.Entry kvp : variables.entrySet()) {
                documentBo.setVariable((String)kvp.getKey(), (String)kvp.getValue());
            }
        }
        return documentBo;
    }

    public void refresh() {
    }

    public DocumentRouteHeaderValue deepCopy(Map<Object, Object> visited) {
        ArrayList<RouteNodeInstance> copies;
        if (visited.containsKey(this)) {
            return (DocumentRouteHeaderValue)visited.get(this);
        }
        DocumentRouteHeaderValue copy = new DocumentRouteHeaderValue();
        visited.put(this, copy);
        copy._persistence_set_documentId(this._persistence_get_documentId());
        copy._persistence_set_documentTypeId(this._persistence_get_documentTypeId());
        copy._persistence_set_docRouteStatus(this._persistence_get_docRouteStatus());
        copy._persistence_set_docRouteLevel(this._persistence_get_docRouteLevel());
        copy._persistence_set_dateModified(this.copyTimestamp(this._persistence_get_dateModified()));
        copy._persistence_set_createDate(this.copyTimestamp(this._persistence_get_createDate()));
        copy._persistence_set_approvedDate(this.copyTimestamp(this._persistence_get_approvedDate()));
        copy._persistence_set_finalizedDate(this.copyTimestamp(this._persistence_get_finalizedDate()));
        copy._persistence_set_docTitle(this._persistence_get_docTitle());
        copy._persistence_set_appDocId(this._persistence_get_appDocId());
        copy._persistence_set_docVersion(this._persistence_get_docVersion());
        copy._persistence_set_initiatorWorkflowId(this._persistence_get_initiatorWorkflowId());
        copy._persistence_set_routedByUserWorkflowId(this._persistence_get_routedByUserWorkflowId());
        copy._persistence_set_routeStatusDate(this.copyTimestamp(this._persistence_get_routeStatusDate()));
        copy._persistence_set_appDocStatus(this._persistence_get_appDocStatus());
        copy._persistence_set_appDocStatusDate(this.copyTimestamp(this._persistence_get_appDocStatusDate()));
        if (this.documentContent != null) {
            copy.documentContent = this.documentContent.deepCopy(visited);
        }
        copy.routingReport = this.routingReport;
        if (this._persistence_get_initialRouteNodeInstances() != null) {
            copies = new ArrayList<RouteNodeInstance>();
            for (RouteNodeInstance routeNodeInstance : this._persistence_get_initialRouteNodeInstances()) {
                copies.add(routeNodeInstance.deepCopy(visited));
            }
            copy.setInitialRouteNodeInstances(copies);
        }
        if (this._persistence_get_appDocStatusHistory() != null) {
            copies = new ArrayList();
            for (DocumentStatusTransition documentStatusTransition : this._persistence_get_appDocStatusHistory()) {
                copies.add((RouteNodeInstance)((Object)documentStatusTransition.deepCopy(visited)));
            }
            copy.setAppDocStatusHistory(copies);
        }
        if (this._persistence_get_notes() != null) {
            copies = new ArrayList();
            for (Note note : this._persistence_get_notes()) {
                copies.add((RouteNodeInstance)((Object)note.deepCopy(visited)));
            }
            copy.setNotes(copies);
        }
        return copy;
    }

    private Timestamp copyTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Timestamp(timestamp.getTime());
    }

    static {
        stateTransitionMap = new HashMap();
        stateTransitionMap.put("I", "SRX");
        stateTransitionMap.put("S", "SRXP");
        stateTransitionMap.put("R", "DXPES" + DocumentStatus.RECALLED.getCode());
        stateTransitionMap.put("D", TERMINAL);
        stateTransitionMap.put("X", TERMINAL);
        stateTransitionMap.put("F", TERMINAL);
        stateTransitionMap.put(DocumentStatus.RECALLED.getCode(), TERMINAL);
        stateTransitionMap.put("E", "ERXPDS");
        stateTransitionMap.put("P", "FP");
        legalActions = new HashMap();
        legalActions.put("I", "FKSCOXHVBM");
        legalActions.put("S", "FKSCOAXHVBM");
        legalActions.put("R", "AKFHVBXCDacdrZzM" + ActionType.RECALL.getCode());
        legalActions.put("E", "FKHVABXCDacdrZzM");
        legalActions.put("F", "FKV");
        legalActions.put("X", "FKV");
        legalActions.put("D", "FKV");
        legalActions.put("P", "FKV");
        legalActions.put(DocumentStatus.RECALLED.getCode(), TERMINAL);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DocumentRouteHeaderValue();
    }

    public Object _persistence_get(String string) {
        if (string == "appDocStatusHistory") {
            return this.appDocStatusHistory;
        }
        if (string == "finalizedDate") {
            return this.finalizedDate;
        }
        if (string == "appDocStatus") {
            return this.appDocStatus;
        }
        if (string == "notes") {
            return this.notes;
        }
        if (string == "routeStatusDate") {
            return this.routeStatusDate;
        }
        if (string == "documentTypeId") {
            return this.documentTypeId;
        }
        if (string == "docTitle") {
            return this.docTitle;
        }
        if (string == "dateModified") {
            return this.dateModified;
        }
        if (string == "appDocId") {
            return this.appDocId;
        }
        if (string == "approvedDate") {
            return this.approvedDate;
        }
        if (string == "appDocStatusDate") {
            return this.appDocStatusDate;
        }
        if (string == "initialRouteNodeInstances") {
            return this.initialRouteNodeInstances;
        }
        if (string == "docRouteStatus") {
            return this.docRouteStatus;
        }
        if (string == "initiatorWorkflowId") {
            return this.initiatorWorkflowId;
        }
        if (string == "documentId") {
            return this.documentId;
        }
        if (string == "docRouteLevel") {
            return this.docRouteLevel;
        }
        if (string == "docVersion") {
            return this.docVersion;
        }
        if (string == "createDate") {
            return this.createDate;
        }
        if (string == "routedByUserWorkflowId") {
            return this.routedByUserWorkflowId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "appDocStatusHistory") {
            this.appDocStatusHistory = (List)object;
            return;
        }
        if (string == "finalizedDate") {
            this.finalizedDate = (Timestamp)object;
            return;
        }
        if (string == "appDocStatus") {
            this.appDocStatus = (String)object;
            return;
        }
        if (string == "notes") {
            this.notes = (List)object;
            return;
        }
        if (string == "routeStatusDate") {
            this.routeStatusDate = (Timestamp)object;
            return;
        }
        if (string == "documentTypeId") {
            this.documentTypeId = (String)object;
            return;
        }
        if (string == "docTitle") {
            this.docTitle = (String)object;
            return;
        }
        if (string == "dateModified") {
            this.dateModified = (Timestamp)object;
            return;
        }
        if (string == "appDocId") {
            this.appDocId = (String)object;
            return;
        }
        if (string == "approvedDate") {
            this.approvedDate = (Timestamp)object;
            return;
        }
        if (string == "appDocStatusDate") {
            this.appDocStatusDate = (Timestamp)object;
            return;
        }
        if (string == "initialRouteNodeInstances") {
            this.initialRouteNodeInstances = (List)object;
            return;
        }
        if (string == "docRouteStatus") {
            this.docRouteStatus = (String)object;
            return;
        }
        if (string == "initiatorWorkflowId") {
            this.initiatorWorkflowId = (String)object;
            return;
        }
        if (string == "documentId") {
            this.documentId = (String)object;
            return;
        }
        if (string == "docRouteLevel") {
            this.docRouteLevel = (Integer)object;
            return;
        }
        if (string == "docVersion") {
            this.docVersion = (Integer)object;
            return;
        }
        if (string == "createDate") {
            this.createDate = (Timestamp)object;
            return;
        }
        if (string == "routedByUserWorkflowId") {
            this.routedByUserWorkflowId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_appDocStatusHistory() {
        this._persistence_checkFetched("appDocStatusHistory");
        return this.appDocStatusHistory;
    }

    public void _persistence_set_appDocStatusHistory(List list) {
        this._persistence_checkFetchedForSet("appDocStatusHistory");
        this._persistence_propertyChange("appDocStatusHistory", this.appDocStatusHistory, list);
        this.appDocStatusHistory = list;
    }

    public Timestamp _persistence_get_finalizedDate() {
        this._persistence_checkFetched("finalizedDate");
        return this.finalizedDate;
    }

    public void _persistence_set_finalizedDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("finalizedDate");
        this._persistence_propertyChange("finalizedDate", this.finalizedDate, timestamp);
        this.finalizedDate = timestamp;
    }

    public String _persistence_get_appDocStatus() {
        this._persistence_checkFetched("appDocStatus");
        return this.appDocStatus;
    }

    public void _persistence_set_appDocStatus(String string) {
        this._persistence_checkFetchedForSet("appDocStatus");
        this._persistence_propertyChange("appDocStatus", this.appDocStatus, string);
        this.appDocStatus = string;
    }

    public List _persistence_get_notes() {
        this._persistence_checkFetched("notes");
        return this.notes;
    }

    public void _persistence_set_notes(List list) {
        this._persistence_checkFetchedForSet("notes");
        this._persistence_propertyChange("notes", this.notes, list);
        this.notes = list;
    }

    public Timestamp _persistence_get_routeStatusDate() {
        this._persistence_checkFetched("routeStatusDate");
        return this.routeStatusDate;
    }

    public void _persistence_set_routeStatusDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("routeStatusDate");
        this._persistence_propertyChange("routeStatusDate", this.routeStatusDate, timestamp);
        this.routeStatusDate = timestamp;
    }

    public String _persistence_get_documentTypeId() {
        this._persistence_checkFetched("documentTypeId");
        return this.documentTypeId;
    }

    public void _persistence_set_documentTypeId(String string) {
        this._persistence_checkFetchedForSet("documentTypeId");
        this._persistence_propertyChange("documentTypeId", this.documentTypeId, string);
        this.documentTypeId = string;
    }

    public String _persistence_get_docTitle() {
        this._persistence_checkFetched("docTitle");
        return this.docTitle;
    }

    public void _persistence_set_docTitle(String string) {
        this._persistence_checkFetchedForSet("docTitle");
        this._persistence_propertyChange("docTitle", this.docTitle, string);
        this.docTitle = string;
    }

    public Timestamp _persistence_get_dateModified() {
        this._persistence_checkFetched("dateModified");
        return this.dateModified;
    }

    public void _persistence_set_dateModified(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("dateModified");
        this._persistence_propertyChange("dateModified", this.dateModified, timestamp);
        this.dateModified = timestamp;
    }

    public String _persistence_get_appDocId() {
        this._persistence_checkFetched("appDocId");
        return this.appDocId;
    }

    public void _persistence_set_appDocId(String string) {
        this._persistence_checkFetchedForSet("appDocId");
        this._persistence_propertyChange("appDocId", this.appDocId, string);
        this.appDocId = string;
    }

    public Timestamp _persistence_get_approvedDate() {
        this._persistence_checkFetched("approvedDate");
        return this.approvedDate;
    }

    public void _persistence_set_approvedDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("approvedDate");
        this._persistence_propertyChange("approvedDate", this.approvedDate, timestamp);
        this.approvedDate = timestamp;
    }

    public Timestamp _persistence_get_appDocStatusDate() {
        this._persistence_checkFetched("appDocStatusDate");
        return this.appDocStatusDate;
    }

    public void _persistence_set_appDocStatusDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("appDocStatusDate");
        this._persistence_propertyChange("appDocStatusDate", this.appDocStatusDate, timestamp);
        this.appDocStatusDate = timestamp;
    }

    public List _persistence_get_initialRouteNodeInstances() {
        this._persistence_checkFetched("initialRouteNodeInstances");
        return this.initialRouteNodeInstances;
    }

    public void _persistence_set_initialRouteNodeInstances(List list) {
        this._persistence_checkFetchedForSet("initialRouteNodeInstances");
        this._persistence_propertyChange("initialRouteNodeInstances", this.initialRouteNodeInstances, list);
        this.initialRouteNodeInstances = list;
    }

    public String _persistence_get_docRouteStatus() {
        this._persistence_checkFetched("docRouteStatus");
        return this.docRouteStatus;
    }

    public void _persistence_set_docRouteStatus(String string) {
        this._persistence_checkFetchedForSet("docRouteStatus");
        this._persistence_propertyChange("docRouteStatus", this.docRouteStatus, string);
        this.docRouteStatus = string;
    }

    public String _persistence_get_initiatorWorkflowId() {
        this._persistence_checkFetched("initiatorWorkflowId");
        return this.initiatorWorkflowId;
    }

    public void _persistence_set_initiatorWorkflowId(String string) {
        this._persistence_checkFetchedForSet("initiatorWorkflowId");
        this._persistence_propertyChange("initiatorWorkflowId", this.initiatorWorkflowId, string);
        this.initiatorWorkflowId = string;
    }

    public String _persistence_get_documentId() {
        this._persistence_checkFetched("documentId");
        return this.documentId;
    }

    public void _persistence_set_documentId(String string) {
        this._persistence_checkFetchedForSet("documentId");
        this._persistence_propertyChange("documentId", this.documentId, string);
        this.documentId = string;
    }

    public Integer _persistence_get_docRouteLevel() {
        this._persistence_checkFetched("docRouteLevel");
        return this.docRouteLevel;
    }

    public void _persistence_set_docRouteLevel(Integer n) {
        this._persistence_checkFetchedForSet("docRouteLevel");
        this._persistence_propertyChange("docRouteLevel", this.docRouteLevel, n);
        this.docRouteLevel = n;
    }

    public Integer _persistence_get_docVersion() {
        this._persistence_checkFetched("docVersion");
        return this.docVersion;
    }

    public void _persistence_set_docVersion(Integer n) {
        this._persistence_checkFetchedForSet("docVersion");
        this._persistence_propertyChange("docVersion", this.docVersion, n);
        this.docVersion = n;
    }

    public Timestamp _persistence_get_createDate() {
        this._persistence_checkFetched("createDate");
        return this.createDate;
    }

    public void _persistence_set_createDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("createDate");
        this._persistence_propertyChange("createDate", this.createDate, timestamp);
        this.createDate = timestamp;
    }

    public String _persistence_get_routedByUserWorkflowId() {
        this._persistence_checkFetched("routedByUserWorkflowId");
        return this.routedByUserWorkflowId;
    }

    public void _persistence_set_routedByUserWorkflowId(String string) {
        this._persistence_checkFetchedForSet("routedByUserWorkflowId");
        this._persistence_propertyChange("routedByUserWorkflowId", this.routedByUserWorkflowId, string);
        this.routedByUserWorkflowId = string;
    }
}

