/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatusCategory;
import org.kuali.rice.kew.doctype.DocumentTypeAttributeBo;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.BranchPrototype;
import org.kuali.rice.kew.engine.node.NodeType;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;

public class DocumentTypeXmlExporter
implements XmlExporter {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private XmlRenderer renderer = new XmlRenderer(XmlConstants.DOCUMENT_TYPE_NAMESPACE);

    public boolean supportPrettyPrint() {
        return true;
    }

    public Element export(ExportDataSet exportDataSet) {
        KewExportDataSet dataSet = KewExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getDocumentTypes().isEmpty()) {
            Collections.sort(dataSet.getDocumentTypes(), new DocumentTypeParentComparator());
            Element rootElement = this.renderer.renderElement(null, "documentTypes");
            rootElement.setAttribute("schemaLocation", "ns:workflow/DocumentType resource:DocumentType", XmlConstants.SCHEMA_NAMESPACE);
            for (DocumentType documentType : dataSet.getDocumentTypes()) {
                this.exportDocumentType(rootElement, documentType);
            }
            return rootElement;
        }
        return null;
    }

    private void exportDocumentType(Element parent, DocumentType documentType) {
        Group exceptionWorkgroup;
        Group reportingWorkgroup;
        Group blanketWorkgroup;
        Element docTypeElement = this.renderer.renderElement(parent, "documentType");
        List<RouteNode> flattenedNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(documentType, false);
        boolean hasDefaultExceptionWorkgroup = this.hasDefaultExceptionWorkgroup(flattenedNodes);
        this.renderer.renderTextElement(docTypeElement, "name", documentType.getName());
        if (documentType.getParentDocType() != null) {
            this.renderer.renderTextElement(docTypeElement, "parent", documentType.getParentDocType().getName());
        }
        this.renderer.renderTextElement(docTypeElement, "description", documentType.getDescription());
        this.renderer.renderTextElement(docTypeElement, "label", documentType.getLabel());
        if (!StringUtils.isBlank((String)documentType.getActualApplicationId())) {
            this.renderer.renderTextElement(docTypeElement, "applicationId", documentType.getActualApplicationId());
        }
        this.renderer.renderTextElement(docTypeElement, "postProcessorName", documentType.getPostProcessorName());
        this.renderer.renderTextElement(docTypeElement, "authorizer", documentType.getAuthorizer());
        Group superUserWorkgroup = documentType.getSuperUserWorkgroupNoInheritence();
        if (superUserWorkgroup != null) {
            Element superUserGroupElement = this.renderer.renderTextElement(docTypeElement, "superUserGroupName", superUserWorkgroup.getName().trim());
            superUserGroupElement.setAttribute("namespace", superUserWorkgroup.getNamespaceCode().trim());
        }
        if ((blanketWorkgroup = documentType.getBlanketApproveWorkgroup()) != null) {
            Element blanketGroupElement = this.renderer.renderTextElement(docTypeElement, "blanketApproveGroupName", blanketWorkgroup.getName().trim());
            blanketGroupElement.setAttribute("namespace", blanketWorkgroup.getNamespaceCode().trim());
        }
        if (documentType.getBlanketApprovePolicy() != null) {
            this.renderer.renderTextElement(docTypeElement, "blanketApprovePolicy", documentType.getBlanketApprovePolicy());
        }
        if ((reportingWorkgroup = documentType.getReportingWorkgroup()) != null) {
            Element reportingGroupElement = this.renderer.renderTextElement(docTypeElement, "reportingGroupName", reportingWorkgroup.getName().trim());
            reportingGroupElement.setAttribute("namespace", reportingWorkgroup.getNamespaceCode().trim());
        }
        if (!flattenedNodes.isEmpty() && hasDefaultExceptionWorkgroup && (exceptionWorkgroup = flattenedNodes.get(0).getExceptionWorkgroup()) != null) {
            Element exceptionGroupElement = this.renderer.renderTextElement(docTypeElement, "defaultExceptionGroupName", exceptionWorkgroup.getName().trim());
            exceptionGroupElement.setAttribute("namespace", exceptionWorkgroup.getNamespaceCode().trim());
        }
        if (StringUtils.isNotBlank((String)documentType.getUnresolvedDocHandlerUrl())) {
            this.renderer.renderTextElement(docTypeElement, "docHandler", documentType.getUnresolvedDocHandlerUrl());
        }
        if (!StringUtils.isBlank((String)documentType.getUnresolvedHelpDefinitionUrl())) {
            this.renderer.renderTextElement(docTypeElement, "helpDefinitionURL", documentType.getUnresolvedHelpDefinitionUrl());
        }
        if (!StringUtils.isBlank((String)documentType.getUnresolvedDocSearchHelpUrl())) {
            this.renderer.renderTextElement(docTypeElement, "docSearchHelpURL", documentType.getUnresolvedDocSearchHelpUrl());
        }
        if (!StringUtils.isBlank((String)documentType.getActualNotificationFromAddress())) {
            this.renderer.renderTextElement(docTypeElement, "notificationFromAddress", documentType.getActualNotificationFromAddress());
        }
        this.renderer.renderBooleanElement(docTypeElement, "active", documentType.getActive(), true);
        this.exportApplicationStatuses(docTypeElement, documentType);
        this.exportPolicies(docTypeElement, documentType.getDocumentTypePolicies());
        this.exportAttributes(docTypeElement, documentType.getDocumentTypeAttributes());
        this.exportSecurity(docTypeElement, documentType.getDocumentTypeSecurityXml());
        if (!StringUtils.isBlank((String)documentType.getRoutingVersion())) {
            this.renderer.renderTextElement(docTypeElement, "routingVersion", documentType.getRoutingVersion());
        }
        ProcessDefinitionBo process = null;
        if (documentType.getProcesses().size() > 0) {
            process = (ProcessDefinitionBo)documentType.getProcesses().get(0);
        }
        if (process != null && process.getInitialRouteNode() != null) {
            this.exportRouteData(docTypeElement, documentType, flattenedNodes, hasDefaultExceptionWorkgroup);
        } else {
            this.renderer.renderElement(docTypeElement, "routePaths");
        }
    }

    private void exportApplicationStatuses(Element parent, DocumentType documentType) {
        block5: {
            List<ApplicationDocumentStatus> appDocStats;
            block4: {
                List<ApplicationDocumentStatusCategory> appDocStatCategories = documentType.getApplicationStatusCategories();
                appDocStats = documentType.getValidApplicationStatuses();
                if (appDocStatCategories == null || appDocStatCategories.isEmpty()) break block4;
                Element appDocStatCategoriesElement = this.renderer.renderElement(parent, "validApplicationStatuses");
                for (ApplicationDocumentStatusCategory appDocStatCategory : appDocStatCategories) {
                    Element appStatusCatElement = this.renderer.renderElement(appDocStatCategoriesElement, "category");
                    appStatusCatElement.setAttribute("name", appDocStatCategory.getCategoryName().trim());
                    if (appDocStats == null) continue;
                    for (ApplicationDocumentStatus appDocStat : appDocStats) {
                        if (!StringUtils.equals((String)appDocStat.getCategoryName(), (String)appDocStatCategory.getCategoryName())) continue;
                        this.renderer.renderTextElement(appStatusCatElement, "status", appDocStat.getStatusName());
                    }
                }
                for (ApplicationDocumentStatus appDocStat : appDocStats) {
                    if (!StringUtils.isEmpty((String)appDocStat.getCategoryName())) continue;
                    this.renderer.renderTextElement(appDocStatCategoriesElement, "status", appDocStat.getStatusName());
                }
                break block5;
            }
            if (appDocStats.isEmpty()) break block5;
            Element validApplicationStatusesElement = this.renderer.renderElement(parent, "validApplicationStatuses");
            for (ApplicationDocumentStatus appDocStat : appDocStats) {
                this.renderer.renderTextElement(validApplicationStatusesElement, "status", appDocStat.getStatusName());
            }
        }
    }

    private void exportPolicies(Element parent, Collection policies) {
        if (!policies.isEmpty()) {
            Element policiesElement = this.renderer.renderElement(parent, "policies");
            for (DocumentTypePolicy policy : policies) {
                Element policyElement = this.renderer.renderElement(policiesElement, "policy");
                this.renderer.renderTextElement(policyElement, "name", policy.getPolicyName());
                if (StringUtils.isNotEmpty((String)policy.getPolicyStringValue())) {
                    this.renderer.renderTextElement(policyElement, "stringValue", policy.getPolicyStringValue());
                    continue;
                }
                this.renderer.renderBooleanElement(policyElement, "value", policy.getPolicyValue(), false);
            }
        }
    }

    private void exportAttributes(Element parent, List attributes) {
        if (!attributes.isEmpty()) {
            Element attributesElement = this.renderer.renderElement(parent, "attributes");
            for (DocumentTypeAttributeBo attribute : attributes) {
                Element attributeElement = this.renderer.renderElement(attributesElement, "attribute");
                this.renderer.renderTextElement(attributeElement, "name", attribute.getRuleAttribute().getName());
            }
        }
    }

    private void exportSecurity(Element parent, String securityXML) {
        if (!StringUtils.isEmpty((String)securityXML)) {
            try {
                Document securityDoc = new SAXBuilder().build((Reader)new StringReader(securityXML));
                XmlHelper.propagateNamespace((Element)securityDoc.getRootElement(), (Namespace)XmlConstants.DOCUMENT_TYPE_NAMESPACE);
                parent.addContent(securityDoc.getRootElement().detach());
            }
            catch (IOException e) {
                throw new WorkflowRuntimeException("Error parsing doctype security XML.");
            }
            catch (JDOMException e) {
                throw new WorkflowRuntimeException("Error parsing doctype security XML.");
            }
        }
    }

    private void exportRouteData(Element parent, DocumentType documentType, List flattenedNodes, boolean hasDefaultExceptionWorkgroup) {
        if (!flattenedNodes.isEmpty()) {
            Element routePathsElement = this.renderer.renderElement(parent, "routePaths");
            for (ProcessDefinitionBo process : documentType.getProcesses()) {
                Element routePathElement = this.renderer.renderElement(routePathsElement, "routePath");
                if (!process.isInitial() && process.getInitialRouteNode() != null) {
                    this.renderer.renderAttribute(routePathElement, "initialNode", process.getInitialRouteNode().getRouteNodeName());
                    this.renderer.renderAttribute(routePathElement, "processName", process.getName());
                }
                this.exportProcess(routePathElement, process);
            }
            Element routeNodesElement = this.renderer.renderElement(parent, "routeNodes");
            for (RouteNode node : flattenedNodes) {
                this.exportRouteNode(routeNodesElement, node, hasDefaultExceptionWorkgroup);
            }
        }
    }

    private boolean hasDefaultExceptionWorkgroup(List flattenedNodes) {
        boolean hasDefaultExceptionWorkgroup = true;
        String exceptionWorkgroupName = null;
        for (RouteNode node : flattenedNodes) {
            if (exceptionWorkgroupName == null) {
                exceptionWorkgroupName = node.getExceptionWorkgroupName();
            }
            if (exceptionWorkgroupName != null && exceptionWorkgroupName.equals(node.getExceptionWorkgroupName())) continue;
            hasDefaultExceptionWorkgroup = false;
            break;
        }
        return hasDefaultExceptionWorkgroup;
    }

    private void exportProcess(Element parent, ProcessDefinitionBo process) {
        this.exportNodeGraph(parent, process.getInitialRouteNode(), null);
    }

    private void exportNodeGraph(Element parent, RouteNode node, SplitJoinContext splitJoinContext) {
        NodeType nodeType = null;
        if (node != null) {
            String contentFragment = node.getContentFragment();
            nodeType = contentFragment == null || "".equals(contentFragment) ? this.getNodeTypeForNode(node) : this.getNodeTypeForNodeFromFragment(node);
            if (nodeType.isAssignableFrom(NodeType.SPLIT)) {
                this.exportSplitNode(parent, node, nodeType, splitJoinContext);
            } else if (nodeType.isAssignableFrom(NodeType.JOIN)) {
                this.exportJoinNode(parent, node, nodeType, splitJoinContext);
            } else {
                this.exportSimpleNode(parent, node, nodeType, splitJoinContext);
            }
        }
    }

    private void exportSimpleNode(Element parent, RouteNode node, NodeType nodeType, SplitJoinContext splitJoinContext) {
        Element simpleElement = this.renderNodeElement(parent, node, nodeType);
        if (node.getNextNodes().size() > 1) {
            throw new WorkflowRuntimeException("Simple node cannot have more than one next node: " + node.getRouteNodeName());
        }
        if (node.getNextNodes().size() == 1) {
            RouteNode nextNode = node.getNextNodes().get(0);
            this.renderer.renderAttribute(simpleElement, "nextNode", nextNode.getRouteNodeName());
            if (node.getNextDocumentStatus() != null) {
                this.renderer.renderAttribute(simpleElement, "nextAppDocStatus", node.getNextDocumentStatus());
            }
            this.exportNodeGraph(parent, nextNode, splitJoinContext);
        }
    }

    private void exportSplitNode(Element parent, RouteNode node, NodeType nodeType, SplitJoinContext splitJoinContext) {
        Element splitElement = this.renderNodeElement(parent, node, nodeType);
        SplitJoinContext newSplitJoinContext = new SplitJoinContext(node);
        for (RouteNode nextNode : node.getNextNodes()) {
            BranchPrototype branch = nextNode.getBranch();
            if (branch == null) {
                throw new WorkflowRuntimeException("Found a split next node with no associated branch prototype: " + nextNode.getRouteNodeName());
            }
            this.exportBranch(splitElement, nextNode, branch, newSplitJoinContext);
        }
        RouteNode joinNode = newSplitJoinContext.joinNode;
        if (joinNode == null) {
            if (node.getNextNodes().size() > 0) {
                throw new WorkflowRuntimeException("Could not locate the join node for the given split node " + node.getRouteNodeName());
            }
        } else {
            this.renderNodeElement(splitElement, joinNode, newSplitJoinContext.joinNodeType);
            if (joinNode.getNextNodes().size() > 1) {
                throw new WorkflowRuntimeException("Join node cannot have more than one next node: " + joinNode.getRouteNodeName());
            }
            if (joinNode.getNextNodes().size() == 1) {
                RouteNode nextNode;
                nextNode = joinNode.getNextNodes().get(0);
                this.renderer.renderAttribute(splitElement, "nextNode", nextNode.getRouteNodeName());
                if (node.getNextDocumentStatus() != null) {
                    this.renderer.renderAttribute(splitElement, "nextAppDocStatus", node.getNextDocumentStatus());
                }
                this.exportNodeGraph(parent, nextNode, splitJoinContext);
            }
        }
    }

    private void exportBranch(Element parent, RouteNode node, BranchPrototype branch, SplitJoinContext splitJoinContext) {
        Element branchElement = this.renderer.renderElement(parent, "branch");
        this.renderer.renderAttribute(branchElement, "name", branch.getName());
        this.exportNodeGraph(branchElement, node, splitJoinContext);
    }

    private void exportJoinNode(Element parent, RouteNode node, NodeType nodeType, SplitJoinContext splitJoinContext) {
        if (splitJoinContext == null) {
            if (!node.getNextNodes().isEmpty()) {
                throw new WorkflowRuntimeException("Could not export join node with next nodes that is not contained within a split.");
            }
            this.renderNodeElement(parent, node, nodeType);
        } else if (splitJoinContext.joinNode == null) {
            splitJoinContext.joinNode = node;
            splitJoinContext.joinNodeType = nodeType;
        }
    }

    private Element renderNodeElement(Element parent, RouteNode node, NodeType nodeType) {
        String nodeName = nodeType.getName();
        if (nodeType.equals(NodeType.REQUEST_ACTIVATION)) {
            nodeName = NodeType.SIMPLE.getName();
        }
        Element nodeElement = this.renderer.renderElement(parent, nodeName);
        this.renderer.renderAttribute(nodeElement, "name", node.getRouteNodeName());
        return nodeElement;
    }

    private void exportRouteNodeOld(Element parent, RouteNode node, boolean hasDefaultExceptionWorkgroup) {
        NodeType nodeType = this.getNodeTypeForNode(node);
        Element nodeElement = this.renderer.renderElement(parent, nodeType.getName());
        this.renderer.renderAttribute(nodeElement, "name", node.getRouteNodeName());
        if (!hasDefaultExceptionWorkgroup && !StringUtils.isBlank((String)node.getExceptionWorkgroupName())) {
            Element exceptionGroupElement = this.renderer.renderTextElement(nodeElement, "exceptionGroupName", node.getExceptionWorkgroupName());
            exceptionGroupElement.setAttribute("namespace", node.getExceptionWorkgroup().getNamespaceCode());
        }
        if (this.supportsActivationType(nodeType) && !StringUtils.isBlank((String)node.getActivationType())) {
            this.renderer.renderTextElement(nodeElement, "activationType", node.getActivationType());
        }
        if (this.supportsRouteMethod(nodeType)) {
            this.exportRouteMethod(nodeElement, node);
            this.renderer.renderBooleanElement(nodeElement, "mandatoryRoute", node.getMandatoryRouteInd(), false);
            this.renderer.renderBooleanElement(nodeElement, "finalApproval", node.getFinalApprovalInd(), false);
        }
        if (nodeType.isCustomNode(node.getNodeType())) {
            this.renderer.renderTextElement(nodeElement, "type", node.getNodeType());
        }
    }

    private void exportRouteNode(Element parent, RouteNode node, boolean hasDefaultExceptionWorkgroup) {
        String contentFragment = node.getContentFragment();
        if (StringUtils.isBlank((String)contentFragment)) {
            this.exportRouteNodeOld(parent, node, hasDefaultExceptionWorkgroup);
        } else {
            try {
                Document document = XmlHelper.buildJDocument((Reader)new StringReader(contentFragment));
                Element rootElement = document.detachRootElement();
                XmlHelper.propagateNamespace((Element)rootElement, (Namespace)parent.getNamespace());
                parent.addContent((Content)rootElement);
            }
            catch (XmlException e) {
                throw new WorkflowRuntimeException("Failed to load the content fragment.", (Throwable)e);
            }
        }
    }

    private NodeType getNodeTypeForNode(RouteNode node) {
        NodeType nodeType = null;
        String errorMessage = "Could not determine proper XML element for the given node type: " + node.getNodeType();
        try {
            nodeType = NodeType.fromClassName(node.getNodeType());
        }
        catch (ResourceUnavailableException e) {
            throw new WorkflowRuntimeException(errorMessage, (Throwable)e);
        }
        if (nodeType == null) {
            throw new WorkflowRuntimeException(errorMessage);
        }
        return nodeType;
    }

    private NodeType getNodeTypeForNodeFromFragment(RouteNode node) {
        NodeType nodeType = null;
        String contentFragment = node.getContentFragment();
        String errorMessage = "Could not determine proper XML element for the given node type: " + node.getNodeType();
        for (NodeType nType : NodeType.getTypeList()) {
            if (!contentFragment.startsWith("<" + nType.getName())) continue;
            nodeType = nType;
        }
        if (nodeType == null) {
            throw new WorkflowRuntimeException(errorMessage);
        }
        return nodeType;
    }

    private boolean supportsActivationType(NodeType nodeType) {
        return true;
    }

    private boolean supportsRouteMethod(NodeType nodeType) {
        return true;
    }

    private void exportRouteMethod(Element parent, RouteNode node) {
        if (!StringUtils.isBlank((String)node.getRouteMethodName())) {
            String routeMethodCode = node.getRouteMethodCode();
            String elementName = null;
            if ("FR".equals(routeMethodCode)) {
                elementName = "ruleTemplate";
            } else if ("RM".equals(routeMethodCode)) {
                elementName = "routeModule";
            } else {
                throw new WorkflowRuntimeException("Invalid route method code '" + routeMethodCode + "' for node " + node.getRouteNodeName());
            }
            this.renderer.renderTextElement(parent, elementName, node.getRouteMethodName());
        }
    }

    private class SplitJoinContext {
        public RouteNode splitNode;
        public RouteNode joinNode;
        public NodeType joinNodeType;

        public SplitJoinContext(RouteNode splitNode) {
            this.splitNode = splitNode;
        }
    }

    private class DocumentTypeParentComparator
    implements Comparator {
        private DocumentTypeParentComparator() {
        }

        public int compare(Object object1, Object object2) {
            DocumentType docType1 = (DocumentType)object1;
            DocumentType docType2 = (DocumentType)object2;
            Integer depth1 = this.getDepth(docType1);
            Integer depth2 = this.getDepth(docType2);
            return depth1.compareTo(depth2);
        }

        private Integer getDepth(DocumentType docType) {
            int depth = 0;
            while ((docType = docType.getParentDocType()) != null) {
                ++depth;
            }
            return depth;
        }
    }
}

