/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.inquiry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.permission.PermissionAttributeBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.UberPermissionBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RolePermissionBo;
import org.kuali.rice.kim.inquiry.KimInquirableImpl;
import org.kuali.rice.kim.lookup.RoleLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.uif.widget.Inquiry;

public class PermissionInquirableImpl
extends KimInquirableImpl {
    private static final long serialVersionUID = 1L;

    public void buildInquirableLink(Object dataObject, String propertyName, Inquiry inquiry) {
        if ("name".equals(propertyName) || "nameToDisplay".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("id", "id");
            inquiry.buildInquiryLink(dataObject, propertyName, UberPermissionBo.class, primaryKeys);
        } else if ("namespaceCode".equals(propertyName) || "template.namespaceCode".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put(propertyName, "code");
            inquiry.buildInquiryLink(dataObject, propertyName, NamespaceBo.class, primaryKeys);
        } else if ("detailObjects".equals(propertyName)) {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        } else if ("assignedToRolesToDisplay".equals(propertyName)) {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        } else {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        }
    }

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if ("name".equals(attributeName) || "nameToDisplay".equals(attributeName)) {
            return this.getInquiryUrlForPrimaryKeys(UberPermissionBo.class, businessObject, Collections.singletonList("id"), null);
        }
        if ("namespaceCode".equals(attributeName) || "template.namespaceCode".equals(attributeName)) {
            NamespaceBo parameterNamespace = new NamespaceBo();
            String code = (String)KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject).getPropertyValueNullSafe(attributeName);
            parameterNamespace.setCode(code);
            return this.getInquiryUrlForPrimaryKeys(NamespaceBo.class, parameterNamespace, Collections.singletonList("code"), null);
        }
        if (!"detailObjects".equals(attributeName) && "assignedToRolesToDisplay".equals(attributeName)) {
            return this.getAssignedRoleInquiryUrl(businessObject);
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

    protected HtmlData getAttributesInquiryUrl(BusinessObject businessObject, String attributeName) {
        DataObjectWrapper wrapper = KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject);
        List permissionAttributeData = (List)wrapper.getPropertyValueNullSafe(attributeName);
        ArrayList<HtmlData.AnchorHtmlData> htmlData = new ArrayList<HtmlData.AnchorHtmlData>();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        primaryKeys.add("attributeDataId");
        for (PermissionAttributeBo permissionAttributeDataImpl : permissionAttributeData) {
            htmlData.add(this.getInquiryUrlForPrimaryKeys(PermissionAttributeBo.class, permissionAttributeDataImpl, primaryKeys, this.getKimAttributeLabelFromDD(permissionAttributeDataImpl.getKimAttribute().getAttributeName()) + " : " + permissionAttributeDataImpl.getAttributeValue()));
        }
        return new HtmlData.MultipleAnchorHtmlData(htmlData);
    }

    protected HtmlData getAssignedRoleInquiryUrl(BusinessObject businessObject) {
        UberPermissionBo permission = (UberPermissionBo)businessObject;
        List assignedToRoles = permission.getAssignedToRoles();
        ArrayList<HtmlData.AnchorHtmlData> htmlData = new ArrayList<HtmlData.AnchorHtmlData>();
        if (assignedToRoles != null && !assignedToRoles.isEmpty()) {
            RoleService roleService = KimApiServiceLocator.getRoleService();
            for (RoleBo roleImpl : assignedToRoles) {
                Role roleInfo = roleService.getRole(roleImpl.getId());
                HtmlData.AnchorHtmlData inquiryHtmlData = this.getInquiryUrlForPrimaryKeys(RoleBo.class, roleInfo, Collections.singletonList("id"), roleInfo.getNamespaceCode() + " " + roleInfo.getName());
                inquiryHtmlData.setHref(RoleLookupableHelperServiceImpl.getCustomRoleInquiryHref(inquiryHtmlData.getHref()));
                inquiryHtmlData.setTarget("_blank");
                htmlData.add(inquiryHtmlData);
            }
        }
        return new HtmlData.MultipleAnchorHtmlData(htmlData);
    }

    public Object retrieveDataObject(Map fieldValues) {
        if (fieldValues.get("id") == null) {
            return null;
        }
        PermissionBo permissionBo = (PermissionBo)this.getDataObjectService().find(PermissionBo.class, (Object)fieldValues.get("id").toString());
        return this.getPermissionsSearchResultsCopy(permissionBo);
    }

    private PermissionBo getPermissionsSearchResultsCopy(PermissionBo permissionSearchResult) {
        UberPermissionBo permissionSearchResultCopy = new UberPermissionBo();
        try {
            PropertyUtils.copyProperties((Object)permissionSearchResultCopy, (Object)permissionSearchResult);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        List rolePermissions = this.getDataObjectService().findMatching(RolePermissionBo.class, QueryByCriteria.Builder.forAttribute((String)"permissionId", (Object)permissionSearchResultCopy.getId()).build()).getResults();
        ArrayList<Object> assignedToRoles = new ArrayList<Object>();
        for (RolePermissionBo rolePermissionImpl : rolePermissions) {
            if (!rolePermissionImpl.isActive()) continue;
            assignedToRoles.add(this.getDataObjectService().find(RoleBo.class, (Object)rolePermissionImpl.getRoleId()));
        }
        permissionSearchResultCopy.setAssignedToRoles(assignedToRoles);
        return permissionSearchResultCopy;
    }
}

