/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationRecipientListBo;
import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;
import org.kuali.rice.ken.deliverer.impl.KEWActionListMessageDeliverer;
import org.kuali.rice.ken.exception.NotificationMessageDeliveryException;
import org.kuali.rice.ken.service.NotificationMessageDeliveryResolverService;
import org.kuali.rice.ken.service.NotificationRecipientService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.service.ProcessingResult;
import org.kuali.rice.ken.service.impl.ConcurrentJob;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.transaction.PlatformTransactionManager;

public class NotificationMessageDeliveryResolverServiceImpl
extends ConcurrentJob<NotificationBo>
implements NotificationMessageDeliveryResolverService {
    private static Logger LOG = LogManager.getLogger(NotificationMessageDeliveryResolverServiceImpl.class);
    private NotificationRecipientService notificationRecipientService;
    private DataObjectService dataObjectService;
    private NotificationService notificationService;

    public NotificationMessageDeliveryResolverServiceImpl(NotificationService notificationService, NotificationRecipientService notificationRecipientService, DataObjectService dataObjectService, PlatformTransactionManager txManager, ExecutorService executor) {
        super(txManager, executor);
        this.notificationService = notificationService;
        this.notificationRecipientService = notificationRecipientService;
        this.dataObjectService = dataObjectService;
    }

    @Override
    protected Collection<NotificationBo> takeAvailableWorkItems() {
        Collection<NotificationBo> nots = this.notificationService.takeNotificationsForResolution();
        return nots;
    }

    private HashSet<String> buildCompleteRecipientList(NotificationBo notification) {
        Principal principal;
        int j;
        String[] groupMembers;
        HashSet<String> completeRecipientList = new HashSet<String>(notification.getRecipients().size());
        for (int i = 0; i < notification.getRecipients().size(); ++i) {
            NotificationRecipientBo recipient = notification.getRecipient(i);
            if (KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode().equals(recipient.getRecipientType())) {
                groupMembers = this.notificationRecipientService.getGroupMembers(recipient.getRecipientId());
                for (j = 0; j < groupMembers.length; ++j) {
                    completeRecipientList.add(groupMembers[j]);
                }
                continue;
            }
            principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(recipient.getRecipientId());
            completeRecipientList.add(principal.getPrincipalId());
        }
        for (NotificationRecipientListBo listRecipient : notification.getChannel().getRecipientLists()) {
            if (KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode().equals(listRecipient.getRecipientType())) {
                groupMembers = this.notificationRecipientService.getGroupMembers(listRecipient.getRecipientId());
                for (j = 0; j < groupMembers.length; ++j) {
                    completeRecipientList.add(groupMembers[j]);
                }
                continue;
            }
            principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(listRecipient.getRecipientId());
            completeRecipientList.add(principal.getPrincipalId());
        }
        List<UserChannelSubscriptionBo> subscriptions = notification.getChannel().getSubscriptions();
        for (UserChannelSubscriptionBo subscription : subscriptions) {
            completeRecipientList.add(subscription.getUserId());
        }
        return completeRecipientList;
    }

    @Override
    protected Collection<Object> processWorkItems(Collection<NotificationBo> notifications) {
        ArrayList<Object> successes = new ArrayList<Object>();
        for (NotificationBo notification : notifications) {
            HashSet<String> uniqueRecipients = this.buildCompleteRecipientList(notification);
            for (String userRecipientId : uniqueRecipients) {
                NotificationMessageDelivery defaultMessageDelivery = new NotificationMessageDelivery();
                defaultMessageDelivery.setMessageDeliveryStatus("UNDELIVERED");
                defaultMessageDelivery.setNotification(notification);
                defaultMessageDelivery.setUserRecipientId(userRecipientId);
                defaultMessageDelivery = (NotificationMessageDelivery)this.dataObjectService.save((Object)defaultMessageDelivery, new PersistenceOption[0]);
                try {
                    new KEWActionListMessageDeliverer().deliverMessage(defaultMessageDelivery);
                }
                catch (NotificationMessageDeliveryException e) {
                    throw new RuntimeException(e);
                }
                defaultMessageDelivery.setMessageDeliveryStatus("DELIVERED");
                defaultMessageDelivery = (NotificationMessageDelivery)this.dataObjectService.save((Object)defaultMessageDelivery, new PersistenceOption[0]);
                successes.add(defaultMessageDelivery);
                notification.setProcessingFlag("RESOLVED");
                notification.setLockedDateValue(null);
                this.dataObjectService.save((Object)notification, new PersistenceOption[0]);
            }
        }
        return successes;
    }

    @Override
    protected void unlockWorkItem(NotificationBo notification) {
        LOG.debug("Unlocking notification: " + notification.getId() + " " + notification.getTitle());
        this.notificationService.unlockNotification(notification);
    }

    @Override
    public ProcessingResult resolveNotificationMessageDeliveries() {
        LOG.debug("[" + new Timestamp(System.currentTimeMillis()).toString() + "] STARTING RESOLUTION OF NOTIFICATION MESSAGE DELIVERIES");
        ProcessingResult result = this.run();
        LOG.debug("[" + new Timestamp(System.currentTimeMillis()).toString() + "] FINISHED RESOLUTION OF NOTIFICATION MESSAGE DELIVERIES - Message Delivery End Points Resolved = " + result.getSuccesses().size());
        return result;
    }
}

