/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;

public class CompoundNamespaceContext
implements NamespaceContext {
    private final List<NamespaceContext> contexts;

    public CompoundNamespaceContext(NamespaceContext first, NamespaceContext second) {
        this.contexts = new ArrayList<NamespaceContext>(2);
        this.contexts.add(first);
        this.contexts.add(second);
    }

    public CompoundNamespaceContext(List<NamespaceContext> contexts) {
        this.contexts = contexts;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("The prefix cannot be null.");
        }
        for (NamespaceContext nc : this.contexts) {
            String uri = nc.getNamespaceURI(prefix);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        for (NamespaceContext nc : this.contexts) {
            String prefix = nc.getPrefix(namespaceURI);
            if (prefix == null) continue;
            return prefix;
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        for (NamespaceContext nc : this.contexts) {
            Iterator<String> prefixes = nc.getPrefixes(namespaceURI);
            if (prefixes == null) continue;
            return prefixes;
        }
        return null;
    }
}

