/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionitem.ActionItemBase;
import org.kuali.rice.kew.actionitem.OutboxItem;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.actionlist.dao.ActionListDAO;
import org.kuali.rice.kew.actionlist.dao.impl.ActionListPriorityComparator;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.notification.service.NotificationService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsService;
import org.kuali.rice.kew.util.WebFriendlyRecipient;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class ActionListServiceImpl
implements ActionListService {
    private static final Logger LOG = LogManager.getLogger(ActionListServiceImpl.class);
    private static final Integer DEFAULT_OUTBOX_ITEM_LIMIT = 10000;
    protected DataObjectService dataObjectService;
    protected NotificationService notificationService;
    protected DateTimeService dateTimeService;
    protected ActionRequestService actionRequestService;
    protected DocumentTypeService documentTypeService;
    protected UserOptionsService userOptionsService;
    protected RouteHeaderService routeHeaderService;
    protected ActionListDAO actionListDAO;

    @Override
    public Collection<Recipient> findUserSecondaryDelegators(String principalId) {
        QueryByCriteria query = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"principalId", (Object)principalId), PredicateFactory.equal((String)"delegationType", (Object)DelegationType.SECONDARY.getCode()), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNotNull((String)"delegatorPrincipalId"), PredicateFactory.isNotNull((String)"delegatorGroupId")})});
        QueryResults results = this.dataObjectService.findMatching(ActionItem.class, query);
        HashMap<String, Recipient> delegators = new HashMap<String, Recipient>(results.getResults().size());
        for (ActionItem actionItem : results.getResults()) {
            String delegatorPrincipalId = actionItem.getDelegatorPrincipalId();
            String delegatorGroupId = actionItem.getDelegatorGroupId();
            if (delegatorPrincipalId != null && !delegators.containsKey(delegatorPrincipalId)) {
                delegators.put(delegatorPrincipalId, new WebFriendlyRecipient(KimApiServiceLocator.getPersonService().getPerson(delegatorPrincipalId)));
                continue;
            }
            if (delegatorGroupId == null || delegators.containsKey(delegatorGroupId)) continue;
            delegators.put(delegatorGroupId, new KimGroupRecipient(KimApiServiceLocator.getGroupService().getGroup(delegatorGroupId)));
        }
        return delegators.values();
    }

    @Override
    public Collection<Recipient> findUserPrimaryDelegations(String principalId) {
        List workgroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        Predicate whoPredicate = null;
        whoPredicate = CollectionUtils.isNotEmpty((Collection)workgroupIds) ? PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.equal((String)"delegatorPrincipalId", (Object)principalId), PredicateFactory.in((String)"delegatorGroupId", (Collection)workgroupIds)}) : PredicateFactory.equal((String)"delegatorPrincipalId", (Object)principalId);
        QueryByCriteria query = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{whoPredicate, PredicateFactory.equal((String)"delegationType", (Object)DelegationType.PRIMARY.getCode())});
        QueryResults results = this.dataObjectService.findMatching(ActionItem.class, query);
        HashMap<String, WebFriendlyRecipient> delegators = new HashMap<String, WebFriendlyRecipient>(results.getResults().size());
        for (ActionItem actionItem : results.getResults()) {
            String recipientPrincipalId = actionItem.getPrincipalId();
            if (recipientPrincipalId == null || delegators.containsKey(recipientPrincipalId)) continue;
            delegators.put(recipientPrincipalId, new WebFriendlyRecipient(KimApiServiceLocator.getPersonService().getPerson(recipientPrincipalId)));
        }
        return delegators.values();
    }

    @Override
    public Collection<ActionItem> getActionList(String principalId, ActionListFilter filter) {
        ArrayList<String> filteredByItems = new ArrayList<String>();
        List<Predicate> crit = this.handleActionItemCriteria(principalId, filter, filteredByItems);
        if (LOG.isDebugEnabled()) {
            LOG.debug("running query to get action list for criteria " + crit);
        }
        QueryByCriteria query = QueryByCriteria.Builder.fromPredicates(crit);
        QueryResults results = this.dataObjectService.findMatching(ActionItem.class, query);
        if (LOG.isDebugEnabled()) {
            LOG.debug("found " + results.getResults().size() + " action items for user " + principalId);
        }
        if (filter != null) {
            boolean filterOn = !filteredByItems.isEmpty();
            filter.setFilterOn(filterOn);
            filter.setFilterLegend(StringUtils.join(filteredByItems, (String)", "));
        }
        return this.createActionListForUser(results.getResults());
    }

    protected List<Predicate> handleActionItemCriteria(String principalId, ActionListFilter filter, List<String> filteredByItems) {
        LOG.debug("setting up Action List criteria");
        ArrayList<Predicate> crit = new ArrayList<Predicate>();
        if (filter != null) {
            this.handleActionRequestedCriteria(filter, crit, filteredByItems);
            this.handleDocumentCreateDateCriteria(filter, crit, filteredByItems);
            this.handleAssignedDateCriteria(filter, crit, filteredByItems);
            this.handleRouteStatusCriteria(filter, crit, filteredByItems);
            this.handleDocumentTitleCriteria(filter, crit, filteredByItems);
            this.handleDocumentTypeCriteria(filter, crit, filteredByItems);
            this.handleWorkgroupCriteria(filter, crit, filteredByItems);
            this.handleRecipientCriteria(principalId, filter, crit, filteredByItems);
        } else {
            crit.add(PredicateFactory.equal((String)"principalId", (Object)principalId));
        }
        LOG.debug("Completed setting up Action List criteria");
        return crit;
    }

    protected void handleActionRequestedCriteria(ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        if (StringUtils.isNotBlank((String)filter.getActionRequestCd()) && !filter.getActionRequestCd().equals("All")) {
            if (filter.isExcludeActionRequestCd()) {
                crit.add(PredicateFactory.notEqual((String)"actionRequestCd", (Object)filter.getActionRequestCd()));
            } else {
                crit.add(PredicateFactory.equal((String)"actionRequestCd", (Object)filter.getActionRequestCd()));
            }
            filteredByItems.add("Action Requested");
        }
    }

    protected void handleDateCriteria(String propertyPath, String filterLabel, Date fromDate, Date toDate, boolean excludeDates, Collection<Predicate> crit, List<String> filteredByItems) {
        if (fromDate != null || toDate != null) {
            Timestamp fromDateTimestamp = this.beginningOfDay(fromDate);
            Timestamp toDateTimestamp = this.endOfDay(toDate);
            if (excludeDates) {
                if (fromDate != null && toDate != null) {
                    crit.add(PredicateFactory.notBetween((String)propertyPath, (Object)fromDateTimestamp, (Object)toDateTimestamp));
                } else if (fromDate != null && toDate == null) {
                    crit.add(PredicateFactory.lessThanOrEqual((String)propertyPath, (Object)fromDateTimestamp));
                } else if (fromDate == null && toDate != null) {
                    crit.add(PredicateFactory.greaterThanOrEqual((String)propertyPath, (Object)toDateTimestamp));
                }
            } else if (fromDate != null && toDate != null) {
                crit.add(PredicateFactory.between((String)propertyPath, (Object)fromDateTimestamp, (Object)toDateTimestamp));
            } else if (fromDate != null && toDate == null) {
                crit.add(PredicateFactory.greaterThanOrEqual((String)propertyPath, (Object)fromDateTimestamp));
            } else if (fromDate == null && toDate != null) {
                crit.add(PredicateFactory.lessThanOrEqual((String)propertyPath, (Object)toDateTimestamp));
            }
            filteredByItems.add("Date Created");
        }
    }

    protected void handleDocumentCreateDateCriteria(ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        this.handleDateCriteria("routeHeader.createDate", "Date Created", filter.getCreateDateFrom(), filter.getCreateDateTo(), filter.isExcludeCreateDate(), crit, filteredByItems);
    }

    protected void handleAssignedDateCriteria(ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        this.handleDateCriteria("dateAssigned", "Date Last Assigned", filter.getLastAssignedDateFrom(), filter.getLastAssignedDateTo(), filter.isExcludeLastAssignedDate(), crit, filteredByItems);
    }

    protected void handleRouteStatusCriteria(ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        if (StringUtils.isNotBlank((String)filter.getDocRouteStatus()) && !filter.getDocRouteStatus().equals("All")) {
            if (filter.isExcludeRouteStatus()) {
                crit.add(PredicateFactory.notEqual((String)"routeHeader.docRouteStatus", (Object)filter.getDocRouteStatus()));
            } else {
                crit.add(PredicateFactory.equal((String)"routeHeader.docRouteStatus", (Object)filter.getDocRouteStatus()));
            }
            filteredByItems.add("Document Route Status");
        }
    }

    protected void handleDocumentTitleCriteria(ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        if (StringUtils.isNotBlank((String)filter.getDocumentTitle())) {
            String docTitle = filter.getDocumentTitle().trim();
            if (docTitle.endsWith("*")) {
                docTitle = docTitle.substring(0, docTitle.length() - 1);
            }
            if (filter.isExcludeDocumentTitle()) {
                crit.add(PredicateFactory.notLike((String)"docTitle", (CharSequence)("%" + docTitle + "%")));
            } else {
                crit.add(PredicateFactory.like((String)"docTitle", (CharSequence)("%" + docTitle + "%")));
            }
            filteredByItems.add("Document Title");
        }
    }

    protected void handleDocumentTypeCriteria(ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        if (StringUtils.isNotBlank((String)filter.getDocumentType())) {
            String documentTypeName = filter.getDocumentType();
            if (filter.isExcludeDocumentType()) {
                crit.add(PredicateFactory.notLike((String)"docName", (CharSequence)("%" + documentTypeName + "%")));
            } else {
                DocumentType documentType = this.documentTypeService.findByName(documentTypeName);
                if (documentType == null) {
                    crit.add(PredicateFactory.like((String)"docName", (CharSequence)("%" + documentTypeName + "%")));
                } else {
                    Collection<DocumentType> docs = this.getAllChildDocumentTypes(documentType);
                    ArrayList<String> docNames = new ArrayList<String>(docs.size() + 1);
                    docNames.add(documentType.getName());
                    for (DocumentType doc : docs) {
                        docNames.add(doc.getName());
                    }
                    crit.add(PredicateFactory.in((String)"docName", docNames));
                }
            }
            filteredByItems.add("Document Type");
        }
    }

    protected Collection<DocumentType> getAllChildDocumentTypes(DocumentType docType) {
        ArrayList<DocumentType> allChildren = new ArrayList<DocumentType>();
        List<DocumentType> immediateChildren = this.documentTypeService.getChildDocumentTypes(docType.getId());
        if (immediateChildren != null) {
            allChildren.addAll(immediateChildren);
            for (DocumentType childDoc : immediateChildren) {
                allChildren.addAll(this.getAllChildDocumentTypes(childDoc));
            }
        }
        return allChildren;
    }

    protected void handleWorkgroupCriteria(ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        filter.setGroupId(null);
        if (StringUtils.isNotBlank((String)filter.getGroupIdString()) && !filter.getGroupIdString().trim().equals("No Filtering")) {
            filter.setGroupId(filter.getGroupIdString().trim());
            if (filter.isExcludeGroupId()) {
                crit.add(PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.notEqual((String)"groupId", (Object)filter.getGroupId()), PredicateFactory.isNull((String)"groupId")}));
            } else {
                crit.add(PredicateFactory.equal((String)"groupId", (Object)filter.getGroupId()));
            }
            filteredByItems.add("Action Request Workgroup");
        }
    }

    protected void applyPrimaryDelegationCriteria(String actionListUserPrincipalId, ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        List delegatorGroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(actionListUserPrincipalId);
        if (delegatorGroupIds != null && !delegatorGroupIds.isEmpty()) {
            crit.add(PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.equal((String)"delegatorPrincipalId", (Object)actionListUserPrincipalId), PredicateFactory.in((String)"delegatorGroupId", (Collection)delegatorGroupIds)}));
        } else {
            crit.add(PredicateFactory.equal((String)"delegatorPrincipalId", (Object)actionListUserPrincipalId));
        }
        crit.add(PredicateFactory.equal((String)"delegationType", (Object)DelegationType.PRIMARY.getCode()));
        filter.setDelegationType(DelegationType.PRIMARY.getCode());
        filter.setExcludeDelegationType(false);
        filteredByItems.add("Primary Delegator Id");
    }

    protected boolean handlePrimaryDelegation(String actionListUserPrincipalId, ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        if (StringUtils.isBlank((String)filter.getPrimaryDelegateId()) || filter.getPrimaryDelegateId().trim().equals("All")) {
            this.applyPrimaryDelegationCriteria(actionListUserPrincipalId, filter, crit, filteredByItems);
            return true;
        }
        if (!filter.getPrimaryDelegateId().trim().equals("Choose Primary Delegate")) {
            crit.add(PredicateFactory.equal((String)"principalId", (Object)filter.getPrimaryDelegateId()));
            this.applyPrimaryDelegationCriteria(actionListUserPrincipalId, filter, crit, filteredByItems);
            return true;
        }
        return false;
    }

    protected boolean handleSecondaryDelegation(String actionListUserPrincipalId, ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        crit.add(PredicateFactory.equal((String)"principalId", (Object)actionListUserPrincipalId));
        if (StringUtils.isBlank((String)filter.getDelegatorId())) {
            filter.setDelegationType(DelegationType.SECONDARY.getCode());
            if (!filter.isExcludeDelegationType()) {
                crit.add(PredicateFactory.equal((String)"delegationType", (Object)DelegationType.SECONDARY.getCode()));
                filteredByItems.add("Secondary Delegator Id");
                return true;
            }
        } else {
            if (filter.getDelegatorId().trim().equals("All")) {
                crit.add(PredicateFactory.equal((String)"delegationType", (Object)DelegationType.SECONDARY.getCode()));
                filter.setDelegationType(DelegationType.SECONDARY.getCode());
                filter.setExcludeDelegationType(false);
                filteredByItems.add("Secondary Delegator Id");
                return true;
            }
            if (!filter.getDelegatorId().trim().equals("Choose Secondary Delegation")) {
                filter.setDelegationType(DelegationType.SECONDARY.getCode());
                filter.setExcludeDelegationType(false);
                if (filter.isExcludeDelegatorId()) {
                    crit.add(PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.notEqual((String)"delegatorPrincipalId", (Object)filter.getDelegatorId()), PredicateFactory.isNull((String)"delegatorPrincipalId")}));
                    crit.add(PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.notEqual((String)"delegatorGroupId", (Object)filter.getDelegatorId()), PredicateFactory.isNull((String)"delegatorGroupId")}));
                } else {
                    crit.add(PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.equal((String)"delegatorPrincipalId", (Object)filter.getDelegatorId()), PredicateFactory.equal((String)"delegatorGroupId", (Object)filter.getDelegatorId())}));
                }
                filteredByItems.add("Secondary Delegator Id");
                return true;
            }
        }
        return false;
    }

    protected void handleRecipientCriteria(String actionListUserPrincipalId, ActionListFilter filter, Collection<Predicate> crit, List<String> filteredByItems) {
        if (StringUtils.isBlank((String)filter.getDelegationType()) && StringUtils.isBlank((String)filter.getPrimaryDelegateId()) && StringUtils.isBlank((String)filter.getDelegatorId())) {
            crit.add(PredicateFactory.equal((String)"principalId", (Object)actionListUserPrincipalId));
            return;
        }
        if ((StringUtils.equals((String)filter.getDelegationType(), (String)DelegationType.PRIMARY.getCode()) || StringUtils.isNotBlank((String)filter.getPrimaryDelegateId())) && this.handlePrimaryDelegation(actionListUserPrincipalId, filter, crit, filteredByItems)) {
            return;
        }
        if ((StringUtils.equals((String)filter.getDelegationType(), (String)DelegationType.SECONDARY.getCode()) || StringUtils.isNotBlank((String)filter.getDelegatorId())) && this.handleSecondaryDelegation(actionListUserPrincipalId, filter, crit, filteredByItems)) {
            return;
        }
        filter.setDelegationType(DelegationType.SECONDARY.getCode());
        filter.setExcludeDelegationType(true);
        crit.add(PredicateFactory.equal((String)"principalId", (Object)actionListUserPrincipalId));
        crit.add(PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.notEqual((String)"delegationType", (Object)DelegationType.SECONDARY.getCode()), PredicateFactory.isNull((String)"delegationType")}));
    }

    private Collection<ActionItem> createActionListForUser(Collection<ActionItem> actionItems) {
        HashMap<String, ActionItem> actionItemMap = new HashMap<String, ActionItem>();
        ActionListPriorityComparator comparator = new ActionListPriorityComparator();
        for (ActionItem potentialActionItem : actionItems) {
            ActionItem existingActionItem = (ActionItem)actionItemMap.get(potentialActionItem.getDocumentId());
            if (existingActionItem != null && comparator.compare(potentialActionItem, existingActionItem) <= 0) continue;
            actionItemMap.put(potentialActionItem.getDocumentId(), potentialActionItem);
        }
        return actionItemMap.values();
    }

    @Override
    public Collection<ActionItem> getActionListForSingleDocument(String documentId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getting action list for document id " + documentId);
        }
        Collection<ActionItem> collection = this.findByDocumentId(documentId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("found " + collection.size() + " action items for document id " + documentId);
        }
        return this.createActionListForRouteHeader(collection);
    }

    protected Collection<ActionItem> createActionListForRouteHeader(Collection<ActionItem> actionItems) {
        HashMap<String, ActionItem> actionItemMap = new HashMap<String, ActionItem>();
        ActionListPriorityComparator comparator = new ActionListPriorityComparator();
        for (ActionItem potentialActionItem : actionItems) {
            ActionItem existingActionItem = (ActionItem)actionItemMap.get(potentialActionItem.getPrincipalId());
            if (existingActionItem != null && comparator.compare(potentialActionItem, existingActionItem) <= 0) continue;
            actionItemMap.put(potentialActionItem.getPrincipalId(), potentialActionItem);
        }
        return actionItemMap.values();
    }

    public void setActionListDAO(ActionListDAO actionListDAO) {
        this.actionListDAO = actionListDAO;
    }

    public ActionListDAO getActionListDAO() {
        return this.actionListDAO;
    }

    @Override
    public void deleteActionItemNoOutbox(ActionItem actionItem) {
        this.deleteActionItem(actionItem, false, false);
    }

    @Override
    public void deleteActionItem(ActionItem actionItem) {
        this.deleteActionItem(actionItem, false);
    }

    @Override
    public void deleteActionItem(ActionItem actionItem, boolean forceIntoOutbox) {
        this.deleteActionItem(actionItem, forceIntoOutbox, true);
    }

    protected void deleteActionItem(ActionItem actionItem, boolean forceIntoOutbox, boolean putInOutbox) {
        this.dataObjectService.delete((Object)actionItem);
        this.notificationService.removeNotification(Collections.singletonList(ActionItem.to(actionItem)));
        if (putInOutbox) {
            this.saveOutboxItem(actionItem, forceIntoOutbox);
        }
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        this.dataObjectService.deleteMatching(ActionItem.class, QueryByCriteria.Builder.forAttribute((String)"documentId", (Object)documentId).build());
    }

    @Override
    public Collection<ActionItem> findByDocumentId(String documentId) {
        QueryResults results = this.dataObjectService.findMatching(ActionItem.class, QueryByCriteria.Builder.forAttribute((String)"documentId", (Object)documentId).build());
        return results.getResults();
    }

    @Override
    public Collection<ActionItem> findByActionRequestId(String actionRequestId) {
        QueryResults results = this.dataObjectService.findMatching(ActionItem.class, QueryByCriteria.Builder.forAttribute((String)"actionRequestId", (Object)actionRequestId).build());
        return results.getResults();
    }

    @Override
    public Collection<ActionItem> findByWorkflowUserDocumentId(String workflowUserId, String documentId) {
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("principalId", workflowUserId);
        criteria.put("documentId", documentId);
        QueryResults results = this.dataObjectService.findMatching(ActionItem.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        return results.getResults();
    }

    @Override
    public Collection<ActionItem> findByDocumentTypeName(String documentTypeName) {
        QueryResults results = this.dataObjectService.findMatching(ActionItem.class, QueryByCriteria.Builder.forAttribute((String)"docName", (Object)documentTypeName).build());
        return results.getResults();
    }

    @Override
    public ActionItem createActionItemForActionRequest(ActionRequestValue actionRequest) {
        ActionItem actionItem = new ActionItem();
        DocumentRouteHeaderValue routeHeader = actionRequest.getRouteHeader();
        DocumentType docType = routeHeader.getDocumentType();
        actionItem.setActionRequestCd(actionRequest.getActionRequested());
        actionItem.setActionRequestId(actionRequest.getActionRequestId());
        actionItem.setDocName(docType.getName());
        actionItem.setRoleName(actionRequest.getQualifiedRoleName());
        actionItem.setPrincipalId(actionRequest.getPrincipalId());
        actionItem.setDocumentId(actionRequest.getDocumentId());
        actionItem.setDateAssigned(new Timestamp(new Date().getTime()));
        actionItem.setDocHandlerURL(docType.getResolvedDocumentHandlerUrl());
        actionItem.setDocLabel(docType.getLabel());
        actionItem.setDocTitle(routeHeader.getDocTitle());
        actionItem.setGroupId(actionRequest.getGroupId());
        actionItem.setResponsibilityId(actionRequest.getResponsibilityId());
        actionItem.setDelegationType(actionRequest.getDelegationType());
        actionItem.setRequestLabel(actionRequest.getRequestLabel());
        ActionRequestValue delegatorActionRequest = this.actionRequestService.findDelegatorRequest(actionRequest);
        if (delegatorActionRequest != null) {
            actionItem.setDelegatorPrincipalId(delegatorActionRequest.getPrincipalId());
            actionItem.setDelegatorGroupId(delegatorActionRequest.getGroupId());
        }
        return actionItem;
    }

    @Override
    public void updateActionItemsForTitleChange(String documentId, String newTitle) {
        Collection<ActionItem> items = this.findByDocumentId(documentId);
        for (ActionItem item : items) {
            item.setDocTitle(newTitle);
            this.saveActionItem(item);
        }
    }

    @Override
    public ActionItem saveActionItem(ActionItem actionItem) {
        return this.saveActionItemBase(actionItem);
    }

    @Override
    public OutboxItem saveOutboxItem(OutboxItem outboxItem) {
        return this.saveActionItemBase(outboxItem);
    }

    protected <T extends ActionItemBase> T saveActionItemBase(T actionItemBase) {
        if (actionItemBase.getDateAssigned() == null) {
            actionItemBase.setDateAssigned(this.dateTimeService.getCurrentTimestamp());
        }
        return (T)((ActionItemBase)this.dataObjectService.save(actionItemBase, new PersistenceOption[0]));
    }

    public GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    @Override
    public ActionItem findByActionItemId(String actionItemId) {
        return (ActionItem)this.dataObjectService.find(ActionItem.class, (Object)actionItemId);
    }

    @Override
    public int getCount(String principalId) {
        return this.actionListDAO.getCount(principalId);
    }

    @Override
    public List<Object> getMaxActionItemDateAssignedAndCountForUser(String principalId) {
        ArrayList<Object> verifiedList = new ArrayList<Object>();
        List<Object> maxDateAndUserCount = this.getActionListDAO().getMaxActionItemDateAssignedAndCountForUser(principalId);
        verifiedList.add(0, this.verifyMaxActionItemDateAssigned(maxDateAndUserCount));
        verifiedList.add(1, this.verifyCountForUser(maxDateAndUserCount));
        return verifiedList;
    }

    private Object verifyMaxActionItemDateAssigned(List<Object> maxDateAndUserCount) {
        if (maxDateAndUserCount != null && maxDateAndUserCount.size() > 0 && maxDateAndUserCount.get(0) != null && maxDateAndUserCount.get(0) instanceof Timestamp) {
            return maxDateAndUserCount.get(0);
        }
        return new Timestamp(new Date().getTime());
    }

    private Object verifyCountForUser(List<Object> maxDateAndUserCount) {
        if (maxDateAndUserCount != null && maxDateAndUserCount.size() > 1 && maxDateAndUserCount.get(1) != null) {
            return maxDateAndUserCount.get(1);
        }
        return 0L;
    }

    @Override
    public Collection<OutboxItem> getOutbox(String principalId, ActionListFilter filter) {
        ArrayList<String> filteredByItems = new ArrayList<String>();
        List<Predicate> crit = this.handleActionItemCriteria(principalId, filter, filteredByItems);
        if (LOG.isDebugEnabled()) {
            LOG.debug("running query to get outbox list for criteria " + crit);
        }
        QueryByCriteria.Builder query = QueryByCriteria.Builder.create((QueryByCriteria)QueryByCriteria.Builder.fromPredicates(crit));
        query.setMaxResults(this.getOutboxItemLimit());
        QueryResults results = this.dataObjectService.findMatching(OutboxItem.class, query.build());
        if (LOG.isDebugEnabled()) {
            LOG.debug("found " + results.getResults().size() + " outbox items for user " + principalId);
        }
        if (filteredByItems.isEmpty()) {
            filter.setFilterOn(false);
        } else {
            filter.setFilterOn(true);
        }
        filter.setFilterLegend(StringUtils.join(filteredByItems, (String)", "));
        return results.getResults();
    }

    private Integer getOutboxItemLimit() {
        String fetchSizeParam = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "ActionList", "OUTBOX_ITEM_LIMIT");
        if (StringUtils.isNotBlank((String)fetchSizeParam)) {
            return Integer.parseInt(fetchSizeParam);
        }
        return DEFAULT_OUTBOX_ITEM_LIMIT;
    }

    @Override
    public Collection<OutboxItem> getOutboxItemsByDocumentType(String documentTypeName) {
        QueryResults results = this.dataObjectService.findMatching(OutboxItem.class, QueryByCriteria.Builder.forAttribute((String)"docName", (Object)documentTypeName).build());
        return results.getResults();
    }

    @Override
    public void removeOutboxItems(String principalId, List<String> outboxItems) {
        QueryByCriteria query = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.in((String)"id", outboxItems)});
        this.dataObjectService.deleteMatching(OutboxItem.class, query);
    }

    @Override
    public OutboxItem saveOutboxItem(ActionItem actionItem) {
        return this.saveOutboxItem(actionItem, false);
    }

    @Override
    public OutboxItem saveOutboxItem(ActionItem actionItem, boolean forceIntoOutbox) {
        Boolean isUsingOutBox = true;
        List<UserOptions> options = this.userOptionsService.findByUserQualified(actionItem.getPrincipalId(), "USE_OUT_BOX%");
        if (options == null || options.isEmpty()) {
            isUsingOutBox = true;
        } else {
            for (UserOptions u : options) {
                if (StringUtils.equals((String)u.getOptionVal(), (String)"yes")) continue;
                isUsingOutBox = false;
                break;
            }
        }
        if (isUsingOutBox.booleanValue() && ConfigContext.getCurrentContextConfig().getOutBoxOn().booleanValue() && this.getOutboxItemByDocumentIdUserId(actionItem.getDocumentId(), actionItem.getPrincipalId()) == null && !this.routeHeaderService.getRouteHeader(actionItem.getDocumentId()).getDocRouteStatus().equals("S")) {
            ActionRequestValue actionRequest = this.actionRequestService.findByActionRequestId(actionItem.getActionRequestId());
            ActionTakenValue actionTaken = actionRequest.getActionTaken();
            if (forceIntoOutbox || actionTaken != null && actionTaken.getPrincipalId().equals(actionItem.getPrincipalId())) {
                return (OutboxItem)this.dataObjectService.save((Object)new OutboxItem(actionItem), new PersistenceOption[0]);
            }
        }
        return null;
    }

    protected OutboxItem getOutboxItemByDocumentIdUserId(String documentId, String principalId) {
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("principalId", principalId);
        criteria.put("documentId", documentId);
        QueryResults results = this.dataObjectService.findMatching(OutboxItem.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        if (results.getResults().isEmpty()) {
            return null;
        }
        return (OutboxItem)results.getResults().get(0);
    }

    @Override
    public Collection<ActionItem> findByPrincipalId(String principalId) {
        QueryResults results = this.dataObjectService.findMatching(ActionItem.class, QueryByCriteria.Builder.forAttribute((String)"principalId", (Object)principalId).setOrderByAscending(new String[]{"documentId"}).build());
        return results.getResults();
    }

    @Override
    public DocumentRouteHeaderValue getMinimalRouteHeader(String documentId) {
        return this.actionListDAO.getMinimalRouteHeader(documentId);
    }

    protected Timestamp beginningOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    protected Timestamp endOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return new Timestamp(cal.getTimeInMillis());
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setActionRequestService(ActionRequestService actionRequestService) {
        this.actionRequestService = actionRequestService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    public void setUserOptionsService(UserOptionsService userOptionsService) {
        this.userOptionsService = userOptionsService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }
}

