/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.action;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.reflect.DataDefinition;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionInvocation;
import org.kuali.rice.kew.api.action.ActionInvocationQueue;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.impl.action.ActionInvocationQueueAsyncCapableImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.AsyncWrappable;

public class ActionInvocationQueueImpl
implements ActionInvocationQueue,
AsyncWrappable<ActionInvocationQueue> {
    private static final Logger LOG = LogManager.getLogger(ActionInvocationQueueImpl.class);
    private AsyncCapableService asyncCapableService;

    public void invokeAction(String principalId, String documentId, ActionInvocation invocation) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId is null or blank");
        }
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId is null");
        }
        if (invocation == null) {
            throw new RiceIllegalArgumentException("invocation is null");
        }
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId);
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(principalId);
        ArrayList<DataDefinition> parameters = new ArrayList<DataDefinition>();
        parameters.add(new DataDefinition((Object)document));
        parameters.add(new DataDefinition((Object)principal));
        parameters.add(new DataDefinition((Object)""));
        try {
            ActionTakenEvent action = KEWServiceLocator.getActionRegistry().createAction(invocation.getAction().getCode(), parameters);
            if (!document.isValidActionToTake(invocation.getAction().getCode())) {
                LOG.warn("Action " + invocation.getAction() + " is not a valid action to take against document " + document.getDocumentId() + " by principal with name '" + principal.getPrincipalName() + "'");
                return;
            }
            if (!KEWServiceLocator.getActionRegistry().getValidActions((PrincipalContract)principal, document).getValidActions().contains(ActionType.fromCode((String)action.getActionTakenCode()))) {
                LOG.warn("Action " + action.getActionTakenCode() + " is not valid for document " + document.getDocumentId() + " by principal with name '" + principal.getPrincipalName() + "'");
                return;
            }
            action.performAction();
        }
        catch (ResourceUnavailableException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        catch (InvalidActionTakenException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public ActionInvocationQueue wrap(QName qname, String applicationId) {
        return new ActionInvocationQueueAsyncCapableImpl(this.getAsyncCapableService(), this, qname, applicationId);
    }

    public AsyncCapableService getAsyncCapableService() {
        return this.asyncCapableService;
    }

    public void setAsyncCapableService(AsyncCapableService asyncCapableService) {
        this.asyncCapableService = asyncCapableService;
    }
}

