/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail.service.impl;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.mail.EmailBody;
import org.kuali.rice.core.api.mail.EmailFrom;
import org.kuali.rice.core.api.mail.EmailSubject;
import org.kuali.rice.core.api.mail.EmailTo;
import org.kuali.rice.core.api.mail.Mailer;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionItemContract;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.mail.CustomEmailAttribute;
import org.kuali.rice.kew.mail.DailyEmailJob;
import org.kuali.rice.kew.mail.WeeklyEmailJob;
import org.kuali.rice.kew.mail.service.ActionListEmailService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.triggers.CronTriggerImpl;

public class ActionListEmailServiceImpl
implements ActionListEmailService {
    private static Logger LOG = LogManager.getLogger(ActionListEmailServiceImpl.class);
    private static final String DEFAULT_EMAIL_FROM_ADDRESS = "admin@localhost";
    private static final String ACTION_LIST_REMINDER = "Action List Reminder";
    private static final String IMMEDIATE_REMINDER_EMAIL_MESSAGE_KEY = "immediate.reminder.email.message";
    private static final String IMMEDIATE_REMINDER_EMAIL_SUBJECT_KEY = "immediate.reminder.email.subject";
    private static final String DAILY_TRIGGER_NAME = "Daily Email Trigger";
    private static final String DAILY_JOB_NAME = "Daily Email";
    private static final String WEEKLY_TRIGGER_NAME = "Weekly Email Trigger";
    private static final String WEEKLY_JOB_NAME = "Weekly Email";
    private String deploymentEnvironment;
    private Mailer mailer;
    private static final MessageFormat DEFAULT_IMMEDIATE_REMINDER = new MessageFormat("Your Action List has an eDoc(electronic document) that needs your attention: \n\nDocument ID:\t{0,number,#}\nInitiator:\t\t{1}\nType:\t\tAdd/Modify {2}\nTitle:\t\t{3}\n\n\nTo respond to this eDoc: \n\tGo to {4}\n\n\tOr you may access the eDoc from your Action List: \n\tGo to {5}, and then click on the numeric Document ID: {0,number,#} in the first column of the List. \n\n\n\nTo change how these email notifications are sent(daily, weekly or none): \n\tGo to {6}\n\n\n\n{7}\n\n\n");
    private static final MessageFormat DEFAULT_IMMEDIATE_REMINDER_NO_DOC_HANDLER = new MessageFormat("Your Action List has an eDoc(electronic document) that needs your attention: \n\nDocument ID:\t{0,number,#}\nInitiator:\t\t{1}\nType:\t\tAdd/Modify {2}\nTitle:\t\t{3}\n\n\nTo respond to this eDoc you may use your Action List: \n\tGo to {4}, and then take actions related to Document ID: {0,number,#}. \n\n\n\nTo change how these email notifications are sent(daily, weekly or none): \n\tGo to {5}\n\n\n\n{6}\n\n\n");

    public void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    public String getDocumentTypeEmailAddress(DocumentType documentType) {
        String fromAddress;
        String string = fromAddress = documentType == null ? null : documentType.getNotificationFromAddress();
        if (StringUtils.isEmpty((String)fromAddress)) {
            fromAddress = this.getApplicationEmailAddress();
        }
        return fromAddress;
    }

    public String getApplicationEmailAddress() {
        String fromAddress = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Mailer", "FROM_ADDRESS");
        if (StringUtils.isEmpty((String)fromAddress)) {
            fromAddress = DEFAULT_EMAIL_FROM_ADDRESS;
        }
        return fromAddress;
    }

    protected String getHelpLink() {
        return this.getHelpLink(null);
    }

    protected String getHelpLink(DocumentType documentType) {
        return "For additional help, email <mailto:" + this.getDocumentTypeEmailAddress(documentType) + ">";
    }

    public EmailSubject getEmailSubject() {
        String subject = ConfigContext.getCurrentContextConfig().getProperty(IMMEDIATE_REMINDER_EMAIL_SUBJECT_KEY);
        if (subject == null) {
            subject = ACTION_LIST_REMINDER;
        }
        return new EmailSubject(subject);
    }

    public EmailSubject getEmailSubject(String customSubject) {
        String subject = ConfigContext.getCurrentContextConfig().getProperty(IMMEDIATE_REMINDER_EMAIL_SUBJECT_KEY);
        if (subject == null) {
            subject = ACTION_LIST_REMINDER;
        }
        return new EmailSubject(subject + " " + customSubject);
    }

    protected EmailFrom getEmailFrom(DocumentType documentType) {
        return new EmailFrom(this.getDocumentTypeEmailAddress(documentType));
    }

    protected EmailTo getEmailTo(Person user) {
        String address = user.getEmailAddressUnmasked();
        if (!this.isProduction()) {
            LOG.info("If this were production, email would be sent to " + user.getEmailAddressUnmasked());
            address = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "ActionList", "EMAIL_NOTIFICATION_TEST_ADDRESS");
        }
        return new EmailTo(address);
    }

    protected void sendEmail(Person user, EmailSubject subject, EmailBody body) {
        this.sendEmail(user, subject, body, null, false);
    }

    protected void sendEmail(Person user, EmailSubject subject, EmailBody body, DocumentType documentType) {
        this.sendEmail(user, subject, body, documentType, false);
    }

    protected void sendEmail(Person user, EmailSubject subject, EmailBody body, DocumentType documentType, Boolean isHtmlMessage) {
        try {
            if (StringUtils.isNotBlank((String)user.getEmailAddressUnmasked())) {
                this.mailer.sendEmail(this.getEmailFrom(documentType), this.getEmailTo(user), subject, body, isHtmlMessage.booleanValue());
            }
        }
        catch (Exception e) {
            LOG.error("Error sending Action List email to " + user.getEmailAddressUnmasked(), (Throwable)e);
        }
    }

    protected boolean checkEmailNotificationPreferences(ActionItemContract actionItem, Preferences preferences, String emailSetting) {
        boolean shouldSend = true;
        if (actionItem.getDelegationType() != null) {
            if ("P".equalsIgnoreCase(actionItem.getDelegationType().getCode())) {
                shouldSend = "yes".equals(preferences.getNotifyPrimaryDelegation());
            } else if ("S".equalsIgnoreCase(actionItem.getDelegationType().getCode())) {
                shouldSend = "yes".equals(preferences.getNotifySecondaryDelegation());
            }
        }
        if (!shouldSend) {
            return false;
        }
        boolean checkRequestCodePreferences = StringUtils.equals((String)actionItem.getActionRequestCd(), (String)"C") && StringUtils.equals((String)preferences.getNotifyComplete(), (String)"yes") || StringUtils.equals((String)actionItem.getActionRequestCd(), (String)"A") && StringUtils.equals((String)preferences.getNotifyApprove(), (String)"yes") || StringUtils.equals((String)actionItem.getActionRequestCd(), (String)"K") && StringUtils.equals((String)preferences.getNotifyAcknowledge(), (String)"yes") || StringUtils.equals((String)actionItem.getActionRequestCd(), (String)"F") && StringUtils.equals((String)preferences.getNotifyFYI(), (String)"yes");
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(actionItem.getDocumentId());
        DocumentType documentType = null;
        Boolean suppressImmediateEmailsOnSuActionPolicy = false;
        if (document != null) {
            documentType = document.getDocumentType();
            suppressImmediateEmailsOnSuActionPolicy = documentType.getSuppressImmediateEmailsOnSuActionPolicy().getPolicyValue();
        }
        if (suppressImmediateEmailsOnSuActionPolicy.booleanValue()) {
            ActionTakenValue mostRecentActionTaken;
            String docId = actionItem.getDocumentId();
            LOG.warn("checkEmailNotificationPreferences processing document: " + docId + " of type: " + documentType.getName() + " and getSuppressImmediateEmailsOnSuActionPolicy set to true.");
            List<ActionTakenValue> actionsTaken = document.getActionsTaken();
            if (actionsTaken != null && actionsTaken.size() > 0) {
                Collections.sort(actionsTaken, new Comparator<ActionTakenValue>(){

                    @Override
                    public int compare(ActionTakenValue o1, ActionTakenValue o2) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        if (o1.getActionDate() == null && o2.getActionDate() == null) {
                            return 0;
                        }
                        if (o1.getActionDate() == null) {
                            return -1;
                        }
                        if (o2.getActionDate() == null) {
                            return 1;
                        }
                        return o2.getActionDate().compareTo(o1.getActionDate());
                    }
                });
            }
            if ((mostRecentActionTaken = actionsTaken.get(0)) != null && mostRecentActionTaken.isSuperUserAction()) {
                return false;
            }
        }
        if (preferences.getDocumentTypeNotificationPreferences().size() > 0) {
            while (KRADUtils.isNotNull((Object)documentType)) {
                String documentTypePreference = preferences.getDocumentTypeNotificationPreference(documentType.getName());
                if (StringUtils.isNotBlank((String)documentTypePreference)) {
                    if (StringUtils.equals((String)emailSetting, (String)"daily") || StringUtils.equals((String)emailSetting, (String)"weekly")) {
                        return !StringUtils.equals((String)documentTypePreference, (String)"no");
                    }
                    if (StringUtils.equals((String)emailSetting, (String)"immediate")) {
                        return StringUtils.equals((String)emailSetting, (String)documentTypePreference) && checkRequestCodePreferences;
                    }
                    return false;
                }
                documentType = documentType.getParentDocType();
            }
        }
        if (StringUtils.equals((String)emailSetting, (String)preferences.getEmailNotification())) {
            if (StringUtils.equals((String)emailSetting, (String)"immediate")) {
                return checkRequestCodePreferences;
            }
            return !StringUtils.equals((String)emailSetting, (String)"no");
        }
        return false;
    }

    @Override
    public void sendImmediateReminder(org.kuali.rice.kew.api.action.ActionItem actionItem, Boolean skipOnApprovals) {
        if (actionItem == null) {
            LOG.warn("Request to send immediate reminder to recipient of a null action item... aborting.");
            return;
        }
        if (actionItem.getPrincipalId() == null) {
            LOG.warn("Request to send immediate reminder to null recipient of an action item... aborting.");
            return;
        }
        if (skipOnApprovals != null && skipOnApprovals.booleanValue() && actionItem.getActionRequestCd().equals("A")) {
            LOG.debug("As requested, skipping immediate reminder notification on action item approval for " + actionItem.getPrincipalId());
            return;
        }
        Preferences preferences = KewApiServiceLocator.getPreferencesService().getPreferences(actionItem.getPrincipalId());
        if (!this.checkEmailNotificationPreferences((ActionItemContract)actionItem, preferences, "immediate")) {
            LOG.debug("Email suppressed due to the user's preferences");
            return;
        }
        boolean shouldSendActionListEmailNotification = this.sendActionListEmailNotification();
        if (shouldSendActionListEmailNotification) {
            LOG.debug("sending immediate reminder");
            Person person = KimApiServiceLocator.getPersonService().getPerson(actionItem.getPrincipalId());
            DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(actionItem.getDocumentId());
            StringBuffer emailBody = new StringBuffer(this.buildImmediateReminderBody(person, actionItem, document.getDocumentType()));
            StringBuffer emailSubject = new StringBuffer();
            try {
                CustomEmailAttribute customEmailAttribute = document.getCustomEmailAttribute();
                if (customEmailAttribute != null) {
                    String customEmailSubject;
                    Document routeHeaderVO = DocumentRouteHeaderValue.to(document);
                    ActionRequestValue actionRequest = KEWServiceLocator.getActionRequestService().findByActionRequestId(actionItem.getActionRequestId());
                    ActionRequest actionRequestVO = ActionRequestValue.to(actionRequest);
                    customEmailAttribute.setRouteHeaderVO(routeHeaderVO);
                    customEmailAttribute.setActionRequestVO(actionRequestVO);
                    String customBody = customEmailAttribute.getCustomEmailBody();
                    if (!StringUtils.isEmpty((String)customBody)) {
                        emailBody.append(customBody);
                    }
                    if (!StringUtils.isEmpty((String)(customEmailSubject = customEmailAttribute.getCustomEmailSubject()))) {
                        emailSubject.append(customEmailSubject);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error when checking for custom email body and subject.", (Throwable)e);
            }
            LOG.debug("Sending email to " + person);
            this.sendEmail(person, this.getEmailSubject(emailSubject.toString()), new EmailBody(emailBody.toString()), document.getDocumentType());
        }
    }

    protected boolean isProduction() {
        return ConfigContext.getCurrentContextConfig().isProductionEnvironment();
    }

    @Override
    public void sendDailyReminder() {
        LOG.info("Starting SendDailyReminder");
        if (this.sendActionListEmailNotification()) {
            Collection<String> users = this.getUsersWithEmailSetting("daily");
            for (String principalId : users) {
                try {
                    Collection<ActionItem> actionItems = this.getActionListService().getActionList(principalId, null);
                    if (actionItems == null || actionItems.size() <= 0) continue;
                    this.sendPeriodicReminder(principalId, actionItems, "daily");
                }
                catch (Exception e) {
                    LOG.error("Error sending daily action list reminder to user: " + principalId, (Throwable)e);
                }
            }
        }
        LOG.info("Daily action list emails successfully sent");
    }

    @Override
    public void sendWeeklyReminder() {
        LOG.info("Starting sendWeeklyReminder");
        if (this.sendActionListEmailNotification()) {
            Collection<String> users = this.getUsersWithEmailSetting("weekly");
            for (String principalId : users) {
                try {
                    Collection<ActionItem> actionItems = this.getActionListService().getActionList(principalId, null);
                    if (actionItems == null || actionItems.size() <= 0) continue;
                    this.sendPeriodicReminder(principalId, actionItems, "weekly");
                }
                catch (Exception e) {
                    LOG.error("Error sending weekly action list reminder to user: " + principalId, (Throwable)e);
                }
            }
        }
        LOG.info("Weekly action list emails successfully sent");
    }

    protected void sendPeriodicReminder(String principalId, Collection<ActionItem> actionItems, String emailSetting) {
        String emailBody = null;
        if ((actionItems = this.filterActionItemsToNotify(principalId, actionItems, emailSetting)).isEmpty()) {
            return;
        }
        if ("daily".equals(emailSetting)) {
            emailBody = this.buildDailyReminderBody(actionItems);
        } else if ("weekly".equals(emailSetting)) {
            emailBody = this.buildWeeklyReminderBody(actionItems);
        }
        Person person = KimApiServiceLocator.getPersonService().getPerson(principalId);
        this.sendEmail(person, this.getEmailSubject(), new EmailBody(emailBody));
    }

    protected Collection<ActionItem> filterActionItemsToNotify(String principalId, Collection<ActionItem> actionItems, String emailSetting) {
        ArrayList<ActionItem> filteredItems = new ArrayList<ActionItem>();
        Preferences preferences = KewApiServiceLocator.getPreferencesService().getPreferences(principalId);
        for (ActionItem actionItem : actionItems) {
            if (!actionItem.getPrincipalId().equals(principalId)) {
                LOG.warn("Encountered an ActionItem with an incorrect workflow ID.  Was " + actionItem.getPrincipalId() + " but expected " + principalId);
                continue;
            }
            if (!this.checkEmailNotificationPreferences(actionItem, preferences, emailSetting)) continue;
            filteredItems.add(actionItem);
        }
        return filteredItems;
    }

    protected Collection<String> getUsersWithEmailSetting(String setting) {
        HashSet<String> users = new HashSet<String>();
        List<UserOptions> userOptions = this.getUserOptionsService().retrieveEmailPreferenceUserOptions(setting);
        for (UserOptions userOption : userOptions) {
            String principalId = userOption.getWorkflowId();
            try {
                if (!users.contains(principalId)) {
                    users.add(principalId);
                    continue;
                }
                LOG.info("User " + principalId + " was already added to the list, so not adding again.");
            }
            catch (Exception e) {
                LOG.error("error retrieving workflow user with ID: " + principalId, (Throwable)e);
            }
        }
        return users;
    }

    public String buildImmediateReminderBody(Person person, org.kuali.rice.kew.api.action.ActionItem actionItem, DocumentType documentType) {
        String initiatorUser;
        Object docHandlerUrl = documentType.getResolvedDocumentHandlerUrl();
        if (StringUtils.isNotBlank((String)docHandlerUrl)) {
            docHandlerUrl = !((String)docHandlerUrl).contains("?") ? (String)docHandlerUrl + "?" : (String)docHandlerUrl + "&";
            docHandlerUrl = (String)docHandlerUrl + "docId=" + actionItem.getDocumentId();
            docHandlerUrl = (String)docHandlerUrl + "&command=displayActionListView";
        }
        StringBuffer sf = new StringBuffer();
        MessageFormat messageFormat = null;
        String stringMessageFormat = ConfigContext.getCurrentContextConfig().getProperty(IMMEDIATE_REMINDER_EMAIL_MESSAGE_KEY);
        LOG.debug("Immediate reminder email message from configuration (immediate.reminder.email.message): " + stringMessageFormat);
        messageFormat = stringMessageFormat == null ? DEFAULT_IMMEDIATE_REMINDER : new MessageFormat(stringMessageFormat);
        String string = initiatorUser = person == null ? "" : person.getName();
        if (StringUtils.isNotBlank((String)docHandlerUrl)) {
            args = new Object[]{actionItem.getDocumentId(), initiatorUser, documentType.getName(), actionItem.getDocTitle(), docHandlerUrl, this.getActionListUrl(), this.getPreferencesUrl(), this.getHelpLink(documentType)};
            messageFormat.format(args, sf, new FieldPosition(0));
            LOG.debug("default immediate reminder: " + DEFAULT_IMMEDIATE_REMINDER.format(args));
        } else {
            args = new Object[]{actionItem.getDocumentId(), initiatorUser, documentType.getName(), actionItem.getDocTitle(), this.getActionListUrl(), this.getPreferencesUrl(), this.getHelpLink(documentType)};
            messageFormat.format(args, sf, new FieldPosition(0));
            LOG.debug("default immediate reminder: " + DEFAULT_IMMEDIATE_REMINDER_NO_DOC_HANDLER.format(args));
        }
        LOG.debug("immediate reminder: " + sf);
        if (!this.isProduction()) {
            try {
                sf.append("Action Item sent to " + actionItem.getPrincipalId());
                if (actionItem.getDelegationType() != null) {
                    sf.append(" for delegation type " + actionItem.getDelegationType());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sf.toString();
    }

    public String buildDailyReminderBody(Collection<ActionItem> actionItems) {
        StringBuffer sf = new StringBuffer();
        sf.append(this.getDailyWeeklyMessageBody(actionItems));
        sf.append("To change how these email notifications are sent (immediately, weekly or none): \n");
        sf.append("\tGo to " + this.getPreferencesUrl() + "\n");
        sf.append("\n\n\n");
        sf.append(this.getHelpLink() + "\n\n\n");
        return sf.toString();
    }

    public String buildWeeklyReminderBody(Collection<ActionItem> actionItems) {
        StringBuffer sf = new StringBuffer();
        sf.append(this.getDailyWeeklyMessageBody(actionItems));
        sf.append("To change how these email notifications are sent (immediately, daily or none): \n");
        sf.append("\tGo to " + this.getPreferencesUrl() + "\n");
        sf.append("\n\n\n");
        sf.append(this.getHelpLink() + "\n\n\n");
        return sf.toString();
    }

    String getDailyWeeklyMessageBody(Collection<ActionItem> actionItems) {
        StringBuffer sf = new StringBuffer();
        HashMap<String, Integer> docTypes = this.getActionListItemsStat(actionItems);
        sf.append("Your Action List has " + actionItems.size() + " eDocs(electronic documents) that need your attention: \n\n");
        for (String docTypeName : docTypes.keySet()) {
            sf.append("\t" + docTypes.get(docTypeName).toString() + "\t" + docTypeName + "\n");
        }
        sf.append("\n\n");
        sf.append("To respond to each of these eDocs: \n");
        sf.append("\tGo to " + this.getActionListUrl() + ", and then click on its numeric Document ID in the first column of the List.\n");
        sf.append("\n\n\n");
        return sf.toString();
    }

    private HashMap<String, Integer> getActionListItemsStat(Collection<ActionItem> actionItems) {
        LinkedHashMap<String, Integer> docTypes = new LinkedHashMap<String, Integer>();
        ArrayList<org.kuali.rice.kew.api.action.ActionItem> apiActionItems = new ArrayList<org.kuali.rice.kew.api.action.ActionItem>();
        for (ActionItem actionItem : actionItems) {
            apiActionItems.add(ActionItem.to(actionItem));
        }
        Map<String, DocumentRouteHeaderValue> routeHeaders = KEWServiceLocator.getRouteHeaderService().getRouteHeadersForActionItems(apiActionItems);
        Iterator<ActionItem> iter = actionItems.iterator();
        while (iter.hasNext()) {
            String docTypeName = routeHeaders.get(iter.next().getDocumentId()).getDocumentType().getName();
            if (docTypes.containsKey(docTypeName)) {
                docTypes.put(docTypeName, new Integer((Integer)((HashMap)docTypes).get(docTypeName) + 1));
                continue;
            }
            docTypes.put(docTypeName, new Integer(1));
        }
        return docTypes;
    }

    protected boolean sendActionListEmailNotification() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("actionlistsendconstant: " + CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "ActionList", "SEND_EMAIL_NOTIFICATION_IND"));
        }
        return "Y".equals(CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "ActionList", "SEND_EMAIL_NOTIFICATION_IND"));
    }

    @Override
    public void scheduleBatchEmailReminders() throws Exception {
        String emailBatchGroup = "Email Batch";
        String dailyCron = ConfigContext.getCurrentContextConfig().getProperty("dailyEmail.cronExpression");
        if (!StringUtils.isBlank((String)dailyCron)) {
            LOG.info("Scheduling Daily Email batch with cron expression: " + dailyCron);
            CronTriggerImpl dailyTrigger = new CronTriggerImpl(DAILY_TRIGGER_NAME, emailBatchGroup, dailyCron);
            JobDetailImpl dailyJobDetail = new JobDetailImpl(DAILY_JOB_NAME, emailBatchGroup, DailyEmailJob.class);
            dailyTrigger.setJobName(dailyJobDetail.getName());
            dailyTrigger.setJobGroup(dailyJobDetail.getGroup());
            this.addJobToScheduler((JobDetail)dailyJobDetail);
            this.addTriggerToScheduler((Trigger)dailyTrigger);
        } else {
            LOG.warn("No dailyEmail.cronExpression parameter was configured.  Daily Email batch was not scheduled!");
        }
        String weeklyCron = ConfigContext.getCurrentContextConfig().getProperty("weeklyEmail.cronExpression");
        if (!StringUtils.isBlank((String)weeklyCron)) {
            LOG.info("Scheduling Weekly Email batch with cron expression: " + weeklyCron);
            CronTriggerImpl weeklyTrigger = new CronTriggerImpl(WEEKLY_TRIGGER_NAME, emailBatchGroup, weeklyCron);
            JobDetailImpl weeklyJobDetail = new JobDetailImpl(WEEKLY_JOB_NAME, emailBatchGroup, WeeklyEmailJob.class);
            weeklyTrigger.setJobName(weeklyJobDetail.getName());
            weeklyTrigger.setJobGroup(weeklyJobDetail.getGroup());
            this.addJobToScheduler((JobDetail)weeklyJobDetail);
            this.addTriggerToScheduler((Trigger)weeklyTrigger);
        } else {
            LOG.warn("No weeklyEmail.cronExpression parameter was configured.  Weekly Email batch was not scheduled!");
        }
    }

    private void addJobToScheduler(JobDetail jobDetail) throws SchedulerException {
        this.getScheduler().addJob(jobDetail, true);
    }

    private void addTriggerToScheduler(Trigger trigger) throws SchedulerException {
        boolean triggerExists;
        boolean bl = triggerExists = this.getScheduler().getTrigger(trigger.getKey()) != null;
        if (!triggerExists) {
            try {
                this.getScheduler().scheduleJob(trigger);
            }
            catch (ObjectAlreadyExistsException ex) {
                this.getScheduler().rescheduleJob(trigger.getKey(), trigger);
            }
        } else {
            this.getScheduler().rescheduleJob(trigger.getKey(), trigger);
        }
    }

    private Scheduler getScheduler() {
        return KSBServiceLocator.getScheduler();
    }

    private UserOptionsService getUserOptionsService() {
        return KEWServiceLocator.getUserOptionsService();
    }

    protected ActionListService getActionListService() {
        return KEWServiceLocator.getActionListService();
    }

    public String getDeploymentEnvironment() {
        return this.deploymentEnvironment;
    }

    public void setDeploymentEnvironment(String deploymentEnvironment) {
        this.deploymentEnvironment = deploymentEnvironment;
    }

    protected String getActionListUrl() {
        return ConfigContext.getCurrentContextConfig().getProperty("workflow.url") + "/ActionList.do";
    }

    protected String getPreferencesUrl() {
        return ConfigContext.getCurrentContextConfig().getProperty("workflow.url") + "/Preferences.do";
    }
}

