/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.messaging;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class ParameterTranslator {
    private static final String SLASH_REGEXP = "\\\\";
    private static final String SLASH_ESCAPE = "\\\\";
    private static final String COMMA_REGEXP = ",";
    private static final String COMMA_ESCAPE = "\\,";
    private String untranslatedString = "";

    public ParameterTranslator() {
    }

    public ParameterTranslator(String untranslatedString) {
        this.untranslatedString = untranslatedString;
    }

    public void addParameter(String value) {
        if (!StringUtils.isEmpty((String)this.untranslatedString)) {
            this.untranslatedString = this.untranslatedString + COMMA_REGEXP;
        }
        this.untranslatedString = this.untranslatedString + this.escape(value);
    }

    private String escape(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        value = value.replaceAll("\\\\", "\\\\");
        value = value.replaceAll(COMMA_REGEXP, COMMA_ESCAPE);
        return value;
    }

    public String getUntranslatedString() {
        return this.untranslatedString;
    }

    public String[] getParameters() {
        ArrayList<String> strings = new ArrayList<String>();
        boolean isEscaped = false;
        StringBuffer buffer = null;
        for (int index = 0; index < this.untranslatedString.length(); ++index) {
            char character = this.untranslatedString.charAt(index);
            if (isEscaped) {
                isEscaped = false;
                if (buffer == null) {
                    buffer = new StringBuffer();
                }
                buffer.append(character);
                continue;
            }
            if (character == '\\') {
                isEscaped = true;
                continue;
            }
            if (character == ',') {
                strings.add(buffer.toString());
                buffer = null;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            buffer.append(character);
        }
        if (buffer != null) {
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[0]);
    }
}

