/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.rules.ui;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.rule.event.ui.AddGroupEvent;
import org.kuali.rice.kim.rule.ui.AddGroupRule;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class PersonDocumentGroupRule
extends DocumentRuleBase
implements AddGroupRule {
    protected static final String NEW_GROUP = "newGroup";
    protected static final String GROUP_ID_ERROR_PATH = "newGroup.groupId";

    @Override
    public boolean processAddGroup(AddGroupEvent addGroupEvent) {
        IdentityManagementPersonDocument document = (IdentityManagementPersonDocument)addGroupEvent.getDocument();
        PersonDocumentGroup newGroup = addGroupEvent.getGroup();
        boolean rulePassed = true;
        rulePassed = this.validAssignGroup(document, newGroup);
        if (newGroup == null || StringUtils.isBlank((String)newGroup.getGroupId())) {
            rulePassed = false;
            GlobalVariables.getMessageMap().putError(GROUP_ID_ERROR_PATH, "error.empty.entry", new String[]{"Group"});
        } else {
            for (PersonDocumentGroup group : document.getGroups()) {
                if (!group.getGroupId().equals(newGroup.getGroupId())) continue;
                rulePassed = false;
                GlobalVariables.getMessageMap().putError(GROUP_ID_ERROR_PATH, "error.duplicate.entry", new String[]{"Group"});
            }
        }
        return rulePassed;
    }

    protected boolean validAssignGroup(IdentityManagementPersonDocument document, PersonDocumentGroup newGroup) {
        boolean rulePassed = true;
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("namespaceCode", newGroup.getNamespaceCode());
        additionalPermissionDetails.put("groupName", newGroup.getGroupName());
        if (!PersonDocumentGroupRule.getDocumentDictionaryService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Populate Group", GlobalVariables.getUserSession().getPrincipalId(), additionalPermissionDetails, null)) {
            GlobalVariables.getMessageMap().putError(GROUP_ID_ERROR_PATH, "error.assign.group", new String[]{newGroup.getNamespaceCode(), newGroup.getGroupName()});
            rulePassed = false;
        }
        return rulePassed;
    }
}

