/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionlist.dao;

import java.util.List;

import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;


/**
 * Data Access object for the Action List.
 *
 * @see ActionItem
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ActionListDAO {

    /**
     * Get the total count of items in the given person's action list.
     */
    public int getCount(String principalId);

    /**
     * Get the maximum last action taken date and total count for items in the person's action list.
     *
     * This is used to help with the action list caching and detection of changes.
     */
    public List<Object> getMaxActionItemDateAssignedAndCountForUser(String principalId);

    /**
     * Pulls a proxied version of the document route header with only the properties needed by the
     * action list display.
     */
    DocumentRouteHeaderValue getMinimalRouteHeader( String documentId );
}
