/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actions;

import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

import java.util.List;


/**
 * Simply records an action taken with an annotation.  
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class LogDocumentActionAction extends ActionTakenEvent {

    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(LogDocumentActionAction.class);

    /**
     * @param rh RouteHeader for the document upon which the action is taken.
     * @param principal User taking the action.
     */
    public LogDocumentActionAction(DocumentRouteHeaderValue rh, PrincipalContract principal) {
        super(KewApiConstants.ACTION_TAKEN_LOG_DOCUMENT_ACTION_CD, rh, principal);
    }

    /**
     * @param rh RouteHeader for the document upon which the action is taken.
     * @param principal User taking the action.
     * @param annotation User comment on the action taken
     */
    public LogDocumentActionAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation) {
        super(KewApiConstants.ACTION_TAKEN_LOG_DOCUMENT_ACTION_CD, rh, principal, annotation);
    }

    /* (non-Javadoc)
     * @see org.kuali.rice.kew.actions.ActionTakenEvent#validateActionRules()
     */
    @Override
    public String validateActionRules() {
        // log action is always valid so return no error message
        return "";
    }

    /**
     * Records the non-routed document action. - Checks to make sure the document status allows the action. Records the action.
     * 
     * @throws InvalidActionTakenException
     */
    @Override
    public void recordAction() throws InvalidActionTakenException {
        ThreadContext.put("docId", getRouteHeader().getDocumentId());

        String errorMessage = validateActionRules();
        if (!org.apache.commons.lang.StringUtils.isEmpty(errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }

        LOG.debug("Logging document action");
        ActionTakenValue actionTaken = saveActionTaken(Boolean.TRUE);
        // LogDocumentAction should not contact the PostProcessor which is why we don't call notifyActionTaken
       
    }

	@Override
	public String validateActionRules(List<ActionRequestValue> actionRequests) {
        // log action is always valid so return no error message
		return "";
	}
}
