/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.docsearch;

import org.joda.time.DateTime;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;


/**
 * Defines an externalizable business object interface for workflow documents.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */

// TODO map to DocSearchCriteriaBo
public interface DocumentSearchCriteriaEbo extends ExternalizableBusinessObject {

	public String getApplicationDocumentId();

	public DocumentStatus getStatus();

	public String getApplicationDocumentStatus();
	
	public String getTitle();

	public String getDocumentTypeName();

	public String getInitiatorPrincipalId();

	public String getDocumentId();

	public DateTime getDateCreated();

}
