/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node.service;

import java.util.List;

import org.kuali.rice.kew.engine.node.Branch;

/**
 * A service providing data access for {@link Branch} instances.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface BranchService {
    public void save(Branch branch);    
    public void deleteBranchStates(List statesToBeDeleted);
    /**
     * Responsible for inspecting the branch hierarchy/scope and returning a value
     * for the variable name if it exists somewere in scope. 
     * @param branch the lowermost scope to start resolution
     * @return a value for the key if it exists somewere in scope
     */
    public String getScopedVariableValue(Branch branch, String name);
    /**
     * Responsible for setting a value in the branch hierarchy/scope.  If the variable name
     * exists in a scope, it will be updated as opposed to created in a lower scope.  
     * @param branch the lowermost scope to start resolution
     * @param value the value to set for the variable
     * @return the replaced value of the variable, if the variable was already defined, or null otherwise
     */
    public String setScopedVariableValue(Branch branch, String name, String value);
}
