/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.transition;

import org.kuali.rice.kew.engine.node.RouteNodeInstance;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a transition to a set of Node Instances.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class Transition {

	private List<RouteNodeInstance> nextNodeInstances = new ArrayList<RouteNodeInstance>();
	
	public Transition() {
	}
	
	public Transition(List<RouteNodeInstance> nextNodeInstances) throws Exception {
        this.nextNodeInstances = nextNodeInstances;
	}

	public List<RouteNodeInstance> getNextNodeInstances() {
		return nextNodeInstances;
	}

	protected void setNextNodeInstances(List<RouteNodeInstance> nextNodeInstances) {
		this.nextNodeInstances = nextNodeInstances;
	}
	
}
