/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.transition;

import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;

/**
 * Factory which creates a {@link TransitionEngine} for the given {@link RouteNodeInstance}.  The 
 * transition engine is determined based on the type of the node instance.
 * 
 * @see TransitionEngine
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class TransitionEngineFactory {

	public static TransitionEngine createTransitionEngine(RouteNodeInstance nodeInstance) throws Exception {
		RouteHelper helper = new RouteHelper();
		RouteNode routeNode = nodeInstance.getRouteNode();
		TransitionEngine engine = null;
		if (helper.isSimpleNode(routeNode)) {
			engine = new SimpleTransitionEngine();
		} else if (helper.isSplitNode(routeNode)) {
			engine = new SplitTransitionEngine();
		} else if (helper.isJoinNode(routeNode)) {
			engine = new JoinTransitionEngine();
		} else if (helper.isDynamicNode(routeNode)) {
			engine = new DynamicTransitionEngine();
		} else if (helper.isSubProcessNode(routeNode)) {
			engine = new SubProcessTransitionEngine();
		} else {
			throw new WorkflowException("Could not locate transition engine for node " + routeNode.getNodeType());
		}
		engine.setRouteHelper(helper);
		return engine;
	}
	
}
