/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.kuali.rice.krad.util.MessageMap;



/**
 * <p>Title: DocElementError </p>
 * <p>Description: A simple object holding any error(s) generated by
 * an IDocElement and it's children IDocElements.  See IDocElement
 * documentation for further explanation.</p>
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class WorkflowServiceErrorImpl implements Serializable, WorkflowServiceError {

	private static final String CHILDREN_IN_ERROR = "-1";

  static final long serialVersionUID = 6900090941686297017L;
  private Collection children;
  private String type;
  private String message;
  private String arg1;
  private String arg2;
  
  /**
   * Passing the actual message map around so we don't lose doc search messages in standalone.
   */
  private MessageMap messageMap;



  private WorkflowServiceErrorImpl() {
  }

  public WorkflowServiceErrorImpl(String message, String type) {
    children = new ArrayList();
    this.message = message;
    this.type = type;
  }

  public WorkflowServiceErrorImpl(String message, String type, String arg1) {
      children = new ArrayList();
      this.message = message;
      this.type = type;
      this.arg1 = arg1;
  }

  public WorkflowServiceErrorImpl(String message, String type, String arg1, String arg2) {
      children = new ArrayList();
      this.message = message;
      this.type = type;
      this.arg1 = arg1;
      this.arg2 = arg2;
  }
  public WorkflowServiceErrorImpl(String message, String type, String arg1, String arg2, MessageMap messageMap) {
      children = new ArrayList();
      this.message = message;
      this.type = type;
      this.arg1 = arg1;
      this.arg2 = arg2;
      this.messageMap = messageMap;
  }

  @Override
  public Collection getChildren() {
    return this.children;
  }

  @Override
  public String getMessage() {
    return this.message;
  }

  @Override
  public String getKey() {
    return this.type;
  }

  @Override
  public String getArg1() {
    return arg1;
  }

  @Override
  public String getArg2() {
    return arg2;
  }

  @Override
  public void addChild(WorkflowServiceError busError) {
    if (busError != null) {
      children.add(busError);
    }
  }

  @Override
  public void addChildren(Collection children) {
    this.children.addAll(children);
  }

  @Override
  public Collection getFlatChildrenList() {
    return buildFlatChildrenList(this, null);
  }

  private static Collection buildFlatChildrenList(WorkflowServiceError error, List flatList) {
    if (flatList == null) {
      flatList = new ArrayList();
    }

    if (error.getKey() != CHILDREN_IN_ERROR) {
      flatList.add(error);
    }

    Iterator iter = error.getChildren().iterator();

    while (iter.hasNext()) {
      WorkflowServiceError childError = (WorkflowServiceError) iter.next();
      buildFlatChildrenList(childError, flatList);
    }

    return flatList;
  }

  @Override
  public String toString() {
    String s = "[WorkflowServiceErrorImpl: type=" + type + ", message=" + message + ", arg1=" + arg1 + ", arg2=" + arg2 + ", children=";
    if (children == null) {
        s += "null";
    } else {
        s += children;
    }
    s += "]";
    return s;
  }

  /**
   * @return the messageMap
   */
  @Override
  public MessageMap getMessageMap() {
  	return this.messageMap;
  }

  /**
   * @param messageMap the messageMap to set
   */
  public void setMessageMap(MessageMap messageMap) {
  	this.messageMap = messageMap;
  }
}
