/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.document;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

import javax.xml.namespace.QName;

final class DocumentProcessingQueueAsyncCapableImpl implements DocumentProcessingQueue {

    private final AsyncCapableService asyncCapableService;
    private final DocumentProcessingQueue documentProcessingQueue;
    private final QName qname;
    private final String applicationId;

    DocumentProcessingQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, DocumentProcessingQueue documentProcessingQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }

        if (documentProcessingQueue == null) {
            throw new IllegalArgumentException("documentProcessingQueue is null");
        }

        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }

        this.asyncCapableService = asyncCapableService;
        this.documentProcessingQueue = documentProcessingQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    @Override
    public void process(String documentId) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, documentId, null, new CallMetadata("process", new Class[]{String.class}, new Object[]{documentId}),
                () -> documentProcessingQueue.process(documentId));
    }

    @Override
    public void processWithOptions(String documentId, DocumentProcessingOptions options) throws RiceIllegalArgumentException {
        asyncCapableService.executeCall(qname, applicationId, documentId, options != null ? options.toString() : null,
                new CallMetadata("processWithOptions", new Class[]{String.class, DocumentProcessingOptions.class }, new Object[]{documentId, options}),
                () -> documentProcessingQueue.processWithOptions(documentId, options));
    }
}
