/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.notes.service;

import java.util.List;

import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.Note;

/**
 * A service which handles data access for notes and attachments.
 * 
 * @see Note
 * @see Attachment
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface NoteService {

    public Note getNoteByNoteId(String noteId);
    public List<Note> getNotesByDocumentId(String documentId);
    public Note saveNote(Note note);
    public void deleteNote(Note note);
    public void deleteAttachment(Attachment attachment);
    public byte[] findAttachmentFile(Attachment attachment);
    public Attachment findAttachment(String attachmentId);
    
}
