/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.group.GroupBo;

/**
 * Represents a rule responsibility which points to a group.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class GroupRuleResponsibility extends RuleResponsibilityBo {
    protected Group group;
	private String namespaceCode;
	private String name;

	public String getNamespaceCode() {
		return this.namespaceCode;
	}

	public void setNamespaceCode(String namespaceCode) {
		this.namespaceCode = namespaceCode;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

    @Override
	public Group getGroup() {
        if (this.group == null) {
	        this.group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(getNamespaceCode(),
                    getName());
        }
        return this.group;
	}

    public GroupBo getGroupBo() {
        Group grp = null;
        if (isUsingGroup()) {
            grp = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(getNamespaceCode(),getName());
        }
        if(null != grp){
            return GroupBo.from(grp);
        }  else {
            return null;
        }
    }
}
