/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import org.kuali.rice.kew.engine.RouteContext;

/**
 * A rule is an entity that can be evaluated at runtime to generate a list of {@link RuleResponsibilityBo}s
 * to which to dispatch action requests.
 * @see RuleBaseValues
 * @see RuleExpressionResult
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RuleExpression {
    /**
     * Performs an evaluation and returns a list of 0 or more {@link RuleResponsibilityBo}s to which to dispatch action requests
     * @param rule the rule that this rule expression applies to
     * @param context the RouteContext under which the expression is being evaluated
     * @return the result of the rule evaluation
     * @throws org.kuali.rice.kew.api.exception.WorkflowException
     */
    public RuleExpressionResult evaluate(Rule rule, RouteContext context);
}
