/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import java.sql.Timestamp;
import java.util.List;

import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;


/**
 * RuleSelector is responsible for selecting the rules to be evaluated for a given rule-based requests node.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RuleSelector {
    /**
     * Returns a list of rules selected given the criteria specified in the arguments.
     * 
     * @param context the RouteContext
     * @param routeHeader the DocumentRouteHeaderValue of the current document
     * @param nodeInstance the current RouteNodeInstance being executed
     * @param selectionCriterion an implementation-specific criterion passed in from the calling context
     * @param effectiveDate an optional criterion that indicates that the rules selected should be active on the given date 
     * @return a list of applicable rules, if any (null or empty list otherwise)
     * @throws org.kuali.rice.kew.api.exception.WorkflowException if anything goes awry...
     */
    /* inputs taken from FlexRM getActionRequests/makeActionRequests */
    public List<Rule> selectRules(RouteContext context, DocumentRouteHeaderValue routeHeader, RouteNodeInstance nodeInstance, String selectionCriterion, Timestamp effectiveDate);
}
