/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.bo;

import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.web.WebRuleUtils;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kns.inquiry.KualiInquirableImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;

import java.util.List;
import java.util.Map;

/**
 * Inquirable implementation for KEW routing rules.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class RuleBaseValuesInquirableImpl extends KualiInquirableImpl {

	public static final String DOCUMENT_ID = "documentId";

	@Override
	public Object retrieveDataObject(Map fieldValues){
		RuleBaseValues rule = (RuleBaseValues)super.retrieveDataObject(fieldValues);
		WebRuleUtils.populateRuleMaintenanceFields(rule);
		return rule;
    }

	@Override
    public BusinessObject getBusinessObject(Map fieldValues) {
		RuleBaseValues rule = (RuleBaseValues)super.getBusinessObject(fieldValues);
		WebRuleUtils.populateRuleMaintenanceFields(rule);
		return rule;
	}

	@Override
    public List<Section> getSections(BusinessObject bo) {
		List<Section> sections = super.getSections(bo);

		return WebRuleUtils.customizeSections((RuleBaseValues)bo, sections, false);

	}
	

    @Override
    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
    	
		if(DOCUMENT_ID.equals(attributeName)) {

			HtmlData.AnchorHtmlData link = new HtmlData.AnchorHtmlData();
			RuleBaseValues rule = (RuleBaseValues)businessObject;

			String documentId = rule.getDocumentId();
			link.setDisplayText(documentId+"");

			String href = ConfigContext.getCurrentContextConfig().getKEWBaseURL() + "/" +
			KewApiConstants.DOC_HANDLER_REDIRECT_PAGE + "?" + KewApiConstants.COMMAND_PARAMETER + "=" +
			KewApiConstants.DOCSEARCH_COMMAND + "&" + KewApiConstants.DOCUMENT_ID_PARAMETER + "=" + documentId;

			link.setHref(href);

			return link;
		}		
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

}
