/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.service;

import java.util.List;

import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.core.framework.impex.xml.XmlLoader;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.springframework.cache.annotation.CacheEvict;

/**
 * A service which provides data access for {@link org.kuali.rice.kew.rule.bo.RuleAttribute}s.
 * 
 * @see org.kuali.rice.kew.rule.bo.RuleAttribute
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RuleAttributeService extends XmlLoader, XmlExporter {

    @CacheEvict(value={ExtensionDefinition.Cache.NAME}, allEntries = true)
    public void save(RuleAttribute ruleAttribute);

    @CacheEvict(value={ExtensionDefinition.Cache.NAME}, allEntries = true)
    public void delete(String ruleAttributeId);
    public List<RuleAttribute> findByRuleAttribute(RuleAttribute ruleAttribute);
    public RuleAttribute findByRuleAttributeId(String ruleAttributeId);
    public List<RuleAttribute> findAll();
    public RuleAttribute findByName(String name);
    public List<RuleAttribute> findByClassName(String className);

    public Object loadRuleAttributeService(RuleAttribute ruleAttribute);
    
    public Object loadRuleAttributeService(RuleAttribute ruleAttribute, String defaultApplicationId);
    
}
