/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.bo.ui;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name = "KRIM_PND_AFLTN_MT")
public class PersonDocumentAffiliation extends PersonDocumentBoDefaultBase {

    private static final long serialVersionUID = 1L;

    @PortableSequenceGenerator(name = "KRIM_ENTITY_AFLTN_ID_S")
    @GeneratedValue(generator = "KRIM_ENTITY_AFLTN_ID_S")
    @Id
    @Column(name = "ENTITY_AFLTN_ID")
    protected String entityAffiliationId;

    @Column(name = "AFLTN_TYP_CD")
    protected String affiliationTypeCode;

    @Column(name = "CAMPUS_CD")
    protected String campusCode;

    @JoinFetch(value= JoinFetchType.OUTER)
    @ManyToOne(targetEntity = EntityAffiliationTypeBo.class, cascade = { CascadeType.REFRESH })
    @JoinColumn(name = "AFLTN_TYP_CD", referencedColumnName = "AFLTN_TYP_CD", insertable = false, updatable = false)
    protected EntityAffiliationTypeBo affiliationType;

    @Transient
    protected PersonDocumentEmploymentInfo newEmpInfo;

    @JoinFetch(value= JoinFetchType.OUTER)
    @OneToMany(targetEntity = PersonDocumentEmploymentInfo.class, cascade = { CascadeType.REFRESH, CascadeType.PERSIST })
    @JoinColumns({ 
        @JoinColumn(name = "FDOC_NBR", referencedColumnName = "FDOC_NBR", insertable = false, updatable = false), 
        @JoinColumn(name = "ENTITY_AFLTN_ID", referencedColumnName = "ENTITY_AFLTN_ID", insertable = false, updatable = false) })
    protected List<PersonDocumentEmploymentInfo> empInfos;

    public PersonDocumentAffiliation() {
        empInfos = new ArrayList<PersonDocumentEmploymentInfo>();
        setNewEmpInfo(new PersonDocumentEmploymentInfo());
    }

    /**
	 * @see org.kuali.rice.kim.api.identity.EntityAffiliationContract#getAffiliationTypeCode()
	 */
    public String getAffiliationTypeCode() {
        if (affiliationTypeCode == null) {
            return "";
        }
        return affiliationTypeCode;
    }

    /**
	 * @see org.kuali.rice.kim.api.identity.EntityAffiliationContract#getCampusCode()
	 */
    public String getCampusCode() {
        return campusCode;
    }

    /**
	 * @see org.kuali.rice.kim.api.identity.EntityAffiliationContract#getEntityAffiliationId()
	 */
    public String getEntityAffiliationId() {
        if (entityAffiliationId == null) {
            return "";
        }
        return entityAffiliationId;
    }

    /**
	 * @see org.kuali.rice.kim.api.identity.EntityAffiliationContract#setAffiliationTypeCode(java.lang.String)
	 */
    public void setAffiliationTypeCode(String affiliationTypeCode) {
        this.affiliationTypeCode = affiliationTypeCode;
    }

    /**
	 * @see org.kuali.rice.kim.api.identity.EntityAffiliationContract#setCampusCode(java.lang.String)
	 */
    public void setCampusCode(String campusCode) {
        this.campusCode = campusCode;
    }

    public void setEntityAffiliationId(String entityAffiliationId) {
        this.entityAffiliationId = entityAffiliationId;
    }

    public PersonDocumentEmploymentInfo getNewEmpInfo() {
        return this.newEmpInfo;
    }

    public void setNewEmpInfo(PersonDocumentEmploymentInfo newEmpInfo) {
        this.newEmpInfo = newEmpInfo;
    }

    public List<PersonDocumentEmploymentInfo> getEmpInfos() {
        return this.empInfos;
    }

    public void setEmpInfos(List<PersonDocumentEmploymentInfo> empInfos) {
        this.empInfos = empInfos;
    }

    public EntityAffiliationTypeBo getAffiliationType() {
        return this.affiliationType;
    }

    public boolean isEmploymentAffiliationType() {
        if (affiliationType == null) {
            return false;
        }
        return this.affiliationType.isEmploymentAffiliationType();
    }

    public void setAffiliationType(EntityAffiliationTypeBo affiliationType) {
        this.affiliationType = affiliationType;
    }
}
