/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rules.ui;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.RiceKeyConstants;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.rule.event.ui.AddGroupEvent;
import org.kuali.rice.kim.rule.ui.AddGroupRule;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;

import java.util.HashMap;
import java.util.Map;

public class PersonDocumentGroupRule extends DocumentRuleBase implements AddGroupRule {
    protected static final String NEW_GROUP = "newGroup";
    protected static final String GROUP_ID_ERROR_PATH = NEW_GROUP+".groupId";

	@Override
    public boolean processAddGroup(AddGroupEvent addGroupEvent) {
		IdentityManagementPersonDocument document = (IdentityManagementPersonDocument)addGroupEvent.getDocument();
		PersonDocumentGroup newGroup = addGroupEvent.getGroup();
	    boolean rulePassed = true;
	    rulePassed = validAssignGroup(document, newGroup);

        if (newGroup == null || StringUtils.isBlank(newGroup.getGroupId())) {
            rulePassed = false;
            GlobalVariables.getMessageMap().putError(GROUP_ID_ERROR_PATH, RiceKeyConstants.ERROR_EMPTY_ENTRY, new String[] {"Group"});
        	
        } else {
		    for (PersonDocumentGroup group : document.getGroups()) {
		    	if (group.getGroupId().equals(newGroup.getGroupId())) {
		            rulePassed = false;
		            GlobalVariables.getMessageMap().putError(GROUP_ID_ERROR_PATH, RiceKeyConstants.ERROR_DUPLICATE_ENTRY, new String[] {"Group"});
		    		
		    	}
		    }
        }
        

		return rulePassed;
	} 

	protected boolean validAssignGroup(IdentityManagementPersonDocument document, PersonDocumentGroup newGroup){
        boolean rulePassed = true;
        Map<String,String> additionalPermissionDetails = new HashMap<String,String>();
        additionalPermissionDetails.put(KimConstants.AttributeConstants.NAMESPACE_CODE, newGroup.getNamespaceCode());
        additionalPermissionDetails.put(KimConstants.AttributeConstants.GROUP_NAME, newGroup.getGroupName());
		if(!getDocumentDictionaryService().getDocumentAuthorizer(document).isAuthorizedByTemplate(
				document, KimConstants.NAMESPACE_CODE, KimConstants.PermissionTemplateNames.POPULATE_GROUP,
				GlobalVariables.getUserSession().getPrincipalId(), additionalPermissionDetails, null)){
    		GlobalVariables.getMessageMap().putError(GROUP_ID_ERROR_PATH, 
    				RiceKeyConstants.ERROR_ASSIGN_GROUP, 
    				new String[] {newGroup.getNamespaceCode(), newGroup.getGroupName()});
            rulePassed = false;
		}
		return rulePassed;
	}
	
}
