/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.struts.form;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.kns.service.BusinessObjectAuthorizationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

import javax.servlet.http.HttpServletRequest;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class DisplayInactivationBlockersForm extends KualiForm {
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(DisplayInactivationBlockersForm.class);

	private String businessObjectClassName;
	private Map<String, String> primaryKeyFieldValues;
	private Map<String, List<String>> blockingValues;
	
	@Override
	public void populate(HttpServletRequest request) {
		super.populate(request);
		primaryKeyFieldValues = new HashMap<String, String>();

		if (StringUtils.isBlank(businessObjectClassName)) {
			throw new IllegalArgumentException("BO Class Name missing.");
		}
		
		Class businessObjectClass = null;
		try {
			businessObjectClass = Class.forName(businessObjectClassName);
		} catch (ClassNotFoundException e) {
			LOG.error("Unable to find class: " + businessObjectClassName, e);
			throw new IllegalArgumentException("Unable to find class: " + businessObjectClassName, e);
		}
		
		if (!BusinessObject.class.isAssignableFrom(businessObjectClass)) {
			LOG.error("BO Class is not a BusinessObject: " + businessObjectClassName);
			throw new IllegalArgumentException("BO Class is not a BusinessObject: " + businessObjectClassName);
		}
		
		EncryptionService encryptionService = CoreApiServiceLocator.getEncryptionService();
		BusinessObjectAuthorizationService businessObjectAuthorizationService = KNSServiceLocator
                .getBusinessObjectAuthorizationService();
		
		List primaryKeyFieldNames = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(businessObjectClass);
		for (Iterator i = primaryKeyFieldNames.iterator(); i.hasNext();) {
			String primaryKeyFieldName = (String) i.next();
			
			String primaryKeyFieldValue = request.getParameter(primaryKeyFieldName);
			if (StringUtils.isBlank(primaryKeyFieldValue)) {
				LOG.error("Missing primary key value for: " + primaryKeyFieldName);
				throw new IllegalArgumentException("Missing primary key value for: " + primaryKeyFieldName);
			}
			
            // check if field is a secure
            if (businessObjectAuthorizationService.attributeValueNeedsToBeEncryptedOnFormsAndLinks(businessObjectClass, primaryKeyFieldName)) {
                try {
                    if(CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                	    primaryKeyFieldValue = encryptionService.decrypt(primaryKeyFieldValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error("Unable to decrypt secure field for BO " + businessObjectClassName + " field " + primaryKeyFieldName, e);
                    throw new RuntimeException("Unable to decrypt secure field for BO " + businessObjectClassName + " field " + primaryKeyFieldName, e);
                }
            }
            
			primaryKeyFieldValues.put(primaryKeyFieldName, primaryKeyFieldValue);
		}
	}

	public String getBusinessObjectClassName() {
		return this.businessObjectClassName;
	}

	public void setBusinessObjectClassName(String businessObjectClassName) {
		this.businessObjectClassName = businessObjectClassName;
	}

	public Map<String, String> getPrimaryKeyFieldValues() {
		return this.primaryKeyFieldValues;
	}

	public void setPrimaryKeyFieldValues(Map<String, String> primaryKeyFieldValues) {
		this.primaryKeyFieldValues = primaryKeyFieldValues;
	}

	public Map<String, List<String>> getBlockingValues() {
		return this.blockingValues;
	}

	public void setBlockingValues(Map<String, List<String>> blockingValues) {
		this.blockingValues = blockingValues;
	}	
}
