/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.workflow.attribute;

import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.w3c.dom.Element;

/**
 * This is an XML KEW search attribute that can be used where the XML of the attribute has an xpath expression that returns a
 * boolean. This attribute takes that boolean expression and translates it into true and false values based on the
 * {@link #getValueForXPathTrueEvaluation()} and {@link #getValueForXPathFalseEvaluation()} method's return variables.
 * 
 * NOTE: This will not longer be necessary if the version of xPath being used is every upgrade to 2.x or higher
 *
 * @deprecated Only used by KNS classes, no replacement.
 */
@Deprecated
public class KualiXMLBooleanTranslatorSearchableAttributeImpl extends KualiXmlSearchableAttributeImpl {
	private static final long serialVersionUID = -4627314389844574461L;

	public static final String VALUE_FOR_TRUE = "Yes";
	public static final String VALUE_FOR_FALSE = "No";



	/**
	 * This overridden method does the translation of the given xPath expression from the XML definition of the attribute and
	 * translates it into the true and false values based on the {@link #getValueForXPathTrueEvaluation()} and
	 * {@link #getValueForXPathFalseEvaluation()} method's return variables
	 */
	@Override
	public Element getConfigXML(ExtensionDefinition extensionDefinition) {
		String[] xpathElementsToInsert = new String[3];
		xpathElementsToInsert[0] = "concat( substring('" + getValueForXPathTrueEvaluation() + "', number(not(";
		xpathElementsToInsert[1] = "))*string-length('" + getValueForXPathTrueEvaluation() + "')+1), substring('" + getValueForXPathFalseEvaluation() + "', number(";
		xpathElementsToInsert[2] = ")*string-length('" + getValueForXPathFalseEvaluation() + "')+1))";
		Element root = super.getConfigXML(extensionDefinition);
		return new KualiXmlAttributeHelper().processConfigXML(root, xpathElementsToInsert);
	}

	public String getValueForXPathTrueEvaluation() {
		return VALUE_FOR_TRUE;
	}

	public String getValueForXPathFalseEvaluation() {
		return VALUE_FOR_FALSE;
	}

}
