/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.coreservice.api.namespace.Namespace;
import org.kuali.rice.coreservice.api.namespace.NamespaceService;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationChannelReviewerBo;
import org.kuali.rice.ken.bo.NotificationPriorityBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.ken.document.kew.NotificationWorkflowDocument;
import org.kuali.rice.ken.exception.ErrorList;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.service.NotificationRecipientService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.service.NotificationWorkflowDocumentService;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.rule.GenericAttributeContent;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.servlet.ModelAndView;

public abstract class BaseSendNotificationController {
    private static final Logger LOG = LogManager.getLogger(BaseSendNotificationController.class);
    private static final String USER_RECIPS_PARAM = "userRecipients";
    private static final String WORKGROUP_RECIPS_PARAM = "workgroupRecipients";
    private static final String WORKGROUP_NAMESPACE_CODES_PARAM = "workgroupNamespaceCodes";
    private static final String SPLIT_REGEX = "(%2C|,)";
    private static final String NONE_CHANNEL = "___NONE___";
    private static final long REASONABLE_IMMEDIATE_TIME_THRESHOLD = 300000L;
    @Autowired
    @Qualifier(value="notificationService")
    protected NotificationService notificationService;
    @Autowired
    @Qualifier(value="notificationWorkflowDocumentService")
    protected NotificationWorkflowDocumentService notificationWorkflowDocumentService;
    @Autowired
    @Qualifier(value="notificationChannelService")
    protected NotificationChannelService notificationChannelService;
    @Autowired
    @Qualifier(value="notificationRecipientService")
    protected NotificationRecipientService notificationRecipientService;
    @Autowired
    @Qualifier(value="messageContentService")
    protected NotificationMessageContentService notificationMessageContentService;
    @Autowired
    @Qualifier(value="dataObjectService")
    protected DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kimIdentityService")
    protected IdentityService identityService;
    @Autowired
    @Qualifier(value="kimGroupService")
    protected GroupService groupService;
    @Autowired
    @Qualifier(value="namespaceService")
    protected NamespaceService namespaceService;

    protected String getParameter(HttpServletRequest request, String parameterName, Map<String, Object> model, ErrorList errors, String errorMessage) {
        String parameter = request.getParameter(parameterName);
        if (StringUtils.isNotEmpty((String)parameter)) {
            model.put(parameterName, parameter);
        } else {
            errors.addError(errorMessage);
        }
        return parameter;
    }

    protected String getParameter(HttpServletRequest request, String parameterName, Map<String, Object> model, ErrorList errors, String errorMessage, String defaultValue) {
        String parameter = StringUtils.defaultIfBlank((String)request.getParameter(parameterName), (String)defaultValue);
        if (StringUtils.isNotEmpty((String)parameter)) {
            model.put(parameterName, parameter);
        } else {
            errors.addError(errorMessage);
        }
        return parameter;
    }

    protected String[] getParameterList(HttpServletRequest request, String parameterName, Map<String, Object> model, ErrorList errors, String errorMessage) {
        String parameter = request.getParameter(parameterName);
        String[] senders = null;
        if (StringUtils.isNotEmpty((String)parameter)) {
            senders = StringUtils.split((String)parameter, (String)",");
            model.put(parameterName, parameter);
        } else {
            errors.addError(errorMessage);
        }
        return senders;
    }

    protected Date getDate(String parameter, ErrorList errors, String errorMessage) {
        Date date = null;
        try {
            date = Util.parseUIDateTime(parameter);
        }
        catch (ParseException pe) {
            errors.addError(errorMessage);
        }
        return date;
    }

    protected String[] parseUserRecipients(HttpServletRequest request) {
        return this.parseCommaSeparatedValues(request, USER_RECIPS_PARAM);
    }

    protected String[] parseWorkgroupRecipients(HttpServletRequest request) {
        return this.parseCommaSeparatedValues(request, WORKGROUP_RECIPS_PARAM);
    }

    protected String[] parseWorkgroupNamespaceCodes(HttpServletRequest request) {
        return this.parseCommaSeparatedValues(request, WORKGROUP_NAMESPACE_CODES_PARAM);
    }

    protected String[] parseCommaSeparatedValues(HttpServletRequest request, String param) {
        String vals = request.getParameter(param);
        if (vals != null) {
            String[] split = vals.split(SPLIT_REGEX);
            ArrayList<String> strs = new ArrayList<String>();
            for (String component : split) {
                if (!StringUtils.isNotBlank((String)component)) continue;
                strs.add(component.trim());
            }
            return strs.toArray(new String[strs.size()]);
        }
        return new String[0];
    }

    protected boolean isUserRecipientValid(String user, ErrorList errors) {
        boolean valid = true;
        Principal principal = this.getIdentityService().getPrincipalByPrincipalName(user);
        if (principal == null) {
            valid = false;
            errors.addError("'" + user + "' is not a valid principal name");
        }
        return valid;
    }

    protected boolean isWorkgroupRecipientValid(String groupName, String namespaceCode, ErrorList errors) {
        Namespace nSpace = this.getNamespaceService().getNamespace(namespaceCode);
        if (nSpace == null) {
            errors.addError('\'' + namespaceCode + "' is not a valid namespace code");
            return false;
        }
        Group i = this.getGroupService().getGroupByNamespaceCodeAndName(namespaceCode, groupName);
        if (i == null) {
            errors.addError('\'' + groupName + "' is not a valid group name for namespace code '" + namespaceCode + '\'');
            return false;
        }
        return true;
    }

    protected String getPrincipalIdFromIdOrName(String principalIdOrName) {
        Principal principal = this.getIdentityService().getPrincipal(principalIdOrName);
        if (principal == null) {
            principal = this.getIdentityService().getPrincipalByPrincipalName(principalIdOrName);
        }
        if (principal == null) {
            throw new RiceIllegalArgumentException("Could not locate a principal as initiator with the given remoteUser of " + principalIdOrName);
        }
        return principal.getPrincipalId();
    }

    protected ModelAndView submitNotificationMessage(HttpServletRequest request, String routeMessage, String viewName) {
        LOG.debug("remoteUser: " + request.getRemoteUser());
        String initiatorId = this.getPrincipalIdFromIdOrName(request.getRemoteUser());
        LOG.debug("initiatorId: " + initiatorId);
        HashMap<String, Object> model = new HashMap<String, Object>();
        try {
            WorkflowDocument document = this.createNotificationWorkflowDocument(request, initiatorId, model);
            document.route(routeMessage + initiatorId);
            ErrorList el = new ErrorList();
            el.addError("Notification(s) sent.");
            model.put("errors", el);
        }
        catch (ErrorList el) {
            Map<String, Object> model2 = this.setupModelForSendNotification(request);
            model.putAll(model2);
            model.put("errors", el);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ModelAndView(viewName, model);
    }

    protected WorkflowDocument createNotificationWorkflowDocument(HttpServletRequest request, String initiatorId, Map<String, Object> model) throws IllegalArgumentException, ErrorList {
        WorkflowDocument document = NotificationWorkflowDocument.createNotificationDocument(initiatorId, "SendNotificationRequest");
        NotificationBo notification = this.populateNotificationInstance(request, model);
        String notificationAsXml = this.notificationMessageContentService.generateNotificationMessage(notification);
        HashMap<String, String> attrFields = new HashMap<String, String>();
        List<NotificationChannelReviewerBo> reviewers = notification.getChannel().getReviewers();
        int ui = 0;
        int gi = 0;
        for (NotificationChannelReviewerBo reviewer : reviewers) {
            int index;
            String prefix;
            if (KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode().equals(reviewer.getReviewerType())) {
                prefix = "user";
                index = ui++;
            } else if (KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode().equals(reviewer.getReviewerType())) {
                prefix = "group";
                index = gi++;
            } else {
                LOG.error("Invalid type for reviewer " + reviewer.getReviewerId() + ": " + reviewer.getReviewerType());
                continue;
            }
            attrFields.put(prefix + index, reviewer.getReviewerId());
        }
        GenericAttributeContent gac = new GenericAttributeContent("channelReviewers");
        document.setApplicationContent(notificationAsXml);
        document.setAttributeContent("<attributeContent>" + gac.generateContent(attrFields) + "</attributeContent>");
        document.setTitle(notification.getTitle());
        return document;
    }

    protected NotificationBo populateNotificationInstance(HttpServletRequest request, Map<String, Object> model) throws IllegalArgumentException, ErrorList {
        return this.createNotification(request, model, new ErrorList());
    }

    protected NotificationBo createNotification(HttpServletRequest request, Map<String, Object> model, ErrorList errors) throws ErrorList {
        String channelName = this.getChannelName(request, model, errors);
        String priorityName = this.getParameter(request, "priorityName", model, errors, "You must choose a priority.");
        String[] senders = this.getParameterList(request, "senderNames", model, errors, "You must enter at least one sender.");
        String deliveryType = this.getDeliveryType(request, model, errors);
        Date originalDate = this.getDate(request.getParameter("originalDateTime"), errors, "Original date is invalid.");
        String sendDateTime = StringUtils.defaultIfBlank((String)request.getParameter("sendDateTime"), (String)Util.getCurrentDateTime());
        Date sendDate = this.getDate(sendDateTime, errors, "You specified an invalid Send Date/Time.  Please use the calendar picker.");
        if (sendDate != null && sendDate.before(originalDate)) {
            errors.addError("Send Date/Time cannot be in the past.");
        }
        model.put("sendDateTime", sendDateTime);
        String autoRemoveDateTime = request.getParameter("autoRemoveDateTime");
        Date removeDate = this.getDate(autoRemoveDateTime, errors, "You specified an invalid Auto-Remove Date/Time.  Please use the calendar picker.");
        if (removeDate != null) {
            if (removeDate.before(originalDate)) {
                errors.addError("Auto-Remove Date/Time cannot be in the past.");
            } else if (sendDate != null && removeDate.before(sendDate)) {
                errors.addError("Auto-Remove Date/Time cannot be before the Send Date/Time.");
            }
        }
        model.put("autoRemoveDateTime", autoRemoveDateTime);
        String[] userRecipients = this.parseUserRecipients(request);
        String[] workgroupRecipients = this.parseWorkgroupRecipients(request);
        String[] workgroupNamespaceCodes = this.parseWorkgroupNamespaceCodes(request);
        String title = this.getParameter(request, "title", model, errors, "You must fill in a title.");
        if (!errors.getErrors().isEmpty()) {
            throw errors;
        }
        return this.createNotification(title, deliveryType, sendDate, removeDate, channelName, priorityName, senders, userRecipients, workgroupRecipients, workgroupNamespaceCodes, errors);
    }

    private NotificationBo createNotification(String title, String deliveryType, Date sendDate, Date removeDate, String channelName, String priorityName, String[] senders, String[] userRecipients, String[] workgroupRecipients, String[] workgroupNamespaceCodes, ErrorList errors) throws ErrorList {
        NotificationBo notification = new NotificationBo();
        notification.setTitle(title);
        notification.setDeliveryType(deliveryType);
        notification.setSendDateTimeValue(new Timestamp(sendDate.getTime()));
        notification.setAutoRemoveDateTimeValue(new Timestamp(removeDate.getTime()));
        NotificationChannelBo channel = (NotificationChannelBo)((Object)Util.retrieveFieldReference("channel", "name", channelName, NotificationChannelBo.class, this.dataObjectService));
        notification.setChannel(channel);
        NotificationPriorityBo priority = (NotificationPriorityBo)((Object)Util.retrieveFieldReference("priority", "name", priorityName, NotificationPriorityBo.class, this.dataObjectService));
        notification.setPriority(priority);
        NotificationProducerBo producer = (NotificationProducerBo)((Object)Util.retrieveFieldReference("producer", "name", "Notification System", NotificationProducerBo.class, this.dataObjectService));
        notification.setProducer(producer);
        for (String senderName : senders) {
            if (StringUtils.isEmpty((String)senderName)) {
                errors.addError("A sender's name cannot be blank.");
                continue;
            }
            NotificationSenderBo ns = new NotificationSenderBo();
            ns.setSenderName(senderName.trim());
            notification.addSender(ns);
        }
        if (userRecipients != null && userRecipients.length > 0) {
            for (String userRecipientId : userRecipients) {
                if (!this.isUserRecipientValid(userRecipientId, errors)) continue;
                NotificationRecipientBo recipient = new NotificationRecipientBo();
                recipient.setRecipientType(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
                recipient.setRecipientId(userRecipientId);
                notification.addRecipient(recipient);
            }
        }
        if (workgroupRecipients != null && workgroupRecipients.length > 0) {
            if (workgroupNamespaceCodes != null && workgroupNamespaceCodes.length > 0) {
                if (workgroupNamespaceCodes.length == workgroupRecipients.length) {
                    for (int i = 0; i < workgroupRecipients.length; ++i) {
                        if (!this.isWorkgroupRecipientValid(workgroupRecipients[i], workgroupNamespaceCodes[i], errors)) continue;
                        NotificationRecipientBo recipient = new NotificationRecipientBo();
                        recipient.setRecipientType(KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode());
                        recipient.setRecipientId(this.getGroupService().getGroupByNamespaceCodeAndName(workgroupNamespaceCodes[i], workgroupRecipients[i]).getId());
                        notification.addRecipient(recipient);
                    }
                } else {
                    errors.addError("The number of groups must match the number of namespace codes");
                }
            } else {
                errors.addError("You must specify a namespace code for every group name");
            }
        } else if (workgroupNamespaceCodes != null && workgroupNamespaceCodes.length > 0) {
            errors.addError("You must specify a group name for every namespace code");
        }
        if (!this.recipientsExist(userRecipients, workgroupRecipients) && !this.hasPotentialRecipients(notification)) {
            errors.addError("You must specify at least one user or group recipient.");
        }
        notification.setContent("<content xmlns=\"ns:notification/ContentTypeSimple\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"ns:notification/ContentTypeSimple resource:notification/ContentTypeSimple\"><message><![CDATA[]]></message></content>");
        return notification;
    }

    private String getChannelName(HttpServletRequest request, Map<String, Object> model, ErrorList errors) {
        String channelName = request.getParameter("channelName");
        if (StringUtils.isEmpty((String)channelName) || StringUtils.equals((String)channelName, (String)NONE_CHANNEL)) {
            errors.addError("You must choose a channel.");
        } else {
            model.put("channelName", channelName);
        }
        return channelName;
    }

    private String getDeliveryType(HttpServletRequest request, Map<String, Object> model, ErrorList errors) {
        String deliveryType = request.getParameter("deliveryType");
        if (StringUtils.isNotEmpty((String)deliveryType)) {
            deliveryType = deliveryType.equalsIgnoreCase("FYI") ? "FYI" : "ACK";
            model.put("deliveryType", deliveryType);
        } else {
            errors.addError("You must choose a delivery type.");
        }
        return deliveryType;
    }

    protected Map<String, Object> setupModelForSendNotification(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("defaultSender", request.getRemoteUser());
        model.put("channels", this.notificationChannelService.getAllNotificationChannels());
        model.put("priorities", this.dataObjectService.findMatching(NotificationPriorityBo.class, QueryByCriteria.Builder.create().build()).getResults());
        String sendDateTime = request.getParameter("sendDateTime");
        String currentDateTime = Util.getCurrentDateTime();
        if (StringUtils.isEmpty((String)sendDateTime)) {
            sendDateTime = currentDateTime;
        }
        model.put("sendDateTime", sendDateTime);
        if (request.getParameter("originalDateTime") == null) {
            model.put("originalDateTime", currentDateTime);
        } else {
            model.put("originalDateTime", request.getParameter("originalDateTime"));
        }
        model.put(USER_RECIPS_PARAM, request.getParameter(USER_RECIPS_PARAM));
        model.put(WORKGROUP_RECIPS_PARAM, request.getParameter(WORKGROUP_RECIPS_PARAM));
        model.put(WORKGROUP_NAMESPACE_CODES_PARAM, request.getParameter(WORKGROUP_NAMESPACE_CODES_PARAM));
        return model;
    }

    private boolean timeIsInTheFuture(long time) {
        boolean future = time - System.currentTimeMillis() > 300000L;
        LOG.info("Time: " + String.valueOf(new Date(time)) + " is in the future? " + future);
        return future;
    }

    private boolean recipientsExist(String[] userRecipients, String[] workgroupRecipients) {
        return userRecipients != null && userRecipients.length > 0 || workgroupRecipients != null && workgroupRecipients.length > 0;
    }

    private boolean hasPotentialRecipients(NotificationBo notification) {
        LOG.info("notification channel " + String.valueOf((Object)notification.getChannel()) + " is subscribable: " + notification.getChannel().isSubscribable());
        return !notification.getChannel().getRecipientLists().isEmpty() || !notification.getChannel().getSubscriptions().isEmpty() || notification.getChannel().isSubscribable() && this.timeIsInTheFuture(notification.getSendDateTimeValue().getTime());
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public NotificationWorkflowDocumentService getNotificationWorkflowDocumentService() {
        return this.notificationWorkflowDocumentService;
    }

    public void setNotificationWorkflowDocumentService(NotificationWorkflowDocumentService notificationWorkflowDocumentService) {
        this.notificationWorkflowDocumentService = notificationWorkflowDocumentService;
    }

    public NotificationChannelService getNotificationChannelService() {
        return this.notificationChannelService;
    }

    public void setNotificationChannelService(NotificationChannelService notificationChannelService) {
        this.notificationChannelService = notificationChannelService;
    }

    public NotificationRecipientService getNotificationRecipientService() {
        return this.notificationRecipientService;
    }

    public void setNotificationRecipientService(NotificationRecipientService notificationRecipientService) {
        this.notificationRecipientService = notificationRecipientService;
    }

    public NotificationMessageContentService getNotificationMessageContentService() {
        return this.notificationMessageContentService;
    }

    public void setNotificationMessageContentService(NotificationMessageContentService notificationMessageContentService) {
        this.notificationMessageContentService = notificationMessageContentService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }
}

