/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.quicklinks.web;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.quicklinks.service.QuickLinksService;
import org.kuali.rice.kew.quicklinks.web.QuickLinksForm;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuickLinksAction
extends KewKualiAction {
    private static final Logger LOG = LogManager.getLogger(QuickLinksAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initForm(request, form);
        return super.execute(mapping, form, request, response);
    }

    public void initForm(HttpServletRequest request, ActionForm form) throws Exception {
        QuickLinksForm quickLinksForm = (QuickLinksForm)form;
        String principalId = QuickLinksAction.getUserSession().getPrincipalId();
        LOG.debug("getting Action List Stats");
        quickLinksForm.setActionListStats(this.getQuickLinksService().getActionListStats(principalId));
        LOG.debug("finished getting Action List Stats");
        LOG.debug("getting Initiated Document Types");
        quickLinksForm.setInitiatedDocumentTypes(this.getQuickLinksService().getInitiatedDocumentTypesList(principalId));
        LOG.debug("finished getting Initiated Document Types");
        LOG.debug("getting Named Searches");
        ArrayList<KeyValue> namedSearches = new ArrayList<KeyValue>();
        namedSearches.addAll(this.getQuickLinksService().getNamedSearches(principalId));
        quickLinksForm.setNamedSearches(namedSearches);
        request.setAttribute("namedSearches", namedSearches);
        LOG.debug("finished getting Named Searches");
        LOG.debug("getting Recent Searches");
        quickLinksForm.setRecentSearches(this.getQuickLinksService().getRecentSearches(principalId));
        LOG.debug("finished getting Recent Searches");
        LOG.debug("getting Watched Documents");
        quickLinksForm.setWatchedDocuments(this.getQuickLinksService().getWatchedDocuments(principalId));
        LOG.debug("finished getting Watched Documents");
    }

    private QuickLinksService getQuickLinksService() {
        return (QuickLinksService)KEWServiceLocator.getService("enQuickLinksService");
    }

    private static UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }
}

