/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.web;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.rule.web.WebRuleBaseValues;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class WebRuleResponsibility
extends RuleResponsibilityBo {
    private static final long serialVersionUID = -8422695726158274189L;
    private static final String DISPLAY_INLINE = "display:inline";
    private static final String DISPLAY_NONE = "display:none";
    private String reviewer;
    private String reviewerStyle = "";
    private String personLookupStyle = "";
    private String workgroupLookupStyle = "";
    private String roleReviewer;
    private String roleAreaStyle = "";
    private boolean delegationRulesMaterialized = false;
    private boolean showDelegations = false;
    private int numberOfDelegations;
    private int index = 0;
    private boolean hasDelegateRuleTemplate = false;
    private String reviewerId;

    public String getReviewerId() {
        return this.reviewerId;
    }

    public void setReviewerId(String reviewerId) {
        this.reviewerId = reviewerId;
    }

    public WebRuleResponsibility() {
        this.setRuleResponsibilityType("F");
        this.setApprovePolicy(ActionRequestPolicy.FIRST.getCode());
    }

    public void initialize() throws Exception {
        if (this.getDelegationRules().size() <= Integer.parseInt(CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Rule", "DELEGATE_LIMIT"))) {
            this.showDelegations = true;
        }
        this.setNumberOfDelegations(this.getDelegationRules().size());
        if (this.delegationRulesMaterialized) {
            for (RuleDelegationBo ruleDelegation : this.getDelegationRules()) {
                WebRuleBaseValues webRule = (WebRuleBaseValues)ruleDelegation.getDelegationRule();
                webRule.initialize();
            }
        }
        this.establishRequiredState();
    }

    private void loadWebValues() throws Exception {
        if (!StringUtils.isEmpty((String)this.getRuleResponsibilityName())) {
            if ("F".equals(this.getRuleResponsibilityType())) {
                Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(this.getRuleResponsibilityName());
                this.setReviewer(principal.getPrincipalName());
                this.setReviewerId(principal.getPrincipalId());
            } else if ("G".equals(this.getRuleResponsibilityType())) {
                Group group = KimApiServiceLocator.getGroupService().getGroup(this.getRuleResponsibilityName());
                this.setReviewer(group.getName());
                this.setReviewerId(group.getId());
            } else if ("R".equals(this.getRuleResponsibilityType())) {
                this.setRoleReviewer(this.getRuleResponsibilityName());
                this.setReviewer(this.getResolvedRoleName());
            }
        }
    }

    private void injectWebMembers() throws Exception {
        DelegationRulesProxy delegationRulesProxy = new DelegationRulesProxy(this.getDelegationRules());
        Class<?> delegationRulesClass = this.getDelegationRules().getClass();
        Class[] delegationRulesInterfaces = new Class[]{};
        List delegationRulesInterfaceList = ClassUtils.getAllInterfaces(delegationRulesClass);
        delegationRulesInterfaces = delegationRulesInterfaceList.toArray(delegationRulesInterfaces);
        ClassLoader delegationRulesClassLoader = this.getDelegationRules().getClass().getClassLoader();
        Object o = Proxy.newProxyInstance(delegationRulesClassLoader, delegationRulesInterfaces, (InvocationHandler)delegationRulesProxy);
        if (Integer.parseInt(CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Rule", "DELEGATE_LIMIT")) > this.getDelegationRules().size() || this.showDelegations) {
            for (RuleDelegationBo ruleDelegation : this.getDelegationRules()) {
                WebRuleBaseValues webRule = new WebRuleBaseValues();
                webRule.load(ruleDelegation.getDelegationRule());
                webRule.edit(ruleDelegation.getDelegationRule());
                ruleDelegation.setDelegationRule(webRule);
            }
        }
    }

    public RuleDelegationBo addNewDelegation() {
        RuleDelegationBo ruleDelegation = new RuleDelegationBo();
        ruleDelegation.setDelegationRule(new WebRuleBaseValues());
        ruleDelegation.setDelegationType(DelegationType.PRIMARY);
        ruleDelegation.getDelegationRule().setDelegateRule(Boolean.TRUE);
        ruleDelegation.getDelegationRule().setDocTypeName(this.getRuleBaseValues().getDocTypeName());
        this.getDelegationRules().add(ruleDelegation);
        this.showDelegations = true;
        return ruleDelegation;
    }

    public String getReviewer() {
        return this.reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public void setWorkgroupId(String workgroupId) {
        Group workgroup = KimApiServiceLocator.getGroupService().getGroup(workgroupId);
        if (workgroup != null) {
            this.setReviewer(workgroup.getName());
        } else {
            this.setReviewer("");
        }
    }

    public String getPersonLookupStyle() {
        return this.personLookupStyle;
    }

    public void setPersonLookupStyle(String personLookupStyle) {
        this.personLookupStyle = personLookupStyle;
    }

    public String getReviewerStyle() {
        return this.reviewerStyle;
    }

    public void setReviewerStyle(String reviewerStyle) {
        this.reviewerStyle = reviewerStyle;
    }

    public String getRoleAreaStyle() {
        return this.roleAreaStyle;
    }

    public void setRoleAreaStyle(String roleAreaLookupStyle) {
        this.roleAreaStyle = roleAreaLookupStyle;
    }

    public String getWorkgroupLookupStyle() {
        return this.workgroupLookupStyle;
    }

    public void setWorkgroupLookupStyle(String workgroupLookupStyle) {
        this.workgroupLookupStyle = workgroupLookupStyle;
    }

    @Override
    public RuleDelegationBo getDelegationRule(int index) {
        while (this.getDelegationRules().size() <= index) {
            this.addNewDelegation();
        }
        return this.getDelegationRules().get(index);
    }

    public int getNumberOfDelegations() {
        return this.numberOfDelegations;
    }

    public void setNumberOfDelegations(int numberOfDelegations) {
        this.numberOfDelegations = numberOfDelegations;
    }

    public boolean isDelegationRulesMaterialized() {
        return this.delegationRulesMaterialized;
    }

    public void setDelegationRulesMaterialized(boolean isDelegationRulesMaterialized) {
        this.delegationRulesMaterialized = isDelegationRulesMaterialized;
    }

    public String getRoleReviewer() {
        return this.roleReviewer;
    }

    public void setRoleReviewer(String roleReviewer) {
        this.roleReviewer = roleReviewer;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isShowDelegations() {
        return this.showDelegations;
    }

    public void setShowDelegations(boolean showDelegations) {
        this.showDelegations = showDelegations;
    }

    public void establishRequiredState() throws Exception {
        if ("F".equals(this.getRuleResponsibilityType())) {
            this.reviewerStyle = DISPLAY_INLINE;
            this.personLookupStyle = DISPLAY_INLINE;
            this.workgroupLookupStyle = DISPLAY_NONE;
            this.roleAreaStyle = DISPLAY_NONE;
        }
        if ("G".equals(this.getRuleResponsibilityType())) {
            this.reviewerStyle = DISPLAY_INLINE;
            this.personLookupStyle = DISPLAY_NONE;
            this.workgroupLookupStyle = DISPLAY_INLINE;
            this.roleAreaStyle = DISPLAY_NONE;
        }
        if ("R".equals(this.getRuleResponsibilityType())) {
            this.reviewerStyle = DISPLAY_NONE;
            this.personLookupStyle = DISPLAY_NONE;
            this.workgroupLookupStyle = DISPLAY_NONE;
            this.roleAreaStyle = DISPLAY_INLINE;
        }
        this.loadWebValues();
        if (this.delegationRulesMaterialized) {
            for (RuleDelegationBo delegation : this.getDelegationRules()) {
                ((WebRuleBaseValues)delegation.getDelegationRule()).establishRequiredState();
            }
        }
    }

    public void edit(RuleResponsibilityBo ruleResponsibility) throws Exception {
        this.load(ruleResponsibility);
        this.initialize();
    }

    public void load(RuleResponsibilityBo ruleResponsibility) throws Exception {
        PropertyUtils.copyProperties((Object)((Object)this), (Object)((Object)ruleResponsibility));
        this.injectWebMembers();
    }

    public void loadDelegations() throws Exception {
        this.fetchDelegations();
        for (RuleDelegationBo ruleDelegation : this.getDelegationRules()) {
            WebRuleBaseValues webRule = new WebRuleBaseValues();
            webRule.edit(ruleDelegation.getDelegationRule());
            ruleDelegation.setDelegationRule(webRule);
        }
        this.delegationRulesMaterialized = true;
        this.populatePreviousRuleIds();
    }

    public void populatePreviousRuleIds() {
        if (this.delegationRulesMaterialized) {
            for (RuleDelegationBo delegation : this.getDelegationRules()) {
                ((WebRuleBaseValues)delegation.getDelegationRule()).populatePreviousRuleIds();
            }
        }
    }

    private void fetchDelegations() {
        if (this.getId() != null) {
            RuleResponsibilityBo responsibility = this.getRuleService().findByRuleResponsibilityId(this.getId());
            if (responsibility == null) {
                return;
            }
            this.getDelegationRules().addAll(responsibility.getDelegationRules());
        }
    }

    public void prepareHiddenDelegationsForRoute() {
        if (this.showDelegations) {
            return;
        }
        this.fetchDelegations();
        for (RuleDelegationBo delegation : this.getDelegationRules()) {
            delegation.setDelegateRuleId(null);
            delegation.setVersionNumber(null);
            delegation.setRuleDelegationId(null);
            delegation.setResponsibilityId(null);
            RuleBaseValues rule = delegation.getDelegationRule();
            rule.setVersionNumber(null);
            rule.setPreviousRuleId(rule.getId());
            rule.setDocumentId(null);
            rule.setId(null);
            for (RuleResponsibilityBo responsibility : rule.getRuleResponsibilities()) {
                responsibility.setVersionNumber(null);
                responsibility.setRuleBaseValuesId(null);
                responsibility.setRuleBaseValues(rule);
                responsibility.setId(null);
            }
            for (RuleExtensionBo extension : rule.getRuleExtensions()) {
                extension.setVersionNumber(null);
                extension.setRuleBaseValues(rule);
                extension.setRuleBaseValuesId(null);
                extension.setRuleExtensionId(null);
                for (RuleExtensionValue value : extension.getExtensionValues()) {
                    value.setExtension(extension);
                    value.setLockVerNbr(null);
                    value.getExtension().setRuleExtensionId(null);
                    value.setRuleExtensionValueId(null);
                }
            }
        }
    }

    public boolean isHasDelegateRuleTemplate() {
        return this.hasDelegateRuleTemplate;
    }

    public void setHasDelegateRuleTemplate(boolean hasDelegateRuleTemplate) {
        this.hasDelegateRuleTemplate = hasDelegateRuleTemplate;
    }

    private RuleServiceInternal getRuleService() {
        return (RuleServiceInternal)KEWServiceLocator.getService("enRuleServiceInternal");
    }

    private class DelegationRulesProxy
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 7046323200221509473L;
        private List delegationRules;

        public DelegationRulesProxy(List delegationRules) {
            this.delegationRules = delegationRules;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            if (!(WebRuleResponsibility.this.delegationRulesMaterialized || m.getName().equals("isEmpty") || m.getName().equals("size"))) {
                for (RuleDelegationBo ruleDelegation : this.delegationRules) {
                    WebRuleBaseValues webRule = new WebRuleBaseValues();
                    webRule.load(ruleDelegation.getDelegationRule());
                    webRule.establishRequiredState();
                    ruleDelegation.setDelegationRule(webRule);
                }
                WebRuleResponsibility.this.delegationRulesMaterialized = true;
            }
            return m.invoke((Object)this.delegationRules, args);
        }
    }
}

