/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;

public class GroupXmlExporter
implements XmlExporter {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private XmlRenderer renderer = new XmlRenderer(XmlConstants.GROUP_NAMESPACE);

    public boolean supportPrettyPrint() {
        return true;
    }

    public Element export(ExportDataSet exportDataSet) {
        KewExportDataSet dataSet = KewExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getGroups().isEmpty()) {
            Element rootElement = this.renderer.renderElement(null, "groups");
            rootElement.setAttribute("schemaLocation", "ns:workflow/Group resource:Group", XmlConstants.SCHEMA_NAMESPACE);
            for (Group group : dataSet.getGroups()) {
                this.exportGroup(rootElement, group);
            }
            return rootElement;
        }
        return null;
    }

    private void exportGroup(Element parent, Group group) {
        Element groupElement = this.renderer.renderElement(parent, "group");
        if (group.getName() != null) {
            this.renderer.renderTextElement(groupElement, "name", group.getName());
        }
        if (group.getNamespaceCode() != null) {
            this.renderer.renderTextElement(groupElement, "namespace", group.getNamespaceCode());
        }
        if (group.getDescription() != null && !group.getDescription().trim().equals("")) {
            this.renderer.renderTextElement(groupElement, "description", group.getDescription());
        }
        this.renderer.renderTextElement(groupElement, "active", new Boolean(group.isActive()).toString());
        if (group.getKimTypeId() != null) {
            Element typeElement = this.renderer.renderElement(groupElement, "type");
            KimType kimType = KimApiServiceLocator.getKimTypeInfoService().getKimType(group.getKimTypeId());
            this.renderer.renderTextElement(typeElement, "namespace", kimType.getNamespaceCode());
            this.renderer.renderTextElement(typeElement, "name", kimType.getName());
        }
        if (group.getAttributes().size() > 0) {
            Element attributesElement = this.renderer.renderElement(groupElement, "attributes");
            for (String key : group.getAttributes().keySet()) {
                Element attributeElement = this.renderer.renderElement(attributesElement, "attribute");
                attributeElement.setAttribute("key", key);
                attributeElement.setAttribute("value", (String)group.getAttributes().get(key));
            }
        }
        List memberGroupIds = KimApiServiceLocator.getGroupService().getDirectMemberGroupIds(group.getId());
        List memberPrincipalIds = KimApiServiceLocator.getGroupService().getDirectMemberPrincipalIds(group.getId());
        if (memberGroupIds.size() > 0 || memberPrincipalIds.size() > 0) {
            Element membersElement = this.renderer.renderElement(groupElement, "members");
            for (String memberGroupId : memberGroupIds) {
                Group memberGroup = KimApiServiceLocator.getGroupService().getGroup(memberGroupId);
                Element groupNameElement = this.renderer.renderElement(membersElement, "groupName");
                this.renderer.renderTextElement(groupNameElement, "name", memberGroup.getName());
                this.renderer.renderTextElement(groupNameElement, "namespace", memberGroup.getNamespaceCode());
            }
            for (String memberPrincipalId : memberPrincipalIds) {
                this.renderer.renderTextElement(membersElement, "principalName", KimApiServiceLocator.getIdentityService().getPrincipal(memberPrincipalId).getPrincipalName());
            }
        }
    }
}

