/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document.authorization;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kns.document.authorization.TransactionalDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;

public class IdentityManagementKimDocumentAuthorizer
extends TransactionalDocumentAuthorizerBase {
    public Map<String, Set<String>> getUnpopulateableGroups(Document document, Person user) {
        HashMap<String, Set<String>> unpopulateableGroups = new HashMap<String, Set<String>>();
        for (PersonDocumentGroup personDocumentGroup : ((IdentityManagementPersonDocument)document).getGroups()) {
            HashMap<String, String> collectionOrFieldLevelPermissionDetails = new HashMap<String, String>();
            collectionOrFieldLevelPermissionDetails.put("namespaceCode", personDocumentGroup.getNamespaceCode());
            collectionOrFieldLevelPermissionDetails.put("groupName", personDocumentGroup.getGroupName());
            if (this.isAuthorizedByTemplate(document, "KR-IDM", "Populate Group", user.getPrincipalId(), collectionOrFieldLevelPermissionDetails, null)) continue;
            if (!unpopulateableGroups.containsKey(personDocumentGroup.getNamespaceCode())) {
                unpopulateableGroups.put(personDocumentGroup.getNamespaceCode(), new HashSet());
            }
            ((Set)unpopulateableGroups.get(personDocumentGroup.getNamespaceCode())).add(personDocumentGroup.getGroupName());
        }
        return unpopulateableGroups;
    }

    public Map<String, Set<String>> getUnassignableRoles(Document document, Person user) {
        HashMap<String, Set<String>> unassignableRoles = new HashMap<String, Set<String>>();
        for (PersonDocumentRole personDocumentRole : ((IdentityManagementPersonDocument)document).getRoles()) {
            HashMap<String, String> collectionOrFieldLevelPermissionDetails = new HashMap<String, String>();
            collectionOrFieldLevelPermissionDetails.put("namespaceCode", personDocumentRole.getNamespaceCode());
            collectionOrFieldLevelPermissionDetails.put("roleName", personDocumentRole.getRoleName());
            if (this.isAuthorizedByTemplate(document, "KR-IDM", "Assign Role", user.getPrincipalId(), collectionOrFieldLevelPermissionDetails, null)) continue;
            if (!unassignableRoles.containsKey(personDocumentRole.getNamespaceCode())) {
                unassignableRoles.put(personDocumentRole.getNamespaceCode(), new HashSet());
            }
            ((Set)unassignableRoles.get(personDocumentRole.getNamespaceCode())).add(personDocumentRole.getRoleName());
        }
        return unassignableRoles;
    }
}

